/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxcontrols.dock.ResizeButton;
import org.jhotdraw8.fxcontrols.dock.TrackAxis;

public class ResizePane
extends BorderPane {
    private final BooleanProperty userResizable = new SimpleBooleanProperty(true);
    private final ResizeButton rb = new ResizeButton();

    public ResizePane() {
        this.rb.setTarget((Region)this);
        this.setBottom((Node)this.rb);
        this.rb.visibleProperty().bind((ObservableValue)this.userResizable);
    }

    public void setResizeAxis(TrackAxis axis) {
        switch (axis) {
            case X: {
                this.rb.setCursor(Cursor.H_RESIZE);
                this.setBottom(null);
                this.setRight((Node)this.rb);
                break;
            }
            default: {
                this.rb.setCursor(Cursor.V_RESIZE);
                this.setRight(null);
                this.setBottom((Node)this.rb);
            }
        }
    }

    public boolean isUserResizable() {
        return this.userResizable.get();
    }

    public void setUserResizable(boolean value) {
        this.userResizable.set(value);
    }

    public @NonNull BooleanProperty userResizableProperty() {
        return this.userResizable;
    }
}

