/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxcontrols.dock.AbstractDockParent;
import org.jhotdraw8.fxcontrols.dock.DockChild;
import org.jhotdraw8.fxcontrols.dock.DockParent;
import org.jhotdraw8.fxcontrols.dock.Dockable;
import org.jhotdraw8.fxcontrols.dock.DockableDragHandler;
import org.jhotdraw8.fxcontrols.dock.ResizePane;
import org.jhotdraw8.fxcontrols.dock.Track;
import org.jhotdraw8.fxcontrols.dock.TrackAxis;

public class TabPaneTrack
extends AbstractDockParent
implements Track {
    private final TabPane tabPane = new TabPane();
    private final @NonNull ResizePane resizePane = new ResizePane();

    public TabPaneTrack() {
        this.getChildren().add((Object)this.resizePane);
        this.resizePane.setCenter((Node)this.tabPane);
        SplitPane.setResizableWithParent((Node)this, (Boolean)Boolean.FALSE);
        VBox.setVgrow((Node)this, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this, (Priority)Priority.NEVER);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.dockParentProperty().addListener(this.onParentChanged());
        CustomBinding.bindContentBidirectional((ObservableList)this.tabPane.getTabs(), this.getDockChildren(), this::makeTab, k -> ((MyTab)((Object)k)).dispose(), tab -> ((MyTab)tab).dockChild, null);
        CustomBinding.bind((ObservableValue)this.tabPane.getSelectionModel().selectedItemProperty(), t -> ((MyTab)((Object)t)).showingProperty(), (ObservableValue)this.showingProperty(), (Object)false);
    }

    protected @NonNull ChangeListener<DockParent> onParentChanged() {
        return (o, oldv, newv) -> {
            this.resizePane.setUserResizable(newv != null && !newv.isResizesDockChildren());
            this.resizePane.setResizeAxis(newv == null ? TrackAxis.Y : newv.getDockAxis());
        };
    }

    private @NonNull MyTab makeTab(DockChild c) {
        if (c instanceof Dockable) {
            Dockable k = (Dockable)c;
            MyTab tab = new MyTab(k, k.getText(), k.getNode());
            tab.graphicProperty().bind((ObservableValue)CustomBinding.compute(k::getGraphic, (ObservableValue[])new ObservableValue[]{k.graphicProperty(), this.editableProperty()}));
            return tab;
        }
        return new MyTab(c, "-", c.getNode());
    }

    @Override
    public @NonNull TrackAxis getDockAxis() {
        return TrackAxis.Z;
    }

    @Override
    public boolean isResizesDockChildren() {
        return true;
    }

    static class MyTab
    extends Tab {
        private final DockableDragHandler dockableDragHandler;
        private final @NonNull DockChild dockChild;

        MyTab(@NonNull DockChild dockChild, @Nullable String text, @Nullable Node graphic) {
            super(text, graphic);
            this.dockChild = dockChild;
            this.dockableDragHandler = dockChild instanceof Dockable ? new DockableDragHandler((Dockable)dockChild) : null;
        }

        BooleanProperty showingProperty() {
            return this.dockChild.showingProperty();
        }

        void dispose() {
            if (this.dockableDragHandler != null) {
                this.dockableDragHandler.dispose();
            }
        }

        public String toString() {
            return "MyTab@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "{" + String.valueOf(this.dockChild) + "}";
        }
    }
}

