/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.fontchooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.text.Font;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.resources.ModulepathResources;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.fxcontrols.fontchooser.FontCollection;
import org.jhotdraw8.fxcontrols.fontchooser.FontCollectionsFactory;
import org.jhotdraw8.fxcontrols.fontchooser.FontDialog;
import org.jhotdraw8.fxcontrols.fontchooser.FontFamily;
import org.jhotdraw8.fxcontrols.fontchooser.FontTypeface;

public class DefaultFontCollectionsFactory
implements FontCollectionsFactory {
    @Override
    public @NonNull List<FontCollection> create() {
        return this.generateCollections(this.loadFonts());
    }

    protected @NonNull List<FontFamily> loadFonts() {
        ArrayList<FontFamily> allFamilies = new ArrayList<FontFamily>();
        List familyNames = Font.getFamilies();
        Collections.sort(familyNames);
        for (String familyName : familyNames) {
            FontFamily fontFamily = new FontFamily();
            fontFamily.setName(familyName);
            allFamilies.add(fontFamily);
            List fontNames = Font.getFontNames((String)familyName);
            for (String fontName : fontNames) {
                String styleDescription;
                FontTypeface fontTypeface = new FontTypeface();
                String string = styleDescription = fontName.startsWith(familyName) ? fontName.substring(familyName.length()).trim() : fontName;
                if (styleDescription.isEmpty()) {
                    styleDescription = "Regular";
                }
                switch (styleDescription) {
                    case "Regular": 
                    case "Plain": 
                    case "Roman": {
                        fontTypeface.setRegular(true);
                    }
                }
                fontTypeface.setName(fontName);
                fontTypeface.setStyle(styleDescription);
                fontFamily.getTypefaces().add((Object)fontTypeface);
            }
            fontFamily.getTypefaces().sort(Comparator.comparing(FontTypeface::getName));
        }
        return allFamilies;
    }

    protected @NonNull ObservableList<FontCollection> generateCollections(@NonNull List<FontFamily> families) {
        ObservableList collections = FXCollections.observableArrayList();
        Resources labels = ModulepathResources.getResources((Module)FontDialog.class.getModule(), (String)"org.jhotdraw8.fxcontrols.spi.labels");
        FontCollection allFonts = new FontCollection(labels.getString("FontCollection.allFonts"), true, families);
        collections.add((Object)allFonts);
        collections.add((Object)new FontCollection(labels.getString("FontCollection.web"), true, DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Arial", "Arial Black", "Andale Mono", "Courier New", "Comic Sans MS", "Georgia", "Impact", "Times New Roman", "Trebuchet MS", "Verdana", "Webdings")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.pdf"), true, DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Courier", "Helvetica", "Symbol", "Times", "Zapf Dingbats")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.system"), true, DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Dialog", "DialogInput", "Monospaced", "SansSerif", "Serif", "System")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.serif"), DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Bodoni 72", "Bodoni 72 Oldstyle", "Bodoni 72 Smallcaps", "Didot", "Adobe Caslon Pro", "Adobe Garamond Pro", "American Typewriter", "Arno Pro", "Baskerville", "Baskerville Old Face", "Bell MT", "Big Caslon", "Bodoni SvtyTwo ITC TT", "Bodoni SvtyTwo OS ITC TT", "Bodoni SvtyTwo SC ITC TT", "Book Antiqua", "Bookman Old Style", "Calisto MT", "Chaparral Pro", "Century", "Century Schoolbook", "Cochin", "Footlight MT Light", "Garamond", "Garamond Premier Pro", "Georgia", "Goudy Old Style", "Hoefler Text", "Lucida Bright", "Lucida Fax", "Minion Pro", "Palatino", "Times", "Times New Roman", "Andalus", "Angsana New", "AngsanaUPC", "Arabic Typesetting", "Cambria", "Cambria Math", "Constantia", "DaunPenh", "David", "DilleniaUPC", "EucrosiaUPC", "Frank Ruehl", "IrisUPC", "Iskoola Pota", "JasmineUPC", "KodchiangUPC", "Narkisim", "Palatino Linotype", "Bitstream Vera Serif Bold", "Bodoni MT", "Bodoni MT Black", "Bodoni MT Condensed", "Californian FB", "Cambria", "Cambria Math", "Centaur", "High Tower Text", "Perpetua", "Poor Richard", "Rockwell Condensed", "Slimbach-Black", "Slimbach-BlackItalic", "Slimbach-Bold", "Slimbach-BoldItalic", "Slimbach-Book", "Slimbach-BookItalic", "Slimbach-Medium", "Slimbach-MediumItalic", "Sylfaen")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.sansSerif"), DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Charcoal", "Euphemia UCAS", "Abadi MT Condensed Extra Bold", "Abadi MT Condensed Light", "AppleGothic", "Arial", "Arial Black", "Arial Narrow", "Arial Rounded MT Bold", "Arial Unicode MS", "Bell Gothic Std", "Blair MdITC TT", "Century Gothic", "Frutiger", "Futura", "Geneva", "Gill Sans", "Gulim", "Helvetica", "Helvetica Neue", "Lucida Grande", "Lucida Sans", "Microsoft Sans Serif", "Myriad Pro", "News Gothic", "Tahoma", "Trebuchet MS", "Verdana", "Bahnschrift", "Aharoni", "Browallia New", "BrowalliaUPC", "Calibri", "Candara", "Corbel", "Cordia New", "CordiaUPC", "DokChampa", "Dotum", "Estrangelo Edessa", "Euphemia", "Freesia UPC", "Gautami", "Gisha", "Kalinga", "Kartika", "Levenim MT", "LilyUPC", "Malgun Gothic", "Meiryo", "Miriam", "Segoe UI", "Agency FB", "Berlin Sans FB Demi Bold", "Berlin Sans FB", "Bitstream Vera Sans Bold", "Corbel", "Eras Bold ITC", "Eras Demi ITC", "Eras Light ITC", "Eras Medium ITC", "Estrangelo Edessa", "Franklin Gothic Book", "Franklin Gothic Demi Cond", "Franklin Gothic Demi", "Franklin Gothic Heavy", "Franklin Gothic Medium Cond", "Franklin Gothic Medium", "Gill Sans MT Condensed", "Gill Sans MT Ext Condensed Bold", "Gill Sans MT", "Lucida Sans Unicode", "MS Reference Sans", "Maiandra GD", "Tw Cen MT Condensed Extra Bold", "Tw Cen MT Condensed", "Tw Cen MT")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.script"), DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Apple Chancery", "Bickham Script Pro", "Blackmoor LET", "Bradley Hand ITC TT", "Brush Script MT", "Brush Script Std", "Chalkboard", "Charlemagne Std", "Comic Sans MS", "Curlz MT", "Edwardian Script ITC", "Footlight MT Light", "Giddyup Std", "Handwriting - Dakota", "Harrington", "Herculanum", "Lithos Pro", "Lucida Blackletter", "Lucida Calligraphy", "Lucida Handwriting", "Marker Felt", "Matura MT Script Capitals", "Mistral", "Monotype Corsiva", "Party LET", "Papyrus", "Santa Fe LET", "Savoye LET", "SchoolHouse Cursive B", "SchoolHouse Printed A", "Skia", "Snell Roundhand", "Tekton Pro", "Trajan Pro", "Zapfino", "Casual", "Chalkduster", "Bradley Hand", "Noteworthy", "Trattatello", "Ink Free", "Segoe Print", "Segoe Script", "Blackadder ITC", "Bradley Hand ITC", "Chiller", "Freestyle Script", "French Script MT", "Gigi", "Harlow Solid Italic", "Informal Roman", "Juice ITC", "Kristen ITC", "Kunstler Script", "Magneto Bold", "Maiandra GD", "Old English Text", "Palace Script MT", "Parchment", "Pristina", "Rage Italic", "Ravie", "Script MT Bold", "Tempus Sans ITC", "Viner Hand ITC", "Vivaldi Italic", "Vladimir Script")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.monospaced"), DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Andale Mono", "Courier", "Courier New", "Letter Gothic Std", "Lucida Sans Typewriter", "Monaco", "OCR A Std", "Orator Std", "Prestige Elite Std", "Menlo", "Lucida Console", "Bitstream Vera S...", "OCR A Extended", "OCR B", "Consolas", "DotumChe", "Miriam Fixed", "Rod")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.decorative"), DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Academy Engraved LET", "Arial Black", "Bank Gothic", "Bauhaus 93", "Bernard MT Condensed", "Birch Std", "Blackoak Std", "BlairMdITC TT", "Bordeaux Roman Bold LET", "Braggadocio", "Britannic Bold", "Capitals", "Colonna MT", "Cooper Black", "Cooper Std", "Copperplate", "Copperplate Gothic Bold", "Copperplate Gothic Light", "Cracked", "Desdemona", "Didot", "Eccentric Std", "Engravers MT", "Eurostile", "Gill Sans Ultra Bold", "Gloucester MT Extra Condensed", "Haettenschweiler", "Hobo Std", "Impact", "Imprint MT Shadow", "Jazz LET", "Kino MT", "Matura MT Script Capitals", "Mesquite Std", "Modern No. 20", "Mona Lisa Solid ITC TT", "MS Gothic", "Nueva Std", "Onyx", "Optima", "Perpetua Titling MT", "Playbill", "Poplar Std", "PortagoITC TT", "Princetown LET", "Rockwell", "Rockwell Extra Bold", "Rosewood Std", "Santa Fe LET", "Stencil", "Stencil Std", "Stone Sans ITC TT", "Stone Sans OS ITC TT", "Stone Sans Sem ITC TT", "Stone Sans Sem OS ITCTT", "Stone Sans Sem OS ITC TT", "Synchro LET", "Wide Latin", "HeadLineA", "Phosphate", "Algerian", "Bodoni MT Black", "Bodoni MT Poster Compressed", "Broadway", "Castellar", "Elephant", "Felix Titling", "Franklin Gothic Heavy", "Gill Sans MT Ext Condensed Bold", "Gill Sans Ultra Bold Condensed", "Goudy Stout", "Jokerman", "Juice ITC", "Magneto", "Magneto Bold", "Niagara Engraved", "Niagara Solid", "Poor Richard", "Ravie", "Rockwell Condensed", "Showcard Gothic", "Slimbach-Black", "Slimbach-BlackItalic", "Snap ITC")));
        collections.add((Object)new FontCollection(labels.getString("FontCollection.symbols"), DefaultFontCollectionsFactory.collectFamiliesNamed(families, "Apple Symbols", "Blackoack Std", "Bodoni Ornaments ITC TT", "EuropeanPi", "Monotype Sorts", "MT Extra", "Symbol", "Type Embellishments One LET", "Webdings", "Wingdings", "Wingdings 2", "Wingdings 3", "Zapf Dingbats", "Bodoni Ornaments", "Bookshelf Symbol")));
        return collections;
    }

    public static @NonNull ArrayList<FontFamily> collectFamiliesNamed(@NonNull List<FontFamily> allFamilies, String ... names) {
        ArrayList<FontFamily> coll = new ArrayList<FontFamily>();
        HashSet<String> nameMap = new HashSet<String>(Arrays.asList(names));
        for (FontFamily family : allFamilies) {
            if (!nameMap.contains(family.getName())) continue;
            coll.add(family);
        }
        return coll;
    }
}

