/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.fontchooser;

import java.util.Collection;
import java.util.function.Supplier;
import javafx.application.Platform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxcontrols.fontchooser.DefaultFontCollectionsFactory;
import org.jhotdraw8.fxcontrols.fontchooser.FontChooserModel;
import org.jhotdraw8.fxcontrols.fontchooser.FontCollectionsFactory;
import org.jhotdraw8.fxcontrols.fontchooser.MacOSFontCollectionsFactory;
import org.jhotdraw8.os.macos.MacOSPreferencesUtil;

public class FontChooserModelFactories {
    private static Supplier<FontCollectionsFactory> singleton = MacOSPreferencesUtil.isMacOs() ? MacOSFontCollectionsFactory::new : DefaultFontCollectionsFactory::new;

    private FontChooserModelFactories() {
    }

    public static Supplier<FontCollectionsFactory> getSingleton() {
        return singleton;
    }

    public static void setSingleton(Supplier<FontCollectionsFactory> singleton) {
        FontChooserModelFactories.singleton = singleton;
    }

    public static @NonNull FontChooserModel create() {
        FontChooserModel model = new FontChooserModel();
        if (Platform.isFxApplicationThread()) {
            singleton.get().createAsync().thenAccept(m -> model.getFontCollections().addAll((Collection)m));
        } else {
            model.getFontCollections().addAll(singleton.get().create());
        }
        return model;
    }
}

