/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.fontchooser;

import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.AccessibleAction;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.ModulepathResources;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.fxcontrols.fontchooser.FontChooserController;
import org.jhotdraw8.fxcontrols.fontchooser.FontChooserModel;
import org.jhotdraw8.fxcontrols.fontchooser.FontChooserModelFactories;
import org.jhotdraw8.fxcontrols.fontchooser.FontFamilySize;

public class FontDialog
extends Dialog<FontFamilySize> {
    private FontChooserController controller;
    private static @Nullable FontChooserModel model = null;

    public FontDialog() {
        Resources labels = ModulepathResources.getResources((Module)FontDialog.class.getModule(), (String)"org.jhotdraw8.fxcontrols.spi.labels");
        DialogPane dialogPane = this.getDialogPane();
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(FontDialog.class.getResource("FontChooser.fxml"));
            loader.setResources(labels.asResourceBundle());
            loader.load();
            Parent root = (Parent)loader.getRoot();
            dialogPane.setContent((Node)root);
            root.getStylesheets().add((Object)FontDialog.class.getResource("fontchooser.css").toString());
            this.controller = (FontChooserController)loader.getController();
        }
        catch (IOException ex) {
            dialogPane.setContent((Node)new Label(ex.getMessage()));
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
        }
        this.setResizable(true);
        ButtonType chooseButtonType = new ButtonType(labels.getTextProperty("FontChooser.choose"), ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType(labels.getTextProperty("FontChooser.cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{chooseButtonType, cancelButtonType});
        this.setResultConverter(this::onButton);
        this.controller.setOnAction((EventHandler<ActionEvent>)((EventHandler)evt -> dialogPane.lookupButton(chooseButtonType).executeAccessibleAction(AccessibleAction.FIRE, new Object[0])));
        this.controller.setModel(FontDialog.getModel());
    }

    public static @Nullable FontChooserModel getModel() {
        if (model == null) {
            model = FontChooserModelFactories.create();
        }
        return model;
    }

    private @Nullable FontFamilySize onButton(@Nullable ButtonType buttonType) {
        if (buttonType != null && buttonType.getButtonData() == ButtonBar.ButtonData.OK_DONE) {
            String selectedFontName = this.controller.getSelectedFontName();
            double fontSize = this.controller.getFontSize();
            return new FontFamilySize(selectedFontName, fontSize);
        }
        return null;
    }

    public void selectFontName(String fontName) {
        this.controller.setFontName(fontName);
    }

    public final Optional<FontFamilySize> showAndWait(@Nullable FontFamilySize font) {
        if (font != null) {
            this.selectFontName(font.family());
            this.controller.setFontSize(font.size());
        }
        return this.showAndWait();
    }
}

