/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.scene.image.PixelBuffer;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.base.concurrent.TileTask;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.fxcontrols.colorchooser.AbstractColorSlider;
import org.jspecify.annotations.Nullable;

public class AlphaSlider
extends AbstractColorSlider {
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)Orientation.HORIZONTAL);
    private final FloatProperty alpha = new SimpleFloatProperty((Object)this, "alpha", 1.0f);
    private final FloatProperty alphaMaxValue = new SimpleFloatProperty((Object)this, "alphaMaxValue", 1.0f);
    private final FloatProperty alphaMinValue = new SimpleFloatProperty((Object)this, "alphaMinValue", 0.0f);
    private final DoubleProperty minorTickUnit = new SimpleDoubleProperty((Object)this, "minorTickUnit", 0.001);
    private final DoubleProperty majorTickUnit = new SimpleDoubleProperty((Object)this, "majorTickUnit", 0.01);

    public AlphaSlider() {
        this.load();
    }

    @Override
    void initialize() {
        super.initialize();
        InvalidationListener handler = o -> this.invalidate();
        this.c0Property().addListener(handler);
        this.c1Property().addListener(handler);
        this.c2Property().addListener(handler);
        this.c3Property().addListener(handler);
        this.alphaMaxValueProperty().addListener(handler);
        this.alphaMinValueProperty().addListener(handler);
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        double width = this.getWidth();
        double height = this.getHeight();
        float vmax = this.getAlphaMaxValue();
        float vmin = this.getAlphaMinValue();
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.thumb.setTranslateX((double)(this.getAlpha() - vmin) * width / (double)(vmax - vmin) - this.thumb.getWidth() * 0.5 + this.thumbTranslateX.get());
                this.thumb.setTranslateY((height - this.thumb.getHeight()) * 0.5 + this.thumbTranslateY.get());
                break;
            }
            case VERTICAL: {
                this.thumb.setTranslateY(height - (double)(this.getAlpha() - vmin) * height / (double)(vmax - vmin) - this.thumb.getHeight() * 0.5 + this.thumbTranslateX.get());
                this.thumb.setTranslateX((width - this.thumb.getWidth()) * 0.5 + this.thumbTranslateY.get());
            }
        }
    }

    @Override
    protected @Nullable AbstractColorSlider.AbstractFillTask createFillTask(PixelBuffer<IntBuffer> pixelBuffer) {
        if (this.getDisplayColorSpace() == null || this.getTargetColorSpace() == null) {
            return null;
        }
        return new FillTask(new AbstractColorSlider.FillTaskRecord(Objects.requireNonNull(pixelBuffer), this.getSourceColorSpace(), this.getTargetColorSpace(), this.getDisplayColorSpace(), this.getC0(), this.getC1(), this.getC2(), this.getC3(), 4, -1, 1.0f, this.getRgbFilter() == null ? i -> i : this.getRgbFilter()), this.getOrientation(), this.getAlphaMinValue(), this.getAlphaMaxValue());
    }

    @Override
    protected void onMousePressedOrDragged(MouseEvent mouseEvent) {
        this.requestFocus();
        float width = (float)this.getWidth();
        float height = (float)this.getHeight();
        float x = MathUtil.clamp((float)((float)mouseEvent.getX()), (float)0.0f, (float)width);
        float y = MathUtil.clamp((float)((float)mouseEvent.getY()), (float)0.0f, (float)height);
        float vmax = this.getAlphaMaxValue();
        float vmin = this.getAlphaMinValue();
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.setAlpha(this.maybeSnapToTicks(x * (vmax - vmin) / width + vmin, this.getMinorTickUnit(), mouseEvent));
                break;
            }
            case VERTICAL: {
                this.setAlpha(this.maybeSnapToTicks((height - y) * (vmax - vmin) / height + vmin, this.getMinorTickUnit(), mouseEvent));
            }
        }
        this.requestLayout();
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public double getMinorTickUnit() {
        return this.minorTickUnit.get();
    }

    public DoubleProperty minorTickUnitProperty() {
        return this.minorTickUnit;
    }

    public void setMinorTickUnit(double minorTickUnit) {
        this.minorTickUnit.set(minorTickUnit);
    }

    @Override
    public float getAlpha() {
        return this.alpha.get();
    }

    @Override
    public FloatProperty alphaProperty() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha.set(alpha);
    }

    public float getAlphaMaxValue() {
        return this.alphaMaxValue.get();
    }

    public FloatProperty alphaMaxValueProperty() {
        return this.alphaMaxValue;
    }

    public void setAlphaMaxValue(float alphaMaxValue) {
        this.alphaMaxValue.set(alphaMaxValue);
    }

    public float getAlphaMinValue() {
        return this.alphaMinValue.get();
    }

    public FloatProperty alphaMinValueProperty() {
        return this.alphaMinValue;
    }

    public void setAlphaMinValue(float alphaMinValue) {
        this.alphaMinValue.set(alphaMinValue);
    }

    @Override
    protected void onKeyPressed(KeyEvent keyEvent) {
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        double tickUnit = keyEvent.isAltDown() ? this.getMinorTickUnit() : this.getMajorTickUnit();
        float v = this.getAlpha();
        double vSnappedToTick = (double)Math.round((double)v / tickUnit) * tickUnit;
        float vMin = 0.0f;
        float vMax = 1.0f;
        switch (keyEvent.getCode()) {
            case UP: 
            case RIGHT: {
                keyEvent.consume();
                this.setAlpha(MathUtil.clamp((float)((float)(vSnappedToTick + tickUnit)), (float)vMin, (float)vMax));
                break;
            }
            case DOWN: 
            case LEFT: {
                keyEvent.consume();
                this.setAlpha(MathUtil.clamp((float)((float)(vSnappedToTick - tickUnit)), (float)vMin, (float)vMax));
                break;
            }
            case SPACE: {
                keyEvent.consume();
                this.setAlpha(MathUtil.clamp((float)((float)vSnappedToTick), (float)vMin, (float)vMax));
            }
        }
    }

    public double getMajorTickUnit() {
        return this.majorTickUnit.get();
    }

    public DoubleProperty majorTickUnitProperty() {
        return this.majorTickUnit;
    }

    public void setMajorTickUnit(double majorTickUnit) {
        this.majorTickUnit.set(majorTickUnit);
    }

    static class FillTask
    extends AbstractColorSlider.AbstractFillTask {
        private final Orientation orientation;
        private final float alphaMin;
        private final float alphaMax;

        public FillTask(AbstractColorSlider.FillTaskRecord record, Orientation orientation, float alphaMin, float alphaMax) {
            super(record);
            this.orientation = orientation;
            this.alphaMin = alphaMin;
            this.alphaMax = alphaMax;
        }

        @Override
        public void accept(TileTask.Tile tile) {
            if (this.orientation == Orientation.HORIZONTAL) {
                this.fillFineHorizontal(tile);
            } else {
                this.fillFineVertical(tile);
            }
        }

        public void fillFineHorizontal(TileTask.Tile tile) {
            PixelBuffer<IntBuffer> pixelBuffer = this.record.pixelBuffer();
            int width = pixelBuffer.getWidth();
            int height = pixelBuffer.getHeight();
            IntBuffer b = (IntBuffer)pixelBuffer.getBuffer();
            NamedColorSpace scs = this.record.sourceColorSpace();
            NamedColorSpace tcs = this.record.targetColorSpace();
            NamedColorSpace dcs = this.record.displayColorSpace();
            float xmin = this.alphaMin;
            float xmax = this.alphaMax;
            float invWidth = (xmax - xmin) / (float)width;
            float[] colorValue = new float[Math.max(4, scs.getNumComponents())];
            colorValue[0] = this.record.c0();
            colorValue[1] = this.record.c1();
            colorValue[2] = this.record.c2();
            colorValue[3] = this.record.c3();
            float[] sRgb = new float[3];
            float[] tRgb = new float[3];
            float[] dRgb = new float[3];
            float[] pre = new float[3];
            AbstractColorSlider.getArgb(scs, tcs, dcs, colorValue, sRgb, tRgb, dRgb, pre, 1.0f);
            int[] array = b.array();
            ToIntFunction<Integer> filter = this.record.rgbFilter();
            int yfrom = tile.yfrom();
            int yto = tile.yto();
            int xfrom = tile.xfrom();
            int xto = tile.xto();
            int xy = yfrom * width;
            for (int x = xfrom; x < xto; ++x) {
                float alpha = (float)x * invWidth + xmin;
                int argb = AbstractColorSlider.getPreArgb(dcs, dRgb, pre, alpha);
                array[x + xy] = argb = filter.applyAsInt(argb);
            }
            int y = yfrom + 1;
            int xyy = (yfrom + 1) * width;
            while (y < yto) {
                System.arraycopy(array, xy + xfrom, array, xyy + xfrom, xto - xfrom);
                ++y;
                xyy += width;
            }
        }

        public void fillFineVertical(TileTask.Tile tile) {
            PixelBuffer<IntBuffer> pixelBuffer = this.record.pixelBuffer();
            int width = pixelBuffer.getWidth();
            int height = pixelBuffer.getHeight();
            IntBuffer b = (IntBuffer)pixelBuffer.getBuffer();
            NamedColorSpace scs = this.record.sourceColorSpace();
            NamedColorSpace tcs = this.record.targetColorSpace();
            NamedColorSpace dcs = this.record.displayColorSpace();
            float ymin = this.alphaMin;
            float ymax = this.alphaMax;
            float invHeight = (ymax - ymin) / (float)height;
            float[] colorValue = new float[Math.max(4, scs.getNumComponents())];
            float[] sRgb = new float[3];
            float[] dRgb = new float[3];
            float[] tRgb = new float[3];
            float[] pre = new float[3];
            colorValue[0] = this.record.c0();
            colorValue[1] = this.record.c1();
            colorValue[2] = this.record.c2();
            colorValue[3] = this.record.c3();
            AbstractColorSlider.getArgb(scs, tcs, dcs, colorValue, sRgb, tRgb, dRgb, pre, 1.0f);
            int[] array = b.array();
            ToIntFunction<Integer> filter = this.record.rgbFilter();
            int yfrom = tile.yfrom();
            int yto = tile.yto();
            int xfrom = tile.xfrom();
            int xto = tile.xto();
            int y = yfrom;
            int xy = yfrom * width;
            while (y < yto) {
                float alpha = (float)(height - y) * invHeight + ymin;
                int argb = AbstractColorSlider.getPreArgb(dcs, dRgb, pre, alpha);
                argb = filter.applyAsInt(argb);
                Arrays.fill(array, xy + xfrom, xy + xto, argb);
                ++y;
                xy += width;
            }
        }
    }
}

