/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.ToIntFunction;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.jhotdraw8.color.NamedColor;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.fxbase.binding.Via;
import org.jhotdraw8.fxcontrols.colorchooser.AlphaChooser;
import org.jhotdraw8.fxcontrols.colorchooser.ColorChooserPaneModel;
import org.jhotdraw8.fxcontrols.colorchooser.HlsChooser;
import org.jhotdraw8.fxcontrols.colorchooser.SliderChooser;

public class ColorChooserPane
extends VBox {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private VBox chooserPane;
    @FXML
    private Label displayColorField;
    @FXML
    private Label sourceColorField;
    @FXML
    private ComboBox<NamedColorSpace> displayColorSpaceCombo;
    @FXML
    private ComboBox<Map.Entry<String, ToIntFunction<Integer>>> displayDepthCombo;
    @FXML
    private Region targetColorRegion;
    @FXML
    private TextField targetColorField;
    @FXML
    private ComboBox<NamedColorSpace> targetColorSpaceCombo;
    @FXML
    private ComboBox<ColorChooserPaneModel.ColorSyntax> targetSyntaxCombo;
    @FXML
    private ComboBox<ColorChooserPaneModel.ChooserType> chooserCombo;
    @FXML
    private Label targetLabel;
    private final ObjectProperty<NamedColor> value = new SimpleObjectProperty((Object)this, "value");
    private final ObjectProperty<ColorChooserPaneModel> model = new SimpleObjectProperty((Object)this, "model", (Object)new ColorChooserPaneModel());

    public ColorChooserPane() {
        this.load();
    }

    private void load() {
        try {
            FXMLLoader loader = new FXMLLoader(ColorChooserPane.getFxml());
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setResources(ResourceBundle.getBundle("org.jhotdraw8.fxcontrols.colorchooser.Labels"));
            loader.load();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static URL getFxml() {
        String name = "ColorChooserPane.fxml";
        return Objects.requireNonNull(ColorChooserPane.class.getResource(name), name);
    }

    @FXML
    void initialize() {
        assert (this.targetSyntaxCombo != null) : "fx:id=\"targetSyntaxCombo\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.chooserCombo != null) : "fx:id=\"chooserCombo\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.chooserPane != null) : "fx:id=\"alphaSliderPane\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.displayColorField != null) : "fx:id=\"displayColorField\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.displayColorSpaceCombo != null) : "fx:id=\"displayColorSpaceCombo\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.displayDepthCombo != null) : "fx:id=\"displayDepthCombo\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.targetColorRegion != null) : "fx:id=\"targetColorRegion\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.targetColorField != null) : "fx:id=\"targetColorField\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.sourceColorField != null) : "fx:id=\"sourceColorField\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.targetColorSpaceCombo != null) : "fx:id=\"targetColorSpaceCombo\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        assert (this.targetLabel != null) : "fx:id=\"targetLabel\" was not injected: check your FXML file 'ColorChooserPane.fxml'.";
        this.initSubPane();
        this.targetColorSpaceCombo.itemsProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSpacesProperty));
        this.displayColorSpaceCombo.itemsProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayColorSpacesProperty));
        this.displayDepthCombo.itemsProperty().bind(this.model.flatMap(ColorChooserPaneModel::displayBitDepthsProperty));
        this.targetSyntaxCombo.itemsProperty().bind(this.model.flatMap(ColorChooserPaneModel::targetColorSyntaxesProperty));
        this.chooserCombo.itemsProperty().bind(this.model.flatMap(ColorChooserPaneModel::colorChoosersProperty));
        this.targetColorSpaceCombo.valueProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::targetColorSpaceProperty).get());
        this.displayColorSpaceCombo.valueProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::displayColorSpaceProperty).get());
        this.displayDepthCombo.valueProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::displayBitDepthProperty).get());
        this.targetSyntaxCombo.valueProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::targetColorSyntaxProperty).get());
        this.chooserCombo.valueProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::chooserTypeProperty).get());
        this.targetColorField.textProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::targetColorFieldProperty).get());
        this.sourceColorField.textProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::sourceColorFieldProperty).get());
        this.displayColorField.textProperty().bindBidirectional(new Via(this.model).via(ColorChooserPaneModel::displayColorFieldProperty).get());
        this.model.flatMap(ColorChooserPaneModel::previewColorProperty).addListener(this::updatePreviewColor);
    }

    private void initSubPane() {
        HlsChooser hlsChooser = new HlsChooser();
        SliderChooser sliderChooser = new SliderChooser();
        AlphaChooser alphaChooser = new AlphaChooser();
        hlsChooser.modelProperty().bind(this.model);
        sliderChooser.modelProperty().bind(this.model);
        alphaChooser.modelProperty().bind(this.model);
        this.chooserPane.getChildren().setAll((Object[])new Node[]{hlsChooser, alphaChooser});
        VBox.setVgrow((Node)hlsChooser, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)sliderChooser, (Priority)Priority.ALWAYS);
    }

    private void updatePreviewColor(Observable o, Color oldv, Color newv) {
        Color previewColor = newv == null ? Color.TRANSPARENT : newv;
        this.targetColorRegion.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null), new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.5, Color.WHITE), new Stop(0.5, Color.BLACK)}), null, new Insets(4.0)), new BackgroundFill((Paint)previewColor, null, new Insets(4.0))}));
    }

    public ColorChooserPaneModel getModel() {
        return (ColorChooserPaneModel)this.model.get();
    }

    public ObjectProperty<ColorChooserPaneModel> modelProperty() {
        return this.model;
    }

    public void setModel(ColorChooserPaneModel model) {
        this.model.set((Object)model);
    }
}

