/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.colorchooser;

import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.scene.image.PixelBuffer;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.base.concurrent.TileTask;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.fxcontrols.colorchooser.AbstractColorSlider;
import org.jspecify.annotations.Nullable;

public class ColorSlider
extends AbstractColorSlider {
    private final IntegerProperty componentIndex = new SimpleIntegerProperty((Object)this, "componentIndex", 0);
    private final FloatProperty value = new SimpleFloatProperty((Object)this, "value", 0.0f);
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)Orientation.HORIZONTAL);
    private final DoubleProperty minorTickUnit = new SimpleDoubleProperty((Object)this, "minorTickUnit", 0.00392156862745098);
    private final DoubleProperty majorTickUnit = new SimpleDoubleProperty((Object)this, "majorTickUnit", 0.00392156862745098);

    public ColorSlider() {
        this.load();
    }

    @Override
    void initialize() {
        super.initialize();
        this.c0Property().addListener(o -> this.onComponentValueChanged(0));
        this.c1Property().addListener(o -> this.onComponentValueChanged(1));
        this.c2Property().addListener(o -> this.onComponentValueChanged(2));
        this.c3Property().addListener(o -> this.onComponentValueChanged(3));
        this.valueProperty().addListener(o -> this.requestLayout());
    }

    @Override
    protected void onKeyPressed(KeyEvent keyEvent) {
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        double tickUnit = keyEvent.isAltDown() ? this.getMinorTickUnit() : this.getMajorTickUnit();
        float v = this.getValue();
        double vSnappedToTick = (double)Math.round((double)v / tickUnit) * tickUnit;
        int i = this.getComponentIndex();
        float vMin = cs.getMinValue(i);
        float vMax = cs.getMaxValue(i);
        switch (keyEvent.getCode()) {
            case UP: 
            case RIGHT: {
                keyEvent.consume();
                this.setValue(MathUtil.clamp((float)((float)(vSnappedToTick + tickUnit)), (float)vMin, (float)vMax));
                break;
            }
            case DOWN: 
            case LEFT: {
                keyEvent.consume();
                this.setValue(MathUtil.clamp((float)((float)(vSnappedToTick - tickUnit)), (float)vMin, (float)vMax));
                break;
            }
            case SPACE: {
                keyEvent.consume();
                this.setValue(MathUtil.clamp((float)((float)vSnappedToTick), (float)vMin, (float)vMax));
            }
        }
    }

    private void onComponentValueChanged(int i) {
        if (i != this.getComponentIndex()) {
            this.invalidate();
        }
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        float vMax = cs.getMaxValue(this.componentIndex.get());
        float vMin = cs.getMinValue(this.componentIndex.get());
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.thumb.setTranslateX((double)(this.getValue() - vMin) * width / (double)(vMax - vMin) - this.thumb.getWidth() * 0.5 + this.thumbTranslateX.get());
                this.thumb.setTranslateY((height - this.thumb.getHeight()) * 0.5 + this.thumbTranslateY.get());
                break;
            }
            case VERTICAL: {
                this.thumb.setTranslateY(height - (double)(this.getValue() - vMin) * height / (double)(vMax - vMin) - this.thumb.getHeight() * 0.5 + this.thumbTranslateX.get());
                this.thumb.setTranslateX((width - this.thumb.getWidth()) * 0.5 + this.thumbTranslateY.get() + this.thumbTranslateX.get());
            }
        }
    }

    @Override
    protected @Nullable AbstractColorSlider.AbstractFillTask createFillTask(PixelBuffer<IntBuffer> pixelBuffer) {
        if (this.getDisplayColorSpace() == null || this.getSourceColorSpace() == null || this.getTargetColorSpace() == null) {
            return null;
        }
        return new FillTask(new AbstractColorSlider.FillTaskRecord(Objects.requireNonNull(pixelBuffer), this.getSourceColorSpace(), this.getTargetColorSpace(), this.getDisplayColorSpace(), this.getC0(), this.getC1(), this.getC2(), this.getC3(), this.getComponentIndex(), -1, 1.0f, this.getRgbFilter() == null ? i -> i : this.getRgbFilter()), this.getOrientation());
    }

    @Override
    protected void onMousePressedOrDragged(MouseEvent mouseEvent) {
        this.requestFocus();
        float width = (float)this.getWidth();
        float height = (float)this.getHeight();
        float x = MathUtil.clamp((float)((float)mouseEvent.getX()), (float)0.0f, (float)width);
        float y = MathUtil.clamp((float)((float)mouseEvent.getY()), (float)0.0f, (float)height);
        NamedColorSpace cs = this.getSourceColorSpace();
        if (cs == null) {
            return;
        }
        float vmax = cs.getMaxValue(this.componentIndex.get());
        float vmin = cs.getMinValue(this.componentIndex.get());
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                float value = x * (vmax - vmin) / width + vmin;
                this.setValue(this.maybeSnapToTicks(value, this.getMinorTickUnit(), mouseEvent));
                break;
            }
            case VERTICAL: {
                float value = (height - y) * (vmax - vmin) / height + vmin;
                this.setValue(this.maybeSnapToTicks(value, this.getMinorTickUnit(), mouseEvent));
            }
        }
    }

    public int getComponentIndex() {
        return this.componentIndex.get();
    }

    public IntegerProperty componentIndexProperty() {
        return this.componentIndex;
    }

    public void setComponentIndex(int xComponentIndex) {
        this.componentIndex.set(xComponentIndex);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public double getMinorTickUnit() {
        return this.minorTickUnit.get();
    }

    public DoubleProperty minorTickUnitProperty() {
        return this.minorTickUnit;
    }

    public void setMinorTickUnit(double minorTickUnit) {
        this.minorTickUnit.set(minorTickUnit);
    }

    public float getValue() {
        return this.value.get();
    }

    public FloatProperty valueProperty() {
        return this.value;
    }

    public void setValue(float value) {
        this.value.set(value);
    }

    public double getMajorTickUnit() {
        return this.majorTickUnit.get();
    }

    public DoubleProperty majorTickUnitProperty() {
        return this.majorTickUnit;
    }

    public void setMajorTickUnit(double majorTickUnit) {
        this.majorTickUnit.set(majorTickUnit);
    }

    static class FillTask
    extends AbstractColorSlider.AbstractFillTask {
        private final Orientation orientation;

        public FillTask(AbstractColorSlider.FillTaskRecord record, Orientation orientation) {
            super(record);
            this.orientation = orientation;
        }

        @Override
        public void accept(TileTask.Tile tile) {
            if (this.orientation == Orientation.HORIZONTAL) {
                this.fillHorizontal(tile);
            } else {
                this.fillVertical(tile);
            }
        }

        public void fillHorizontal(TileTask.Tile tile) {
            PixelBuffer<IntBuffer> pixelBuffer = this.record.pixelBuffer();
            int width = pixelBuffer.getWidth();
            IntBuffer b = (IntBuffer)pixelBuffer.getBuffer();
            NamedColorSpace scs = this.record.sourceColorSpace();
            NamedColorSpace tcs = this.record.targetColorSpace();
            NamedColorSpace dcs = this.record.displayColorSpace();
            int vIndex = this.record.xIndex();
            float vMin = scs.getMinValue(vIndex);
            float vMax = scs.getMaxValue(vIndex);
            int yIndex = this.record.yIndex();
            float invWidth = (vMax - vMin) / (float)width;
            float[] colorValue = new float[Math.max(4, scs.getNumComponents())];
            colorValue[0] = this.record.c0();
            colorValue[1] = this.record.c1();
            colorValue[2] = this.record.c2();
            colorValue[3] = this.record.c3();
            float[] sRgb = new float[3];
            float[] tRgb = new float[3];
            float[] dRgb = new float[3];
            float[] scratch = new float[3];
            int[] array = b.array();
            ToIntFunction<Integer> filter = this.record.rgbFilter();
            int yfrom = tile.yfrom();
            int yto = tile.yto();
            int xfrom = tile.xfrom();
            int xto = tile.xto();
            int xy = yfrom * width;
            for (int x = xfrom; x < xto; ++x) {
                float xval;
                colorValue[vIndex] = xval = (float)x * invWidth + vMin;
                int argb = AbstractColorSlider.getArgb(scs, tcs, dcs, colorValue, sRgb, tRgb, dRgb, scratch, 1.0f);
                array[x + xy] = argb = AbstractColorSlider.outOfGamut(tcs, tRgb) ? 0 : argb;
            }
            for (int y = yfrom + 1; y < yto; ++y) {
                System.arraycopy(array, xy + xfrom, array, y * width + xfrom, xto - xfrom);
            }
        }

        public void fillVertical(TileTask.Tile tile) {
            PixelBuffer<IntBuffer> pixelBuffer = this.record.pixelBuffer();
            int width = pixelBuffer.getWidth();
            int height = pixelBuffer.getHeight();
            IntBuffer b = (IntBuffer)pixelBuffer.getBuffer();
            NamedColorSpace scs = this.record.sourceColorSpace();
            NamedColorSpace tcs = this.record.targetColorSpace();
            NamedColorSpace dcs = this.record.displayColorSpace();
            int xIndex = this.record.xIndex();
            float xmin = scs.getMinValue(xIndex);
            float xmax = scs.getMaxValue(xIndex);
            float invHeight = (xmax - xmin) / (float)height;
            float[] colorValue = new float[Math.max(4, scs.getNumComponents())];
            colorValue[0] = this.record.c0();
            colorValue[1] = this.record.c1();
            colorValue[2] = this.record.c2();
            colorValue[3] = this.record.c3();
            float[] sRgb = new float[3];
            float[] dRgb = new float[3];
            float[] tRgb = new float[3];
            float[] scratch = new float[3];
            int[] array = b.array();
            ToIntFunction<Integer> filter = this.record.rgbFilter();
            int yfrom = tile.yfrom();
            int yto = tile.yto();
            int xfrom = tile.xfrom();
            int xto = tile.xto();
            int y = yfrom;
            int xy = yfrom * width;
            while (y < yto) {
                float xval;
                colorValue[xIndex] = xval = (float)(height - y) * invHeight + xmin;
                int argb = AbstractColorSlider.getArgb(scs, tcs, dcs, colorValue, sRgb, tRgb, dRgb, scratch, 1.0f);
                argb = filter.applyAsInt(argb);
                Arrays.fill(array, xy + xfrom, xy + xto, argb);
                ++y;
                xy += width;
            }
        }
    }
}

