/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import java.util.ArrayDeque;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.transition.RectangleTransition;
import org.jhotdraw8.fxcontrols.dock.AbstractDockRoot;
import org.jhotdraw8.fxcontrols.dock.DockChild;
import org.jhotdraw8.fxcontrols.dock.DockNode;
import org.jhotdraw8.fxcontrols.dock.DockParent;
import org.jhotdraw8.fxcontrols.dock.DockRoot;
import org.jhotdraw8.fxcontrols.dock.Dockable;
import org.jhotdraw8.fxcontrols.dock.DropZone;
import org.jhotdraw8.fxcontrols.dock.HBoxTrack;
import org.jhotdraw8.fxcontrols.dock.SplitPaneTrack;
import org.jhotdraw8.fxcontrols.dock.TabPaneTrack;
import org.jhotdraw8.fxcontrols.dock.Track;
import org.jhotdraw8.fxcontrols.dock.TrackAxis;
import org.jhotdraw8.fxcontrols.dock.VBoxTrack;
import org.jspecify.annotations.Nullable;

public class SimpleDockRoot
extends AbstractDockRoot {
    private static final Insets rootDrawnDropZoneInsets = new Insets(10.0);
    private static final Insets dockSensedDropZoneInsets = new Insets(30.0);
    private static final Insets rootSensedDropZoneInsets = new Insets(20.0);
    private static final Insets dockDrawnDropZoneInsets = new Insets(20.0);
    private final Rectangle dropRect = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private final BorderPane contentPane = new BorderPane();
    private @Nullable RectangleTransition transition;
    private Supplier<Track> rootXSupplier = () -> new SplitPaneTrack(Orientation.HORIZONTAL);
    private Supplier<Track> rootYSupplier = () -> new SplitPaneTrack(Orientation.VERTICAL);
    private Supplier<Track> subXSupplier = HBoxTrack::new;
    private Supplier<Track> subYSupplier = VBoxTrack::new;
    private Supplier<Track> zSupplier = TabPaneTrack::new;

    public SimpleDockRoot() {
        this.getChildren().add((Object)this.contentPane);
        this.dropRect.setOpacity(0.4);
        this.dropRect.setManaged(false);
        this.dropRect.setMouseTransparent(true);
        this.dropRect.setVisible(false);
        this.dockChildren.addListener(this::onRootChanged);
        CustomBinding.bindElements(this.getDockChildren(), DockChild::showingProperty, (Property)this.showingProperty());
        this.showingProperty().bind((ObservableValue)this.sceneProperty().isNotNull());
        this.setOnDragOver(this::onDragOver);
        this.setOnDragExited(this::onDragExit);
        this.setOnDragDropped(this::onDragDrop);
    }

    private static Bounds subtractInsets(Bounds b, Insets i) {
        return new BoundingBox(b.getMinX() + i.getLeft(), b.getMinY() + i.getTop(), b.getWidth() - i.getLeft() - i.getRight(), b.getHeight() - i.getTop() - i.getBottom());
    }

    private Track createDock(TrackAxis zoneAxis, @Nullable DockParent parent, boolean isRootPicked) {
        Supplier<Track> supplier = switch (zoneAxis) {
            default -> throw new MatchException(null, null);
            case TrackAxis.X -> {
                if (isRootPicked) {
                    yield this.rootXSupplier;
                }
                yield this.subXSupplier;
            }
            case TrackAxis.Y -> {
                if (isRootPicked) {
                    yield this.rootYSupplier;
                }
                yield this.subYSupplier;
            }
            case TrackAxis.Z -> this.zSupplier;
        };
        return supplier.get();
    }

    private boolean addToParent(Dockable dockable, DockParent parent, DropZone zone, boolean isRootPicked) {
        DockChild child;
        TrackAxis zoneAxis = this.getZoneAxis(zone);
        if (parent instanceof DockRoot || zoneAxis != TrackAxis.Z) {
            child = this.createDock(TrackAxis.Z, parent, isRootPicked);
            ((Track)child).getDockChildren().add((Object)dockable);
        } else {
            child = dockable;
        }
        if (parent.getDockAxis() == zoneAxis) {
            this.addToZoneInParent(child, parent, zone, -1);
            return true;
        }
        DockParent grandParent = parent.getDockParent();
        if (grandParent != null && grandParent.getDockAxis() == zoneAxis) {
            this.addToZoneInParent(child, grandParent, zone, grandParent.getDockChildren().indexOf((Object)parent));
            return true;
        }
        Track newGrandParent = this.createDock(zoneAxis, grandParent, isRootPicked);
        if (grandParent == null) {
            DockChild removed = (DockChild)this.getDockChildren().set(0, (Object)newGrandParent);
            if (removed != null) {
                this.addToZoneInParent(removed, newGrandParent, zone, -1);
            }
        } else {
            grandParent.getDockChildren().set(grandParent.getDockChildren().indexOf((Object)parent), (Object)newGrandParent);
            newGrandParent.getDockChildren().add((Object)parent);
        }
        this.addToZoneInParent(child, newGrandParent, zone, -1);
        return true;
    }

    private void addToZoneInParent(DockChild child, DockParent parent, DropZone zone, int insertionIndex) {
        DockParent oldParent = child.getDockParent();
        if (oldParent != null) {
            oldParent.getDockChildren().remove((Object)child);
        }
        ObservableList<DockChild> children = parent.getDockChildren();
        switch (zone) {
            case TOP: 
            case LEFT: {
                children.add(Math.max(insertionIndex, 0), (Object)child);
                break;
            }
            default: {
                children.add(insertionIndex < 0 ? children.size() : insertionIndex + 1, (Object)child);
            }
        }
    }

    private DragData computeDragData(DragEvent e) {
        DockParent pickedDock;
        Bounds bounds = this.getBoundsInLocal();
        boolean isRootPicked = true;
        if (SimpleDockRoot.subtractInsets(bounds, rootSensedDropZoneInsets).contains(e.getX(), e.getY())) {
            Node pickedNode;
            PickResult pick = e.getPickResult();
            for (pickedNode = pick.getIntersectedNode(); pickedNode != this && pickedNode != null && !(pickedNode instanceof Track); pickedNode = pickedNode.getParent()) {
            }
            pickedDock = pickedNode instanceof Track || pickedNode == this ? (DockParent)pickedNode : null;
        } else {
            pickedDock = this;
        }
        DropZone zone = null;
        Insets insets = rootDrawnDropZoneInsets;
        if (pickedDock == this) {
            if (this.getDockChildrenReadOnly().isEmpty()) {
                zone = DropZone.CENTER;
            } else {
                zone = this.getZone(e.getX(), e.getY(), this.getBoundsInLocal(), rootSensedDropZoneInsets);
                if (zone == DropZone.CENTER) {
                    zone = null;
                }
            }
        } else if (pickedDock != null) {
            isRootPicked = false;
            insets = dockDrawnDropZoneInsets;
            bounds = this.sceneToLocal(pickedDock.getNode().localToScene(pickedDock.getNode().getBoundsInLocal()));
            zone = this.getZone(e.getX(), e.getY(), bounds, dockSensedDropZoneInsets);
            if (!pickedDock.isEditable()) {
                zone = null;
            }
            if (zone == DropZone.CENTER) {
                zone = switch (pickedDock.getDockAxis()) {
                    case TrackAxis.X -> DropZone.RIGHT;
                    case TrackAxis.Y -> DropZone.BOTTOM;
                    default -> zone;
                };
            }
        } else {
            insets = null;
        }
        return new DragData(pickedDock, zone, bounds, insets, isRootPicked);
    }

    @Override
    public TrackAxis getDockAxis() {
        return TrackAxis.Z;
    }

    private @Nullable DropZone getZone(double x, double y, Bounds b, Insets insets) {
        if (y - b.getMinY() < insets.getTop() && b.getHeight() > insets.getTop() + insets.getBottom()) {
            return DropZone.TOP;
        }
        if (b.getMaxY() - y < insets.getBottom() && b.getHeight() > insets.getTop() + insets.getBottom()) {
            return DropZone.BOTTOM;
        }
        if (x - b.getMinX() < insets.getLeft() && b.getWidth() > insets.getLeft() + insets.getRight()) {
            return DropZone.LEFT;
        }
        if (b.getMaxX() - x < insets.getRight() && b.getWidth() > insets.getLeft() + insets.getRight()) {
            return DropZone.RIGHT;
        }
        return b.contains(x, y) ? DropZone.CENTER : null;
    }

    private TrackAxis getZoneAxis(DropZone zone) {
        return switch (zone) {
            case DropZone.TOP, DropZone.BOTTOM -> TrackAxis.Y;
            case DropZone.LEFT, DropZone.RIGHT -> TrackAxis.X;
            default -> TrackAxis.Z;
        };
    }

    private boolean isAcceptable(DragEvent e) {
        Dockable draggedItem = DockRoot.getDraggedDockable();
        return e.getDragboard().getContentTypes().contains(DockRoot.DOCKABLE_DATA_FORMAT) && draggedItem != null && this.getDockablePredicate().test(draggedItem);
    }

    @Override
    public boolean isResizesDockChildren() {
        return true;
    }

    private void onDockableDropped(Dockable dropped, DragData dragData) {
        DockRoot droppedRoot = dropped.getDockRoot();
        DockParent dragSource = dropped.getDockParent();
        if (dragSource == null || dragData.pickedDock == null || dragData.pickedDock instanceof DockRoot && dragData.pickedDock != this) {
            return;
        }
        int index = dragSource.getDockChildren().indexOf((Object)dropped);
        dragSource.getDockChildren().remove(index);
        if (!this.addToParent(dropped, dragData.pickedDock, dragData.zone, dragData.isRootPicked)) {
            dragSource.getDockChildren().add(index, (Object)dropped);
        } else {
            this.removeUnusedDocks(dragSource);
        }
    }

    private void onDragDrop(DragEvent e) {
        this.dropRect.setVisible(false);
        this.getChildren().remove((Object)this.dropRect);
        if (!this.isAcceptable(e)) {
            return;
        }
        Dockable droppedTab = DockRoot.getDraggedDockable();
        DragData dragData = this.computeDragData(e);
        if (dragData.zone != null) {
            e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            this.onDockableDropped(droppedTab, dragData);
        }
        e.consume();
    }

    private void onDragExit(DragEvent e) {
        this.dropRect.setVisible(false);
    }

    private void onDragOver(DragEvent e) {
        if (!this.isAcceptable(e)) {
            return;
        }
        DragData dragData = this.computeDragData(e);
        this.updateDropRect(dragData);
        if (dragData.zone != null) {
            e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            e.consume();
        }
    }

    protected void onRootChanged(ListChangeListener.Change<? extends DockNode> c) {
        this.contentPane.centerProperty().unbind();
        if (c.getList().isEmpty()) {
            this.contentPane.centerProperty().set(null);
        } else {
            this.contentPane.setCenter(((DockNode)c.getList().getFirst()).getNode());
        }
    }

    private void removeUnusedDocks(DockParent node) {
        DockRoot root = node.getDockRoot();
        if (root == null) {
            return;
        }
        ArrayDeque<DockParent> todo = new ArrayDeque<DockParent>();
        todo.add(node);
        while (!todo.isEmpty()) {
            DockParent dock = (DockParent)todo.remove();
            DockParent parent = dock.getDockParent();
            if (parent == null) continue;
            if (dock.getDockChildrenReadOnly().isEmpty()) {
                parent.getDockChildren().remove((Object)dock);
                todo.add(parent);
                continue;
            }
            if (dock.getDockAxis() == TrackAxis.Z || dock.getDockChildren().size() != 1) continue;
            DockChild onlyChild = (DockChild)dock.getDockChildren().removeFirst();
            parent.getDockChildren().set(parent.getDockChildren().indexOf((Object)dock), (Object)onlyChild);
            todo.add(parent);
        }
    }

    private void updateDropRect(DragData dragData) {
        BoundingBox rect;
        if (dragData.zone == null) {
            this.dropRect.setVisible(false);
            return;
        }
        if (this.dropRect.getParent() == null) {
            this.getChildren().add((Object)this.dropRect);
        }
        Bounds bounds = dragData.bounds;
        double x = bounds.getMinX();
        double y = bounds.getMinY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        Insets ins = dragData.insets;
        double btm = ins.getBottom();
        double lft = ins.getLeft();
        double rgt = ins.getRight();
        double top = ins.getTop();
        switch (dragData.zone) {
            case BOTTOM: {
                BoundingBox boundingBox = new BoundingBox(x, y + h - btm, w, btm);
                break;
            }
            case LEFT: {
                BoundingBox boundingBox = new BoundingBox(x, y, lft, h);
                break;
            }
            case RIGHT: {
                BoundingBox boundingBox = new BoundingBox(x + w - rgt, y, rgt, h);
                break;
            }
            case TOP: {
                BoundingBox boundingBox = new BoundingBox(x, y, w, top);
                break;
            }
            default: {
                BoundingBox boundingBox = rect = new BoundingBox(x + lft, y + top, w - lft - rgt, h - top - btm);
            }
        }
        if (this.dropRect.isVisible() && !this.dropRect.getBoundsInLocal().isEmpty()) {
            if (this.transition == null || !this.transition.getToBounds().equals(rect)) {
                if (this.transition != null) {
                    this.transition.stop();
                }
                this.transition = new RectangleTransition(Duration.millis((double)200.0), this.dropRect, this.dropRect.getBoundsInLocal(), (Bounds)rect);
                this.transition.play();
                this.transition.setOnFinished(evt -> {
                    this.transition = null;
                });
            }
        } else {
            this.dropRect.setVisible(true);
            this.dropRect.setX(rect.getMinX());
            this.dropRect.setY(rect.getMinY());
            this.dropRect.setWidth(rect.getWidth());
            this.dropRect.setHeight(rect.getHeight());
        }
    }

    public Supplier<Track> getZSupplier() {
        return this.zSupplier;
    }

    public void setZSupplier(Supplier<Track> zSupplier) {
        this.zSupplier = zSupplier;
    }

    public Supplier<Track> getRootXSupplier() {
        return this.rootXSupplier;
    }

    public void setRootXSupplier(Supplier<Track> rootXSupplier) {
        this.rootXSupplier = rootXSupplier;
    }

    public Supplier<Track> getRootYSupplier() {
        return this.rootYSupplier;
    }

    public void setRootYSupplier(Supplier<Track> rootYSupplier) {
        this.rootYSupplier = rootYSupplier;
    }

    public Supplier<Track> getSubXSupplier() {
        return this.subXSupplier;
    }

    public void setSubXSupplier(Supplier<Track> subXSupplier) {
        this.subXSupplier = subXSupplier;
    }

    public Supplier<Track> getSubYSupplier() {
        return this.subYSupplier;
    }

    public void setSubYSupplier(Supplier<Track> subYSupplier) {
        this.subYSupplier = subYSupplier;
    }

    private record DragData(DockParent pickedDock, DropZone zone, Bounds bounds, Insets insets, boolean isRootPicked) {
    }
}

