/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.control.SplitPane;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxcontrols.dock.AbstractDockParent;
import org.jhotdraw8.fxcontrols.dock.DockChild;
import org.jhotdraw8.fxcontrols.dock.DockNode;
import org.jhotdraw8.fxcontrols.dock.Track;
import org.jhotdraw8.fxcontrols.dock.TrackAxis;

public class SplitPaneTrack
extends AbstractDockParent
implements Track {
    private final SplitPane splitPane = new SplitPane();

    public SplitPaneTrack(Orientation orientation) {
        this.splitPane.setOrientation(orientation);
        this.getStyleClass().add((Object)"track");
        this.getChildren().add((Object)this.splitPane);
        CustomBinding.bindContent((ObservableList)this.splitPane.getItems(), this.getDockChildren(), DockNode::getNode);
        CustomBinding.bindElements(this.getDockChildren(), DockChild::showingProperty, (Property)this.showingProperty());
    }

    @Override
    public TrackAxis getDockAxis() {
        return this.splitPane.getOrientation() == Orientation.HORIZONTAL ? TrackAxis.X : TrackAxis.Y;
    }

    @Override
    public boolean isResizesDockChildren() {
        return true;
    }

    public static SplitPaneTrack createVerticalTrack() {
        return new SplitPaneTrack(Orientation.VERTICAL);
    }

    public static SplitPaneTrack createHorizontalTrack() {
        return new SplitPaneTrack(Orientation.HORIZONTAL);
    }
}

