/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.dock;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxcontrols.dock.AbstractDockParent;
import org.jhotdraw8.fxcontrols.dock.DockChild;
import org.jhotdraw8.fxcontrols.dock.DockParent;
import org.jhotdraw8.fxcontrols.dock.Dockable;
import org.jhotdraw8.fxcontrols.dock.ResizePane;
import org.jhotdraw8.fxcontrols.dock.TabPaneTrack;
import org.jhotdraw8.fxcontrols.dock.Track;
import org.jhotdraw8.fxcontrols.dock.TrackAxis;

public class TabbedAccordionTrack
extends AbstractDockParent
implements Track {
    private final BooleanProperty rotated = new SimpleBooleanProperty(false);
    private final TabPane tabPane = new TabPane();
    private final Accordion accordion = new Accordion();
    private final TitledPane titlePane = new TitledPane();
    private final ResizePane resizePane = new ResizePane();
    private final StackPane stackPane = new StackPane(){

        protected void layoutChildren() {
            if (!TabbedAccordionTrack.this.isRotated()) {
                for (Node child : this.getChildren()) {
                    child.getTransforms().clear();
                }
                super.layoutChildren();
            } else {
                for (Node child : this.getChildren()) {
                    Rotate rotate = new Rotate(90.0, 0.0, 0.0);
                    Translate translate = new Translate(this.getWidth(), 0.0);
                    child.getTransforms().setAll((Object[])new Transform[]{translate, rotate});
                    child.resizeRelocate(0.0, 0.0, this.getHeight(), this.getWidth());
                }
            }
        }
    };

    public TabbedAccordionTrack() {
        this.accordion.getPanes().add((Object)this.titlePane);
        this.accordion.setExpandedPane(this.titlePane);
        this.titlePane.setContent((Node)this.stackPane);
        this.titlePane.setBorder(null);
        this.stackPane.getChildren().add((Object)this.resizePane);
        this.stackPane.setBorder(null);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.getChildren().add((Object)this.accordion);
        this.resizePane.setCenter((Node)this.tabPane);
        SplitPane.setResizableWithParent((Node)this, (Boolean)Boolean.FALSE);
        VBox.setVgrow((Node)this, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this, (Priority)Priority.NEVER);
        this.getStyleClass().add((Object)"track");
        this.dockParentProperty().addListener(this.onParentChanged());
        CustomBinding.bindContent((ObservableList)this.tabPane.getTabs(), this.getDockChildren(), this::makeTab, k -> ((TabPaneTrack.MyTab)((Object)k)).dispose());
        this.dockChildren.addListener(change -> this.onDockChildrenChanged());
        BooleanBinding expandedAndShowing = this.showingProperty().and((ObservableBooleanValue)this.accordion.expandedPaneProperty().isNotNull());
        CustomBinding.bind((ObservableValue)this.tabPane.getSelectionModel().selectedItemProperty(), t -> ((TabPaneTrack.MyTab)((Object)t)).showingProperty(), (ObservableValue)expandedAndShowing, (Object)false);
    }

    private TabPaneTrack.MyTab makeTab(DockChild c) {
        if (c instanceof Dockable) {
            Dockable k = (Dockable)c;
            TabPaneTrack.MyTab tab = new TabPaneTrack.MyTab(c, k.getText(), k.getNode());
            tab.graphicProperty().bind((ObservableValue)CustomBinding.compute(k::getGraphic, (ObservableValue[])new ObservableValue[]{k.graphicProperty(), this.editableProperty()}));
            return tab;
        }
        return new TabPaneTrack.MyTab(c, "-", c.getNode());
    }

    protected ChangeListener<DockParent> onParentChanged() {
        return (o, oldv, newv) -> {
            this.resizePane.setUserResizable(newv != null && !newv.isResizesDockChildren());
            this.resizePane.setResizeAxis(newv == null ? TrackAxis.Y : newv.getDockAxis());
            this.setRotated(newv != null && newv.getDockAxis() == TrackAxis.X);
        };
    }

    private void onDockChildrenChanged() {
        List<Dockable> dockables = this.dockChildren.stream().filter(d -> d instanceof Dockable).map(d -> (Dockable)d).toList();
        switch (dockables.size()) {
            case 0: {
                this.resizePane.setCenter(null);
                this.titlePane.setText(null);
                this.titlePane.setGraphic(null);
                this.titlePane.setContent(null);
                this.stackPane.getChildren().clear();
                break;
            }
            case 1: {
                Dockable i = dockables.getFirst();
                this.titlePane.setText(i.getText());
                this.titlePane.setGraphic(i.getGraphic());
                this.resizePane.setCenter(i.getNode());
                this.stackPane.getChildren().clear();
                this.stackPane.getChildren().add((Object)this.resizePane);
                this.titlePane.setContent((Node)this.stackPane);
                break;
            }
            default: {
                this.titlePane.setGraphic(null);
                this.resizePane.setCenter(null);
                ArrayList col = new ArrayList(this.tabPane.getTabs());
                this.tabPane.getTabs().clear();
                this.tabPane.getTabs().setAll(col);
                this.resizePane.setCenter((Node)this.tabPane);
                StringBuilder b = new StringBuilder();
                double minHeight = 0.0;
                for (Dockable i : dockables) {
                    Node content = i.getNode();
                    if (content instanceof Region) {
                        minHeight = Double.max(minHeight, content.minHeight(-1.0));
                    }
                    if (!b.isEmpty()) {
                        b.append(", ");
                    }
                    b.append(i.getText());
                }
                this.tabPane.setMinHeight(minHeight + 44.0);
                this.titlePane.setText(b.toString());
                this.stackPane.getChildren().clear();
                this.stackPane.getChildren().add((Object)this.resizePane);
                this.titlePane.setContent((Node)this.stackPane);
                break;
            }
        }
    }

    @Override
    public TrackAxis getDockAxis() {
        return TrackAxis.Z;
    }

    @Override
    public boolean isResizesDockChildren() {
        return true;
    }

    public boolean isRotated() {
        return this.rotated.get();
    }

    public BooleanProperty rotatedProperty() {
        return this.rotated;
    }

    public void setRotated(boolean rotated) {
        this.rotated.set(rotated);
    }

    @Override
    protected void layoutChildren() {
        if (this.isRotated()) {
            Rotate rotate = new Rotate(270.0, 0.0, 0.0);
            Translate translate = new Translate(0.0, this.getHeight());
            this.accordion.getTransforms().setAll((Object[])new Transform[]{translate, rotate});
            this.accordion.resizeRelocate(0.0, 0.0, this.getHeight(), this.getWidth());
        } else {
            this.accordion.getTransforms().clear();
            super.layoutChildren();
        }
    }
}

