/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.fontchooser;

import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxcontrols.fontchooser.FontFamilyChooserController;

public class FontChooserController
extends FontFamilyChooserController {
    @FXML
    private ListView<Integer> fontSizeList;
    @FXML
    private Slider fontSizeSlider;
    @FXML
    private TextField fontSizeField;

    @Override
    @FXML
    void initialize() {
        super.initialize();
        assert (this.fontSizeField != null) : "fx:id=\"fontSizeField\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.fontSizeList != null) : "fx:id=\"fontSizeList\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.fontSizeSlider != null) : "fx:id=\"fontSizeSlider\" was not injected: check your FXML file 'FontChooser.fxml'.";
        this.initFontSizeControls();
    }

    private void initFontSizeControls() {
        this.fontSizeList.getItems().addAll((Object[])new Integer[]{9, 10, 11, 12, 13, 14, 18, 24, 36, 48, 64, 72, 96, 144, 288});
        CustomBinding.bindBidirectionalAndConvert((WritableValue)this.fontSize, (WritableValue)this.fontSizeSlider.valueProperty(), a -> this.fontSizeSlider.getMax() - a.doubleValue(), b -> this.fontSizeSlider.getMax() - b.doubleValue());
        NumberStringConverter converter = new NumberStringConverter();
        Bindings.bindBidirectional((Property)this.fontSizeField.textProperty(), (Property)this.fontSize, (StringConverter)converter);
        this.fontSizeList.setOnMouseClicked(event -> {
            Integer selectedItem = (Integer)this.fontSizeList.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.setFontSize(selectedItem.doubleValue());
            }
            this.fontSizeList.getSelectionModel().clearSelection();
        });
        this.fontSize.addListener(o -> this.updatePreviewTextArea());
    }
}

