/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.fontchooser;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.text.Font;
import org.jhotdraw8.application.resources.ModulepathResources;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.fxcontrols.fontchooser.FontChooserModel;
import org.jhotdraw8.fxcontrols.fontchooser.FontCollection;
import org.jhotdraw8.fxcontrols.fontchooser.FontDialog;
import org.jhotdraw8.fxcontrols.fontchooser.FontFamily;
import org.jhotdraw8.fxcontrols.fontchooser.FontTypeface;
import org.jspecify.annotations.Nullable;

public class FontFamilyChooserController {
    @FXML
    private Button addCollectionButton;
    @FXML
    private ListView<FontCollection> collectionList;
    @FXML
    private ListView<FontFamily> familyList;
    @FXML
    private Label fontNameLabel;
    @FXML
    private URL location;
    private final ObjectProperty<FontChooserModel> model = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty();
    protected final DoubleProperty fontSize = new SimpleDoubleProperty(13.0);
    @FXML
    private TextArea previewTextArea;
    @FXML
    private ResourceBundle resources;
    @FXML
    private ListView<FontTypeface> typefaceList;

    public double getFontSize() {
        return this.fontSize.get();
    }

    public FontChooserModel getModel() {
        return (FontChooserModel)this.model.get();
    }

    public void setFontSize(double size) {
        this.fontSize.set(size);
    }

    public void setModel(FontChooserModel value) {
        this.model.set((Object)value);
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public void setOnAction(EventHandler<ActionEvent> value) {
        this.onAction.set(value);
    }

    public @Nullable String getSelectedFontName() {
        FontTypeface typeface = this.typefaceList == null ? null : (FontTypeface)this.typefaceList.getSelectionModel().getSelectedItem();
        return typeface == null ? null : typeface.getName();
    }

    private void initDoubleClickBehavior() {
        EventHandler onMouseHandler = evt -> {
            if (evt.getClickCount() == 2 && this.getOnAction() != null && this.getSelectedFontName() != null) {
                this.getOnAction().handle((Event)new ActionEvent(evt.getSource(), evt.getTarget()));
            }
        };
        this.typefaceList.setOnMousePressed(onMouseHandler);
        this.familyList.setOnMousePressed(onMouseHandler);
    }

    private void initListCells() {
        this.familyList.setCellFactory(lv -> {
            TextFieldListCell listCell = new TextFieldListCell();
            return listCell;
        });
        this.collectionList.setCellFactory(lv -> {
            TextFieldListCell listCell = new TextFieldListCell();
            return listCell;
        });
    }

    private void initListSelectionBehavior() throws MissingResourceException {
        Resources labels = ModulepathResources.getResources((Module)FontDialog.class.getModule(), (String)"org.jhotdraw8.fxcontrols.spi.labels");
        this.collectionList.getSelectionModel().selectedItemProperty().addListener((o, oldv, newv) -> {
            this.familyList.setItems(newv == null ? null : newv.getFamilies());
            if (!this.familyList.getItems().isEmpty()) {
                this.familyList.getSelectionModel().select(0);
            }
        });
        this.familyList.getSelectionModel().selectedItemProperty().addListener((o, oldv, newv) -> {
            this.typefaceList.setItems(newv == null ? null : newv.getTypefaces());
            if (newv != null && !newv.getTypefaces().isEmpty()) {
                ObservableList items = this.typefaceList.getItems();
                boolean found = false;
                int n = items.size();
                for (int i = 0; i < n; ++i) {
                    if (!((FontTypeface)items.get(i)).isRegular()) continue;
                    this.typefaceList.getSelectionModel().select(i);
                    found = true;
                    break;
                }
                if (!found && !this.typefaceList.getItems().isEmpty()) {
                    this.typefaceList.getSelectionModel().select(0);
                }
            }
        });
        this.typefaceList.getSelectionModel().selectedItemProperty().addListener((o, oldv, newv) -> {
            if (newv == null) {
                this.fontNameLabel.setText(labels.getString("FontChooser.nothingSelected"));
            } else {
                this.fontNameLabel.setText(newv.getName());
            }
            this.updatePreviewTextArea();
        });
    }

    protected void updatePreviewTextArea() {
        String text = this.fontNameLabel.getText();
        Resources labels = ModulepathResources.getResources((Module)FontDialog.class.getModule(), (String)"org.jhotdraw8.fxcontrols.spi.labels");
        if (text == null || text.equals(labels.getString("FontChooser.nothingSelected"))) {
            this.previewTextArea.setFont(new Font("System Regular", this.getFontSize()));
        } else {
            this.previewTextArea.setFont(new Font(text, this.getFontSize()));
        }
    }

    private void initPreferencesBehavior() {
        Preferences prefs = Preferences.userNodeForPackage(FontFamilyChooserController.class);
        this.previewTextArea.setText(prefs.get("fillerText", "Now is the time for all good men."));
        this.previewTextArea.textProperty().addListener((o, oldv, newv) -> prefs.put("fillerText", (String)newv));
    }

    private void initUpdateViewFromModelBehavior() {
        this.model.addListener((o, oldv, newv) -> {
            if (oldv != null) {
                this.collectionList.itemsProperty().unbind();
            }
            if (newv != null) {
                this.collectionList.itemsProperty().bind(newv.fontCollectionsProperty());
            }
        });
    }

    @FXML
    void initialize() {
        assert (this.previewTextArea != null) : "fx:id=\"previewTextArea\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.fontNameLabel != null) : "fx:id=\"fontNameLabel\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.addCollectionButton != null) : "fx:id=\"addCollectionButton\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.collectionList != null) : "fx:id=\"collectionList\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.familyList != null) : "fx:id=\"familyList\" was not injected: check your FXML file 'FontChooser.fxml'.";
        assert (this.typefaceList != null) : "fx:id=\"typefaceList\" was not injected: check your FXML file 'FontChooser.fxml'.";
        this.initUpdateViewFromModelBehavior();
        this.initListSelectionBehavior();
        this.initDoubleClickBehavior();
        this.initPreferencesBehavior();
        this.initListCells();
        this.collectionList.itemsProperty().addListener((o, oldv, newv) -> System.out.println("collectionList change=" + String.valueOf(newv)));
    }

    public ObjectProperty<FontChooserModel> modelProperty() {
        return this.model;
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public void setFontName(String fontName) {
        ObservableList collections = this.collectionList.getItems();
        int n = collections.size();
        for (int i = 0; i < n; ++i) {
            FontCollection fontCollection = (FontCollection)collections.get(i);
            ObservableList<FontFamily> families = fontCollection.getFamilies();
            int m = families.size();
            block1: for (int j = 0; j < m; ++j) {
                FontFamily fontFamily = (FontFamily)families.get(j);
                ObservableList<FontTypeface> typefaces = fontFamily.getTypefaces();
                int p = typefaces.size();
                for (int k = 0; k < p; ++k) {
                    FontTypeface fontTypeface = (FontTypeface)typefaces.get(k);
                    if (!fontTypeface.getName().equals(fontName)) continue;
                    this.collectionList.getSelectionModel().select(i);
                    this.familyList.getSelectionModel().select(j);
                    this.typefaceList.getSelectionModel().select(k);
                    continue block1;
                }
            }
        }
    }
}

