/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxcontrols.fontchooser;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jhotdraw8.application.resources.ModulepathResources;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.text.NaturalSortCollator;
import org.jhotdraw8.fxcontrols.fontchooser.DefaultFontCollectionsFactory;
import org.jhotdraw8.fxcontrols.fontchooser.FontCollection;
import org.jhotdraw8.fxcontrols.fontchooser.FontDialog;
import org.jhotdraw8.fxcontrols.fontchooser.FontFamily;
import org.jhotdraw8.os.macos.PListParsers;
import org.w3c.dom.Document;

public class MacOSFontCollectionsFactory
extends DefaultFontCollectionsFactory {
    private final Logger LOGGER = Logger.getLogger(MacOSFontCollectionsFactory.class.getName());

    @Override
    protected ObservableList<FontCollection> generateCollections(List<FontFamily> families) {
        ArrayList<FontCollection> collections = new ArrayList<FontCollection>();
        Resources labels = ModulepathResources.getResources((Module)FontDialog.class.getModule(), (String)"org.jhotdraw8.fxcontrols.spi.labels");
        FontCollection allFonts = new FontCollection(labels.getString("FontCollection.allFonts"), true, families);
        collections.add(allFonts);
        Path dir = Paths.get(System.getProperty("user.home"), "Library", "FontCollections");
        Map familiesMap = families.stream().collect(Collectors.toMap(FontFamily::getName, Function.identity()));
        families.forEach(ff -> {
            String name = ff.getName();
            familiesMap.put(name.replaceAll(" ", ""), ff);
            int pblank = name.indexOf(32);
            if (pblank != -1) {
                String firstPartOfName = name.substring(0, pblank);
                familiesMap.putIfAbsent(firstPartOfName, ff);
            }
        });
        try (Stream<Path> stream = Files.list(dir);){
            stream.filter(path -> {
                String fileName = path.getFileName().toString();
                return !"com.apple.Recents.collection".equals(fileName) && fileName.endsWith(".collection");
            }).forEach(path -> {
                try {
                    collections.add(this.readFontCollection(familiesMap, (Path)path));
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.FINE, "Not a font collection. path=" + String.valueOf(path));
                }
            });
            collections.sort(Comparator.comparing(FontCollection::getName, new NaturalSortCollator()));
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, "Could not read font collections directory. dir=" + String.valueOf(dir));
        }
        return FXCollections.observableArrayList(collections);
    }

    private FontCollection readFontCollection(Map<String, FontFamily> families, Path path) throws IOException {
        try {
            Map map = PListParsers.toMap((Document)PListParsers.readPList((File)path.toFile()));
            LinkedHashSet<FontFamily> fontFamilies = new LinkedHashSet<FontFamily>();
            List plist = map.getOrDefault("plist", List.of());
            if (plist.isEmpty()) {
                throw new IOException("Could not find a plist. path=" + String.valueOf(path));
            }
            LinkedHashMap plistMap = (LinkedHashMap)plist.getFirst();
            List objectsList = plistMap.getOrDefault("$objects", List.of());
            for (Object o : objectsList) {
                String potentialFontFamilyName;
                if (!(o instanceof String)) continue;
                int pminus = (potentialFontFamilyName = (String)o).indexOf(45);
                String fontFamilyName = potentialFontFamilyName.substring(0, pminus == -1 ? potentialFontFamilyName.length() : pminus);
                FontFamily fontFamily = families.get(fontFamilyName);
                if (fontFamily == null && fontFamilyName.endsWith("ITCTT")) {
                    fontFamily = families.get(fontFamilyName.substring(0, fontFamilyName.length() - 5));
                }
                if (fontFamily == null) continue;
                fontFamilies.add(fontFamily);
            }
            String collectionName = path.getFileName().toString();
            if (collectionName.endsWith(".collection")) {
                collectionName = collectionName.substring(0, collectionName.length() - 11);
            }
            if (fontFamilies.isEmpty()) {
                throw new IOException("Font collection is empty. path=" + String.valueOf(path));
            }
            ArrayList<FontFamily> familiesList = new ArrayList<FontFamily>(fontFamilies);
            familiesList.sort(Comparator.comparing(FontFamily::getName, new NaturalSortCollator()));
            return new FontCollection(collectionName, familiesList);
        }
        catch (ClassCastException e) {
            throw new IOException("Could not cast element in plist. path=" + String.valueOf(path));
        }
    }
}

