/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Point2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.PathBuilder;

public abstract class AbstractPathBuilder<T>
implements PathBuilder<T> {
    private double lastX;
    private double lastY;
    private double lastMoveToX;
    private double lastMoveToY;
    private double lastCX;
    private double lastCY;
    private int numCommands = 0;

    @Override
    public void arcTo(double radiusX, double radiusY, double xAxisRotation, double x, double y, boolean largeArcFlag, boolean sweepFlag) {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doArcTo(this.lastX, this.lastY, radiusX, radiusY, xAxisRotation, x, y, largeArcFlag, sweepFlag);
        this.lastX = x;
        this.lastY = y;
        this.lastCX = x;
        this.lastCY = y;
    }

    @Override
    public final void closePath() {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doClosePath(this.lastX, this.lastY, this.lastMoveToX, this.lastMoveToY);
    }

    @Override
    public final void curveTo(double x1, double y1, double x2, double y2, double x, double y) {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doCurveTo(this.lastX, this.lastY, x1, y1, x2, y2, x, y);
        this.lastX = x;
        this.lastY = y;
        this.lastCX = x2;
        this.lastCY = y2;
    }

    protected void doArcTo(double lastX, double lastY, double radiusX, double radiusY, double xAxisRotation, double x, double y, boolean largeArcFlag, boolean sweepFlag) {
        PathBuilder.super.arcTo(radiusX, radiusY, xAxisRotation, x, y, largeArcFlag, sweepFlag);
    }

    protected abstract void doClosePath(double var1, double var3, double var5, double var7);

    protected abstract void doPathDone();

    protected abstract void doCurveTo(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    protected abstract void doLineTo(double var1, double var3, double var5, double var7);

    protected abstract void doMoveTo(double var1, double var3);

    protected abstract void doQuadTo(double var1, double var3, double var5, double var7, double var9, double var11);

    protected void doSmoothCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        this.doCurveTo(lastX, lastY, x1, y1, x2, y2, x, y);
    }

    protected void doSmoothQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        this.doQuadTo(lastX, lastY, x1, y1, x, y);
    }

    @Override
    public void pathDone() {
        this.doPathDone();
    }

    @Override
    public  @NonNull Point2D.Double getLastPoint() {
        return new Point2D.Double(this.lastX, this.lastY);
    }

    @Override
    public double getLastX() {
        return this.lastX;
    }

    @Override
    public double getLastY() {
        return this.lastY;
    }

    public double getLastMoveToX() {
        return this.lastMoveToX;
    }

    public double getLastMoveToY() {
        return this.lastMoveToY;
    }

    @Override
    public double getLastCX() {
        return this.lastCX;
    }

    @Override
    public double getLastCY() {
        return this.lastCY;
    }

    @Override
    public final void lineTo(double x, double y) {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doLineTo(this.lastX, this.lastY, x, y);
        this.lastX = x;
        this.lastY = y;
        this.lastCX = x;
        this.lastCY = y;
    }

    @Override
    public final void moveTo(double x, double y) {
        ++this.numCommands;
        this.doMoveTo(x, y);
        this.lastX = x;
        this.lastY = y;
        this.lastMoveToX = x;
        this.lastMoveToY = y;
        this.lastCX = x;
        this.lastCY = y;
    }

    @Override
    public final void quadTo(double x1, double y1, double x, double y) {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doQuadTo(this.lastX, this.lastY, x1, y1, x, y);
        this.lastX = x;
        this.lastY = y;
        this.lastCX = x1;
        this.lastCY = y1;
    }

    @Override
    public final void smoothCurveTo(double x2, double y2, double x, double y) {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doSmoothCurveTo(this.lastX, this.lastY, this.lastX - this.lastCX + this.lastX, this.lastY - this.lastCY + this.lastY, x2, y2, x, y);
        this.lastX = x;
        this.lastY = y;
        this.lastCX = x2;
        this.lastCY = y2;
    }

    @Override
    public final void smoothQuadTo(double x, double y) {
        if (this.numCommands++ == 0) {
            throw new IllegalStateException("Missing initial moveto in path definition.");
        }
        this.doSmoothQuadTo(this.lastX, this.lastY, this.lastX - this.lastCX + this.lastX, this.lastY - this.lastCY + this.lastY, x, y);
        this.lastCX = this.lastX - this.lastCX + this.lastX;
        this.lastCY = this.lastY - this.lastCY + this.lastY;
        this.lastX = x;
        this.lastY = y;
    }

    protected void setLastX(double lastX) {
        this.lastX = lastX;
    }

    protected void setLastY(double lastY) {
        this.lastY = lastY;
    }

    protected void setLastCX(double lastCX) {
        this.lastCX = lastCX;
    }

    protected void setLastCY(double lastCY) {
        this.lastCY = lastCY;
    }

    @Override
    public boolean needsMoveTo() {
        return this.numCommands == 0;
    }
}

