/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.primitive.ByteArrayList;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.geom.AbstractPathBuilder;

public abstract class AbstractPathDataBuilder<B>
extends AbstractPathBuilder<B> {
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    protected final @NonNull ByteArrayList commands = new ByteArrayList();
    protected final @NonNull IntArrayList offsets = new IntArrayList();
    protected final @NonNull DoubleArrayList coords = new DoubleArrayList();
    protected final double[] temp = new double[8];
    protected int windingRule = 0;

    public int getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(int windingRule) {
        this.windingRule = windingRule;
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        if (!this.commands.isEmpty() && this.commands.getLastAsByte() != 0 && this.commands.getLastAsByte() != 4) {
            this.commands.addAsByte((byte)4);
            this.offsets.addAsInt(this.coords.size());
        }
    }

    @Override
    protected void doPathDone() {
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        this.temp[0] = lastX;
        this.temp[1] = lastY;
        this.temp[2] = x1;
        this.temp[3] = y1;
        this.temp[4] = x2;
        this.temp[5] = y2;
        this.temp[6] = x;
        this.temp[7] = y;
        this.commands.addAsByte((byte)3);
        this.offsets.addAsInt(this.coords.size());
        this.coords.addAsDouble(x1);
        this.coords.addAsDouble(y1);
        this.coords.addAsDouble(x2);
        this.coords.addAsDouble(y2);
        this.coords.addAsDouble(x);
        this.coords.addAsDouble(y);
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        this.commands.addAsByte((byte)1);
        this.offsets.addAsInt(this.coords.size());
        this.coords.addAsDouble(x);
        this.coords.addAsDouble(y);
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.commands.addAsByte((byte)0);
        this.offsets.addAsInt(this.coords.size());
        this.coords.addAsDouble(x);
        this.coords.addAsDouble(y);
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        this.temp[0] = lastX;
        this.temp[1] = lastY;
        this.temp[2] = x1;
        this.temp[3] = y1;
        this.temp[4] = x;
        this.temp[5] = y;
        this.commands.addAsByte((byte)2);
        this.offsets.addAsInt(this.coords.size());
        this.coords.addAsDouble(x1);
        this.coords.addAsDouble(y1);
        this.coords.addAsDouble(x);
        this.coords.addAsDouble(y);
    }
}

