/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import org.jhotdraw8.annotation.NonNull;

public class BoundsCalculator {
    private double minX = Double.POSITIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;

    public void accept(@NonNull Bounds value) {
        this.minX = Math.min(this.minX, value.getMinX());
        this.maxX = Math.max(this.maxX, value.getMaxX());
        this.minY = Math.min(this.minY, value.getMinY());
        this.maxY = Math.max(this.maxY, value.getMaxY());
    }

    public void combine(@NonNull BoundsCalculator other) {
        this.minX = Math.min(this.minX, other.minX);
        this.maxX = Math.max(this.maxX, other.maxX);
        this.minY = Math.min(this.minY, other.minY);
        this.maxY = Math.max(this.maxY, other.maxY);
    }

    public @NonNull Bounds getBounds() {
        return new BoundingBox(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }
}

