/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.Iterator;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.contour.ContourBuilder;
import org.jhotdraw8.geom.contour.PlinePath;
import org.jhotdraw8.geom.contour.PlinePathBuilder;

public class ContourPathBuilder<T>
extends AbstractPathBuilder<T> {
    private final double offset;
    private final @NonNull PathBuilder<T> consumer;
    private final @NonNull PlinePathBuilder papb = new PlinePathBuilder();
    private final double eps2;

    public ContourPathBuilder(@NonNull PathBuilder<T> consumer, double offset) {
        this(consumer, offset, 0.0);
    }

    public ContourPathBuilder(@NonNull PathBuilder<T> consumer, double offset, double epsilon) {
        this.offset = offset;
        this.consumer = consumer;
        this.eps2 = epsilon * epsilon;
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        this.papb.closePath();
    }

    @Override
    protected void doPathDone() {
        this.papb.pathDone();
        ContourBuilder contourBuilder = new ContourBuilder();
        Iterator iterator = this.papb.build().iterator();
        while (iterator.hasNext()) {
            PlinePath path = (PlinePath)iterator.next();
            for (PlinePath contourPath : contourBuilder.parallelOffset(path, -this.offset)) {
                AwtShapes.buildFromPathIterator(this.consumer, contourPath.getPathIterator(null), false);
            }
        }
        this.consumer.pathDone();
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        this.papb.curveTo(x1, y1, x2, y2, x, y);
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        if (this.eps2 == 0.0 || (lastX - x) * (lastX - x) + (lastY - y) * (lastY - y) >= this.eps2) {
            this.papb.lineTo(x, y);
        }
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.papb.moveTo(x, y);
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        this.papb.quadTo(x1, y1, x, y);
    }

    @Override
    public @Nullable T build() {
        return this.consumer.build();
    }
}

