/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points;

public class CubicCurveCharacteristics {
    private CubicCurveCharacteristics() {
    }

    public static Characteristics characteristics(double[] b, int o) {
        return CubicCurveCharacteristics.characteristics(b[o], b[o + 1], b[o + 2], b[o + 3], b[o + 4], b[o + 5], b[o + 6], b[o + 7]);
    }

    public static Characteristics characteristics(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        Point2D.Double can = CubicCurveCharacteristics.canonicalForm(x0, y0, x1, y1, x2, y2, x3, y3);
        if (can == null) {
            return Characteristics.COLLINEAR;
        }
        double x = can.x;
        double y = can.y;
        if (y > 1.0) {
            return Characteristics.SINGLE_INFLECTION;
        }
        if (y <= 1.0 && x <= 1.0) {
            double cusp = (-x * x + 2.0 * x + 3.0) / 4.0;
            if (x <= 0.0) {
                double l1 = (-x * x + 3.0 * x) / 3.0;
                if (Points.almostEqual(y, l1, 0.06)) {
                    return Characteristics.LOOP_AT_T_0;
                }
                if (l1 < y && y < cusp) {
                    return Characteristics.LOOP;
                }
            }
            if (0.0 <= x) {
                double l0 = (Math.sqrt(3.0) * Math.sqrt(4.0 * x - x * x) - x) / 2.0;
                if (Points.almostEqual(y, l0, 0.06)) {
                    return Characteristics.LOOP_AT_T_1;
                }
                if (l0 < y && y < cusp) {
                    return Characteristics.LOOP;
                }
            }
            if (Points.almostEqual(y, cusp, 0.06)) {
                return Characteristics.CUSP;
            }
            if (y > cusp) {
                return Characteristics.DOUBLE_INFLECTION;
            }
            if (y < cusp) {
                return Characteristics.PLAIN_CURVE;
            }
        }
        return Characteristics.PLAIN_CURVE;
    }

    public static  @Nullable Point2D.Double canonicalForm(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        if (Lines.isCollinear(x0, y0, x1, y1, x2, y2)) {
            if (Lines.isCollinear(x1, y1, x2, y2, x3, y3)) {
                return null;
            }
            double swapx = x0;
            double swapy = y0;
            x0 = x3;
            y0 = y3;
            x3 = swapx;
            y3 = swapy;
            swapx = x1;
            swapy = y1;
            x1 = x2;
            y1 = y2;
            x2 = swapx;
            y2 = swapy;
        }
        double xn = -x0 + x3 - (-x0 + x1) * (-y0 + y3) / (-y0 + y1);
        double xd = -x0 + x2 - (-x0 + x1) * (-y0 + y2) / (-y0 + y1);
        double np4x = xn / xd;
        double yt1 = (-y0 + y3) / (-y0 + y1);
        double yt2 = 1.0 - (-y0 + y2) / (-y0 + y1);
        double yp = yt2 * xn / xd;
        double np4y = yt1 + yp;
        return new Point2D.Double(np4x, np4y);
    }

    public static double[] align(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double[] e = new double[]{x0, y0, x1, y1, x2, y2, x3, y3};
        double theta = -Angles.atan2(y3 - y0, x3 - x0);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double[] n = new double[8];
        for (int i = 0; i < 8; i += 2) {
            double px = e[i];
            double py = e[i + 1];
            n[i] = (px - x0) * cosTheta - (py - y0) * sinTheta;
            n[i + 1] = (px - x0) * sinTheta + (py - y0) * cosTheta;
        }
        return n;
    }

    public static @NonNull DoubleArrayList inflectionPoints(CubicCurve2D.Double c) {
        return CubicCurveCharacteristics.inflectionPoints(c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2);
    }

    public static @NonNull DoubleArrayList inflectionPoints(double[] b, int o) {
        return CubicCurveCharacteristics.inflectionPoints(b[o], b[o + 1], b[o + 2], b[o + 3], b[o + 4], b[o + 5], b[o + 6], b[o + 7]);
    }

    public static @Nullable Double singularPoint(double[] b, int o) {
        return CubicCurveCharacteristics.singularPoint(b[o], b[o + 1], b[o + 2], b[o + 3], b[o + 4], b[o + 5], b[o + 6], b[o + 7]);
    }

    public static @NonNull DoubleArrayList inflectionPoints(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        DoubleArrayList result = new DoubleArrayList(2);
        double[] n = CubicCurveCharacteristics.align(x0, y0, x1, y1, x2, y2, x3, y3);
        double ax1 = n[2];
        double ay1 = n[3];
        double ax2 = n[4];
        double ay2 = n[5];
        double ax3 = n[6];
        double i = ax2 * ay1;
        double a = ax3 * ay1;
        double r = ax1 * ay2;
        double o = ax3 * ay2;
        double s = -3.0 * i + 2.0 * a + 3.0 * r - o;
        double l = 3.0 * i - a - 3.0 * r;
        double c = r - i;
        if (Points.almostZero(s, 1.0E-6)) {
            double h;
            if (!Points.almostZero(l, 1.0E-6) && 0.0 <= (h = -c / l) && h <= 1.0) {
                result.add(Double.valueOf(h));
            }
            return result;
        }
        double det = Math.sqrt(l * l - 4.0 * s * c);
        double q = 2.0 * s;
        if (!Points.almostZero(q, 1.0E-6)) {
            double t1 = (det - l) / q;
            double t2 = -(l + det) / q;
            if (0.0 <= t1 && t1 <= 1.0) {
                result.add(Double.valueOf(t1));
            }
            if (0.0 <= t2 && t2 <= 1.0) {
                result.add(Double.valueOf(t2));
            }
        }
        result.sort();
        return result;
    }

    public static @Nullable Double singularPoint(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double t;
        double[] n = CubicCurveCharacteristics.align(x0, y0, x1, y1, x2, y2, x3, y3);
        double ax1 = n[2];
        double ay1 = n[3];
        double ax2 = n[4];
        double ay2 = n[5];
        double ax3 = n[6];
        double i = ax2 * ay1;
        double a = ax3 * ay1;
        double r = ax1 * ay2;
        double o = ax3 * ay2;
        double s = -3.0 * i + 2.0 * a + 3.0 * r - o;
        double l = 3.0 * i - a - 3.0 * r;
        double c = r - i;
        double q = 2.0 * s;
        if (!Points.almostZero(q, 1.0E-6) && 0.0 <= (t = -l / q) && t <= 1.0) {
            return t;
        }
        return null;
    }

    public static @NonNull DoubleArrayList extremePoints(CubicCurve2D.Double c) {
        return CubicCurveCharacteristics.extremePoints(c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2);
    }

    public static @NonNull DoubleArrayList extremePoints(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double cx = 3.0 * (x1 - x0);
        double cy = 3.0 * (y1 - y0);
        double bx = 6.0 * (x0 - 2.0 * x1 + x2);
        double by = 6.0 * (y0 - 2.0 * y1 + y2);
        double ax = 3.0 * (-x0 + 3.0 * x1 - 3.0 * x2 + x3);
        double ay = 3.0 * (-y0 + 3.0 * y1 - 3.0 * y2 + y3);
        double detx = Math.sqrt(bx / 2.0 * (bx / 2.0) - ax * cx);
        double dety = Math.sqrt(by / 2.0 * (by / 2.0) - ay * cy);
        double t0 = (-bx / 2.0 + detx) / ax;
        double t2 = (-bx / 2.0 - detx) / ax;
        double t1 = (-by / 2.0 + dety) / ay;
        double t3 = (-by / 2.0 - dety) / ay;
        DoubleArrayList list = new DoubleArrayList();
        if (0.0 <= t0 && t0 <= 1.0) {
            list.add(Double.valueOf(t0));
        }
        if (0.0 <= t1 && t1 <= 1.0) {
            list.add(Double.valueOf(t1));
        }
        if (0.0 <= t2 && t2 <= 1.0) {
            list.add(Double.valueOf(t2));
        }
        if (0.0 <= t3 && t3 <= 1.0) {
            list.add(Double.valueOf(t3));
        }
        return list;
    }

    public static enum Characteristics {
        PLAIN_CURVE,
        SINGLE_INFLECTION,
        DOUBLE_INFLECTION,
        CUSP,
        LOOP,
        LOOP_AT_T_0,
        LOOP_AT_T_1,
        COLLINEAR;

    }
}

