/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.function.ToDoubleFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.DoubleConsumer6;
import org.jhotdraw8.base.function.DoubleConsumer8;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.geom.Integrals;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Solvers;

public class CubicCurves {
    private CubicCurves() {
    }

    public static @NonNull PointAndDerivative eval(double[] a, int offsetA, double t) {
        return CubicCurves.eval(a[offsetA], a[offsetA + 1], a[offsetA + 2], a[offsetA + 3], a[offsetA + 4], a[offsetA + 5], a[offsetA + 6], a[offsetA + 7], t);
    }

    public static @NonNull PointAndDerivative eval(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double t) {
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x23 = Lines.lerp(x2, x3, t);
        double y23 = Lines.lerp(y2, y3, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        double x123 = Lines.lerp(x12, x23, t);
        double y123 = Lines.lerp(y12, y23, t);
        double x0123 = Lines.lerp(x012, x123, t);
        double y0123 = Lines.lerp(y012, y123, t);
        return new PointAndDerivative(x0123, y0123, x123 - x012, y123 - y012);
    }

    public static double @Nullable [] merge(double[] a, int offsetA, double[] b, int offsetB, double tolerance) {
        if (Points.squaredDistance(a[offsetA + 6], a[offsetA + 7], b[offsetB], b[offsetB + 1]) > tolerance * tolerance) {
            return null;
        }
        return CubicCurves.merge(a[offsetA], a[offsetA + 1], a[offsetA + 2], a[offsetA + 3], a[offsetA + 4], a[offsetA + 5], a[offsetA + 6], a[offsetA + 7], b[offsetB + 2], b[offsetB + 3], b[offsetB + 4], b[offsetB + 5], b[offsetB + 6], b[offsetB + 7], tolerance);
    }

    public static double @Nullable [] merge(double x0, double y0, double x01, double y01, double x012, double y012, double x0123, double y0123, double x123, double y123, double x23, double y23, double x3, double y3, double tolerance) {
        double[] dArray;
        Point2D.Double ctrl2;
        Point2D.Double ctrl1;
        double t;
        double d = t = x012 - x123 == 0.0 ? (y012 - y0123) / (y012 - y123) : (x012 - x0123) / (x012 - x123);
        if (t == 0.0 || t == 1.0) {
            ctrl1 = new Point2D.Double(x01, y01);
            ctrl2 = new Point2D.Double(x23, y23);
        } else {
            ctrl1 = Points2D.add(Points2D.divide(Points2D.subtract(x01, y01, x0, y0), t), x0, y0);
            ctrl2 = Points2D.add(Points2D.divide(Points2D.subtract(x23, y23, x3, y3), 1.0 - t), x3, y3);
        }
        Point2D.Double joint0123 = CubicCurves.eval(x0, y0, ctrl1.getX(), ctrl1.getY(), ctrl2.getX(), ctrl2.getY(), x3, y3, t).getPoint(Point2D.Double::new);
        if (joint0123.distanceSq(x0123, y0123) <= tolerance * tolerance) {
            double[] dArray2 = new double[8];
            dArray2[0] = x0;
            dArray2[1] = y0;
            dArray2[2] = ctrl1.getX();
            dArray2[3] = ctrl1.getY();
            dArray2[4] = ctrl2.getX();
            dArray2[5] = ctrl2.getY();
            dArray2[6] = x3;
            dArray = dArray2;
            dArray2[7] = y3;
        } else {
            dArray = null;
        }
        return dArray;
    }

    public static SimpleOrderedPair<CubicCurve2D.Double, CubicCurve2D.Double> split(CubicCurve2D.Double source, double t) {
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        CubicCurve2D.Double right = new CubicCurve2D.Double();
        CubicCurves.split(source.x1, source.y1, source.ctrlx1, source.ctrly1, source.ctrlx2, source.ctrly2, source.x2, source.y2, t, left::setCurve, right::setCurve);
        return new SimpleOrderedPair((Object)left, (Object)right);
    }

    public static void split(CubicCurve2D.Double source, double t, CubicCurve2D.Double left, CubicCurve2D.Double right) {
        CubicCurves.split(source.x1, source.y1, source.ctrlx1, source.ctrly1, source.ctrlx2, source.ctrly2, source.x2, source.y2, t, left::setCurve, right::setCurve);
    }

    public static void splitCubicCurveTo(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double t, @Nullable DoubleConsumer6 left, @Nullable DoubleConsumer6 right) {
        CubicCurves.split(x0, y0, x1, y1, x2, y2, x3, y3, t, left == null ? null : (lx, ly, lx1, ly1, lx2, ly2, lx3, ly3) -> left.accept(lx1, ly1, lx2, ly2, lx3, ly3), right == null ? null : (lx, ly, lx1, ly1, lx2, ly2, lx3, ly3) -> right.accept(lx1, ly1, lx2, ly2, lx3, ly3));
    }

    public static void split(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double t, @Nullable DoubleConsumer8 first, @Nullable DoubleConsumer8 second) {
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x23 = Lines.lerp(x2, x3, t);
        double y23 = Lines.lerp(y2, y3, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        double x123 = Lines.lerp(x12, x23, t);
        double y123 = Lines.lerp(y12, y23, t);
        double x0123 = Lines.lerp(x012, x123, t);
        double y0123 = Lines.lerp(y012, y123, t);
        if (first != null) {
            first.accept(x0, y0, x01, y01, x012, y012, x0123, y0123);
        }
        if (second != null) {
            second.accept(x0123, y0123, x123, y123, x23, y23, x3, y3);
        }
    }

    public static void split(double[] p, int o, double t, double[] f, int fo, double[] s, int so) {
        double x0 = p[o];
        double y0 = p[o + 1];
        double x1 = p[o + 2];
        double y1 = p[o + 3];
        double x2 = p[o + 4];
        double y2 = p[o + 5];
        double x3 = p[o + 6];
        double y3 = p[o + 7];
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x23 = Lines.lerp(x2, x3, t);
        double y23 = Lines.lerp(y2, y3, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        double x123 = Lines.lerp(x12, x23, t);
        double y123 = Lines.lerp(y12, y23, t);
        double x0123 = Lines.lerp(x012, x123, t);
        double y0123 = Lines.lerp(y012, y123, t);
        if (f != null) {
            f[fo] = x0;
            f[fo + 1] = y0;
            f[fo + 2] = x01;
            f[fo + 3] = y01;
            f[fo + 4] = x012;
            f[fo + 5] = y012;
            f[fo + 6] = x0123;
            f[fo + 7] = y0123;
        }
        if (s != null) {
            s[so] = x0123;
            s[so + 1] = y0123;
            s[so + 2] = x123;
            s[so + 3] = y123;
            s[so + 4] = x23;
            s[so + 5] = y23;
            s[so + 6] = x3;
            s[so + 7] = y3;
        }
    }

    public static void split(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double t, double[] left, double[] right) {
        CubicCurves.split(x0, y0, x1, y1, x2, y2, x3, y3, t, left == null ? null : (x, y, a, b, c, d, e, f) -> {
            left[0] = a;
            left[1] = b;
            left[2] = c;
            left[3] = d;
            left[4] = e;
            left[5] = f;
        }, right == null ? null : (x, y, a, b, c, d, e, f) -> {
            right[0] = a;
            right[1] = b;
            right[2] = c;
            right[3] = d;
            right[4] = e;
            right[5] = f;
        });
    }

    public static void subCurve(double @NonNull [] q, int qOffset, double ta, double tb, double @NonNull [] segment, int segmentOffset) {
        double tab = ta / tb;
        CubicCurves.split(q, qOffset, tb, null, 0, segment, segmentOffset);
        CubicCurves.split(segment, segmentOffset, tab, null, 0, segment, segmentOffset);
    }

    public static ToDoubleFunction<Double> getArcLengthIntegrand(double[] v, int offset) {
        double x0 = v[offset];
        double y0 = v[offset + 1];
        double x1 = v[offset + 2];
        double y1 = v[offset + 3];
        double x2 = v[offset + 4];
        double y2 = v[offset + 5];
        double x3 = v[offset + 6];
        double y3 = v[offset + 7];
        double ax = 9.0 * (x1 - x2) + 3.0 * (x3 - x0);
        double bx = 6.0 * (x0 + x2) - 12.0 * x1;
        double cx = 3.0 * (x1 - x0);
        double ay = 9.0 * (y1 - y2) + 3.0 * (y3 - y0);
        double by = 6.0 * (y0 + y2) - 12.0 * y1;
        double cy = 3.0 * (y1 - y0);
        return t -> {
            double dx = Math.fma(Math.fma(ax, t, bx), t, cx);
            double dy = Math.fma(Math.fma(ay, t, by), t, cy);
            return Math.sqrt(Math.fma(dx, dx, dy * dy));
        };
    }

    public static double[] toArray(CubicCurve2D.Double c) {
        return new double[]{c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2};
    }

    public static double arcLength(double @NonNull [] p, int offset, double epsilon) {
        return CubicCurves.arcLength(p, offset, 1.0, epsilon);
    }

    public static double arcLength(double @NonNull [] p, int offset, double t, double epsilon) {
        ToDoubleFunction<Double> f = CubicCurves.getArcLengthIntegrand(p, offset);
        return Integrals.rombergQuadrature(f, 0.0, t, epsilon);
    }

    public static double invArcLength(double @NonNull [] p, int offset, double s, double epsilon) {
        return CubicCurves.invArcLength(p, offset, s, CubicCurves.arcLength(p, offset, 1.0, epsilon), epsilon);
    }

    public static double invArcLength(double @NonNull [] p, int offset, double s, double totalArcLength, double epsilon) {
        ToDoubleFunction<Double> f = CubicCurves.getArcLengthIntegrand(p, offset);
        return Solvers.hybridNewtonBisectionMethod((Function3<ToDoubleFunction<Double>, Double, Double, Double>)((Function3)Integrals::rombergQuadrature), f, s, 0.0, 1.0, s / totalArcLength, epsilon);
    }
}

