/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectLineLine;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class FXGeom {
    private FXGeom() {
    }

    public static @NonNull Point2D lerp(@NonNull Point2D start, @NonNull Point2D end, double t) {
        return FXGeom.lerp(start.getX(), start.getY(), end.getX(), end.getY(), t);
    }

    public static @NonNull Point2D lerp(double x0, double y0, double x1, double y1, double t) {
        return new Point2D(x0 + (x1 - x0) * t, y0 + (y1 - y0) * t);
    }

    public static @NonNull Point3D homogenize(@NonNull Point3D p) {
        return new Point3D(p.getX() / p.getZ(), p.getY() / p.getZ(), 1.0);
    }

    public static @NonNull Point2D homogenize2D(@NonNull Point3D p) {
        double z = p.getZ();
        return new Point2D(p.getX() / z, p.getY() / z);
    }

    public static double angle(Point2D a, Point2D b) {
        double dy = b.getY() - a.getY();
        double dx = b.getX() - a.getX();
        return Angles.atan2(dy, dx);
    }

    public static @NonNull Point2D angleToPoint(@NonNull Rectangle2D r, double angle) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        double e = 1.0E-4;
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(si) > e) {
            x = (1.0 + co / Math.abs(si)) / 2.0 * r.getWidth();
            x = MathUtil.clamp((double)x, (double)0.0, (double)r.getWidth());
        } else if (co >= 0.0) {
            x = r.getWidth();
        }
        if (Math.abs(co) > e) {
            y = (1.0 + si / Math.abs(co)) / 2.0 * r.getHeight();
            y = MathUtil.clamp((double)y, (double)0.0, (double)r.getHeight());
        } else if (si >= 0.0) {
            y = r.getHeight();
        }
        return new Point2D(r.getMinX() + x, r.getMinY() + y);
    }

    public static boolean isCollinear(@NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2) {
        return Lines.isCollinear(p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static @NonNull Point2D chop(@NonNull Shape shape, @NonNull Point2D p) {
        java.awt.geom.Rectangle2D bounds = shape.getBounds2D();
        Point2D.Double ctr = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        double cx = -1.0;
        double cy = -1.0;
        double len = Double.MAX_VALUE;
        PathIterator i = shape.getPathIterator(new AffineTransform(), 1.0);
        double[] coords = new double[6];
        double prevX = coords[0];
        double prevY = coords[1];
        double moveToX = prevX;
        double moveToY = prevY;
        i.next();
        while (!i.isDone()) {
            double y;
            IntersectionPointEx firstIntersection;
            double x;
            double cl;
            switch (i.currentSegment(coords)) {
                case 0: {
                    moveToX = coords[0];
                    moveToY = coords[1];
                    break;
                }
                case 4: {
                    coords[0] = moveToX;
                    coords[1] = moveToY;
                }
            }
            IntersectionResultEx chop = IntersectLineLine.intersectLineLineEx(prevX, prevY, coords[0], coords[1], p.getX(), p.getY(), ctr.getX(), ctr.getY());
            if (chop.getStatus() == IntersectionStatus.INTERSECTION && (cl = Points.squaredDistance(x = (firstIntersection = (IntersectionPointEx)chop.intersections().getFirst()).getX(), y = firstIntersection.getY(), p.getX(), p.getY())) < len) {
                len = cl;
                cx = x;
                cy = y;
            }
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        if (len == Double.MAX_VALUE) {
            i = shape.getPathIterator(new AffineTransform(), 1.0);
            while (!i.isDone()) {
                i.currentSegment(coords);
                double l = Points.squaredDistance(ctr.x, ctr.y, coords[0], coords[1]);
                if (l < len) {
                    len = l;
                    cx = coords[0];
                    cy = coords[1];
                }
                i.next();
            }
        }
        return new Point2D(cx, cy);
    }

    public static double length(@NonNull Point2D p1, @NonNull Point2D p2) {
        return Math.sqrt(Points.squaredDistance(p1.getX(), p1.getY(), p2.getX(), p2.getY()));
    }

    public static @NonNull Point2D ovalAngleToPoint(@NonNull Rectangle2D r, double angle) {
        Point2D center = FXRectangles.center(r);
        Point2D p = FXGeom.polarToPoint(angle, r.getWidth() / 2.0, r.getHeight() / 2.0);
        return new Point2D(center.getX() + p.getX(), center.getY() + p.getY());
    }

    public static @NonNull Point2D perp(double l1x, double l1y, double l2x, double l2y) {
        double vy = l2y - l1y;
        double cvx = -vy;
        double vx = l2x - l1x;
        double cvy = vx;
        double norm = Math.sqrt(cvx * cvx + cvy * cvy);
        double m = norm == 0.0 ? 0.0 : 1.0 / norm;
        return new Point2D(cvx * m, cvy * m);
    }

    public static double pointToAngle(@NonNull Rectangle2D r, @NonNull Point2D p) {
        double px = p.getX() - (r.getMinX() + r.getWidth() * 0.5);
        double py = p.getY() - (r.getMinY() + r.getHeight() * 0.5);
        return Angles.atan2(py * r.getWidth(), px * r.getHeight());
    }

    public static @NonNull Point2D polarToPoint(double angle, double fx, double fy) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        return new Point2D((double)((int)(fx * co)), (double)((int)(fy * si)));
    }

    public static @NonNull Point2D shiftPerp(@NonNull Point2D l1, @NonNull Point2D l2, @NonNull Point2D p, double distance) {
        return FXGeom.shiftPerp(l1.getX(), l1.getY(), l2.getX(), l2.getY(), p.getX(), p.getY(), distance);
    }

    public static double squaredMagnitude(@NonNull Point2D p) {
        double x = p.getX();
        double y = p.getY();
        return x * x + y * y;
    }

    public static @NonNull Point2D perp(@NonNull Point2D vector) {
        return new Point2D(vector.getY(), -vector.getX());
    }

    public static Point2D perp(double l1x, double l1y, double l2x, double l2y, double length) {
        return FXGeom.perp(l1x, l1y, l2x, l2y).multiply(length);
    }

    public static @NonNull Point2D shiftPerp(double l1x, double l1y, double l2x, double l2y, double px, double py, double distance) {
        double vx = l2x - l1x;
        double vy = l2y - l1y;
        double perpX = -vy;
        double perpY = vx;
        double m = distance / Math.sqrt(perpX * perpY);
        return new Point2D(px + perpX * m, py + perpY * m);
    }

    public static double distanceSq(@NonNull Point2D p, @NonNull Point2D q) {
        double \u0394x = p.getX() - q.getX();
        double \u0394y = p.getY() - q.getY();
        return \u0394x * \u0394x + \u0394y * \u0394y;
    }

    public static double distanceSq(@NonNull java.awt.geom.Point2D p, @NonNull java.awt.geom.Point2D q) {
        double \u0394x = p.getX() - q.getX();
        double \u0394y = p.getY() - q.getY();
        return \u0394x * \u0394x + \u0394y * \u0394y;
    }

    public static double distanceSq(@NonNull Point2D p, double x, double y) {
        double \u0394x = p.getX() - x;
        double \u0394y = p.getY() - y;
        return \u0394x * \u0394x + \u0394y * \u0394y;
    }

    public static @Nullable Point2D intersect(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd) {
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point2D(xb, yb);
                }
                return new Point2D(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            double px = xa + (xb - xa) * r;
            double py = ya + (yb - ya) * r;
            return new Point2D(px, py);
        }
        return null;
    }

    public static @Nullable Point2D intersect(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd, double limit) {
        double limit2 = limit * limit;
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point2D(xb, yb);
                }
                return new Point2D(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            double px = xa + (xb - xa) * r;
            double py = ya + (yb - ya) * r;
            return new Point2D(px, py);
        }
        double px = xa + (xb - xa) * r;
        double py = ya + (yb - ya) * r;
        if (Points.squaredDistance(xa, ya, px, py) <= limit2 || Points.squaredDistance(xb, yb, px, py) <= limit2 || Points.squaredDistance(xc, yc, px, py) <= limit2 || Points.squaredDistance(xd, yd, px, py) <= limit2) {
            return new Point2D(px, py);
        }
        return null;
    }

    public static @NonNull Point2D divide(@NonNull Point2D p, double factor) {
        return new Point2D(p.getX() / factor, p.getY() / factor);
    }

    public static @NonNull Transform toDeltaTransform(@NonNull Transform t) {
        Affine d = new Affine(t.getMxx(), t.getMxy(), 0.0, t.getMyx(), t.getMyy(), 0.0);
        return d;
    }

    public static @NonNull Point3D hcross(@NonNull Point2D p1, @NonNull Point2D p2) {
        return FXGeom.hcross(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static @NonNull Point3D hcross(double x1, double y1, double x2, double y2) {
        return new Point3D(y1 * 1.0 - 1.0 * y2, 1.0 * x2 - x1 * 1.0, x1 * y2 - y1 * x2);
    }
}

