/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Text;
import javafx.scene.transform.MatrixType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.AwtPathBuilder;
import org.jhotdraw8.geom.FXSvgPaths;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.PathIteratorPathBuilder;
import org.jhotdraw8.geom.SvgPath2D;
import org.jhotdraw8.geom.SvgPaths;

public class FXShapes {
    private static final Logger LOGGER = Logger.getLogger(FXShapes.class.getName());

    private FXShapes() {
    }

    public static int awtCapFromFX(@Nullable StrokeLineCap cap) {
        if (cap == null) {
            return 0;
        }
        return switch (cap) {
            default -> 0;
            case StrokeLineCap.ROUND -> 1;
            case StrokeLineCap.SQUARE -> 2;
        };
    }

    public static int awtJoinFromFX(@Nullable StrokeLineJoin join) {
        if (join == null) {
            return 2;
        }
        return switch (join) {
            default -> 2;
            case StrokeLineJoin.MITER -> 0;
            case StrokeLineJoin.ROUND -> 1;
        };
    }

    public static PathIterator awtPathIteratorFromFXPathElements(List<PathElement> pathElements, int windingRule, AffineTransform tx) {
        PathIteratorPathBuilder b = new PathIteratorPathBuilder(windingRule);
        FXSvgPaths.buildFromPathElements(b, pathElements);
        return b.build();
    }

    public static @NonNull PathIterator awtPathIteratorFromFxPoint2Ds(final @NonNull List<Point2D> points, final boolean closed, final int windingRule, final @Nullable AffineTransform tx) {
        return new PathIterator(){
            final float @NonNull [] srcf = new float[2];
            final double @NonNull [] srcd = new double[2];
            private final int size = points.size();
            int index = 0;

            @Override
            public int currentSegment(float[] coords) {
                if (this.index < this.size) {
                    Point2D p = (Point2D)points.get(this.index);
                    if (tx == null) {
                        coords[0] = (float)p.getX();
                        coords[1] = (float)p.getY();
                    } else {
                        this.srcf[0] = (float)p.getX();
                        this.srcf[1] = (float)p.getY();
                        tx.transform(this.srcf, 0, coords, 0, 1);
                    }
                    return this.index == 0 ? 0 : 1;
                }
                if (this.index == this.size && closed) {
                    return 4;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int currentSegment(double[] coords) {
                if (this.index < this.size) {
                    Point2D p = (Point2D)points.get(this.index);
                    if (tx == null) {
                        coords[0] = p.getX();
                        coords[1] = p.getY();
                    } else {
                        this.srcd[0] = p.getX();
                        this.srcd[1] = p.getY();
                        tx.transform(this.srcd, 0, coords, 0, 1);
                    }
                    return this.index == 0 ? 0 : 1;
                }
                if (this.index == this.size && closed) {
                    return 4;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getWindingRule() {
                return windingRule;
            }

            @Override
            public boolean isDone() {
                return this.index >= this.size + (closed ? 1 : 0);
            }

            @Override
            public void next() {
                if (this.index < this.size + (closed ? 1 : 0)) {
                    ++this.index;
                }
            }
        };
    }

    public static Shape awtShapeFromFX(javafx.scene.shape.Shape fx) {
        javafx.scene.shape.Shape shape = fx;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arc.class, Circle.class, CubicCurve.class, Ellipse.class, Line.class, Path.class, Polygon.class, Polyline.class, QuadCurve.class, Rectangle.class, SVGPath.class, Text.class}, (Object)shape, n)) {
            case 0: {
                Arc arc = (Arc)shape;
                return FXShapes.awtShapeFromFXArc(arc);
            }
            case 1: {
                Circle circle = (Circle)shape;
                return FXShapes.awtShapeFromFXCircle(circle);
            }
            case 2: {
                CubicCurve cubicCurve = (CubicCurve)shape;
                return FXShapes.awtShapeFromFXCubicCurve(cubicCurve);
            }
            case 3: {
                Ellipse ellipse = (Ellipse)shape;
                return FXShapes.awtShapeFromFXEllipse(ellipse);
            }
            case 4: {
                Line line = (Line)shape;
                return FXShapes.awtShapeFromFXLine(line);
            }
            case 5: {
                Path path = (Path)shape;
                return FXShapes.awtShapeFromFXPath(path);
            }
            case 6: {
                Polygon polygon = (Polygon)shape;
                return FXShapes.awtShapeFromFXPolygon(polygon);
            }
            case 7: {
                Polyline polyline = (Polyline)shape;
                return FXShapes.awtShapeFromFXPolyline(polyline);
            }
            case 8: {
                QuadCurve quadCurve = (QuadCurve)shape;
                return FXShapes.awtShapeFromFXQuadCurve(quadCurve);
            }
            case 9: {
                Rectangle rectangle = (Rectangle)shape;
                return FXShapes.awtShapeFromFXRectangle(rectangle);
            }
            case 10: {
                SVGPath svgPath = (SVGPath)shape;
                try {
                    return FXShapes.awtShapeFromFXSvgPath((SVGPath)fx);
                }
                catch (ParseException e) {
                    LOGGER.warning("Illegal path: " + e.getMessage());
                    Bounds b = fx.getLayoutBounds();
                    return new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                }
            }
            case 11: {
                Text text = (Text)shape;
                return FXShapes.awtShapeFromFXText(text);
            }
        }
        LOGGER.warning("Unsupported shape: " + String.valueOf(fx));
        Bounds b = fx.getLayoutBounds();
        return new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    private static @NonNull Shape awtShapeFromFXArc(@NonNull Arc node) {
        double centerX = node.getCenterX();
        double centerY = node.getCenterY();
        double radiusX = node.getRadiusX();
        double radiusY = node.getRadiusY();
        double startAngle = Math.toRadians(-node.getStartAngle());
        double endAngle = Math.toRadians(-node.getStartAngle() - node.getLength());
        double length = node.getLength();
        double startX = radiusX * Math.cos(startAngle);
        double startY = radiusY * Math.sin(startAngle);
        double endX = centerX + radiusX * Math.cos(endAngle);
        double endY = centerY + radiusY * Math.sin(endAngle);
        boolean xAxisRot = false;
        boolean largeArc = length > 180.0;
        boolean sweep = length < 0.0;
        SvgPath2D p = new SvgPath2D();
        p.moveTo(centerX, centerY);
        if (ArcType.ROUND == node.getType()) {
            p.lineTo(startX, startY);
        }
        p.arcTo(radiusX, radiusY, (double)xAxisRot, endX, endY, largeArc, sweep);
        if (ArcType.CHORD == node.getType() || ArcType.ROUND == node.getType()) {
            p.closePath();
        }
        return p;
    }

    public static @NonNull Shape awtShapeFromFXBounds(@NonNull Bounds node) {
        return new Rectangle2D.Double(node.getMinX(), node.getMinY(), node.getWidth(), node.getHeight());
    }

    private static @NonNull Shape awtShapeFromFXCircle(@NonNull Circle node) {
        double x = node.getCenterX();
        double y = node.getCenterY();
        double r = node.getRadius();
        return new Ellipse2D.Double(x - r, y - r, r * 2.0, r * 2.0);
    }

    private static @NonNull Shape awtShapeFromFXCubicCurve(@NonNull CubicCurve e) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(e.getStartX(), e.getStartY());
        p.curveTo(e.getControlX1(), e.getControlY1(), e.getControlX2(), e.getControlY2(), e.getEndX(), e.getEndY());
        return p;
    }

    private static @NonNull Shape awtShapeFromFXEllipse(@NonNull Ellipse node) {
        double x = node.getCenterX();
        double y = node.getCenterY();
        double rx = node.getRadiusX();
        double ry = node.getRadiusY();
        return new Ellipse2D.Double(x - rx, y - ry, rx * 2.0, ry * 2.0);
    }

    private static @NonNull Shape awtShapeFromFXLine(@NonNull Line node) {
        Line2D.Double p = new Line2D.Double(node.getStartX(), node.getStartY(), node.getEndX(), node.getEndY());
        return p;
    }

    private static @NonNull Shape awtShapeFromFXPath(@NonNull Path node) {
        return FXShapes.awtShapeFromFXPathElements((Iterable<PathElement>)node.getElements(), node.getFillRule());
    }

    public static @NonNull Shape awtShapeFromFXPathElements(@NonNull Iterable<PathElement> pathElements, FillRule fillRule) {
        Path2D.Double p = FXShapes.buildFromPathElements(new AwtPathBuilder(), pathElements).build();
        p.setWindingRule(fillRule == FillRule.NON_ZERO ? 1 : 0);
        return p;
    }

    public static <T extends PathBuilder<?>> @NonNull T buildFromPathElements(@NonNull T p, @NonNull Iterable<PathElement> pathElements) {
        double x = 0.0;
        double y = 0.0;
        for (PathElement pe : pathElements) {
            if (pe instanceof MoveTo) {
                MoveTo e = (MoveTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                } else {
                    x += e.getX();
                    y += e.getY();
                }
                p.moveTo(x, y);
                continue;
            }
            if (pe instanceof LineTo) {
                LineTo e = (LineTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                } else {
                    x += e.getX();
                    y += e.getY();
                }
                p.lineTo(x, y);
                continue;
            }
            if (pe instanceof CubicCurveTo) {
                double cy2;
                double cx2;
                double cy1;
                double cx1;
                CubicCurveTo e = (CubicCurveTo)pe;
                if (e.isAbsolute()) {
                    cx1 = e.getControlX1();
                    cy1 = e.getControlY1();
                    cx2 = e.getControlX2();
                    cy2 = e.getControlY2();
                    x = e.getX();
                    y = e.getY();
                } else {
                    cx1 = x + e.getControlX1();
                    cy1 = y + e.getControlY1();
                    cx2 = x + e.getControlX2();
                    cy2 = y + e.getControlY2();
                    x += e.getX();
                    y += e.getY();
                }
                p.curveTo(cx1, cy1, cx2, cy2, x, y);
                continue;
            }
            if (pe instanceof QuadCurveTo) {
                double cy;
                double cx;
                QuadCurveTo e = (QuadCurveTo)pe;
                if (e.isAbsolute()) {
                    cx = e.getControlX();
                    cy = e.getControlY();
                    x = e.getX();
                    y = e.getY();
                } else {
                    cx = x + e.getControlX();
                    cy = y + e.getControlY();
                    x += e.getX();
                    y += e.getY();
                }
                p.quadTo(cx, cy, x, y);
                continue;
            }
            if (pe instanceof ArcTo) {
                ArcTo e = (ArcTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                } else {
                    x += e.getX();
                    y += e.getY();
                }
                p.arcTo(e.getRadiusX(), e.getRadiusY(), e.getXAxisRotation(), x, y, e.isLargeArcFlag(), e.isSweepFlag());
                continue;
            }
            if (pe instanceof HLineTo) {
                HLineTo e = (HLineTo)pe;
                x = e.isAbsolute() ? e.getX() : (x += e.getX());
                p.lineTo(x, y);
                continue;
            }
            if (pe instanceof VLineTo) {
                VLineTo e = (VLineTo)pe;
                y = e.isAbsolute() ? e.getY() : (y += e.getY());
                p.lineTo(x, y);
                continue;
            }
            if (!(pe instanceof ClosePath)) continue;
            p.closePath();
        }
        return p;
    }

    private static @NonNull Shape awtShapeFromFXPolygon(@NonNull Polygon node) {
        Path2D.Double p = new Path2D.Double();
        ObservableList ps = node.getPoints();
        int n = ps.size();
        for (int i = 0; i < n; i += 2) {
            if (i == 0) {
                p.moveTo((Double)ps.get(i), (Double)ps.get(i + 1));
                continue;
            }
            p.lineTo((Double)ps.get(i), (Double)ps.get(i + 1));
        }
        p.closePath();
        return p;
    }

    private static @NonNull Shape awtShapeFromFXPolyline(@NonNull Polyline node) {
        Path2D.Double p = new Path2D.Double();
        ObservableList ps = node.getPoints();
        int n = ps.size();
        for (int i = 0; i < n; i += 2) {
            if (i == 0) {
                p.moveTo((Double)ps.get(i), (Double)ps.get(i + 1));
                continue;
            }
            p.lineTo((Double)ps.get(i), (Double)ps.get(i + 1));
        }
        return p;
    }

    private static @NonNull Shape awtShapeFromFXQuadCurve(@NonNull QuadCurve node) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(node.getStartX(), node.getStartY());
        p.quadTo(node.getControlX(), node.getControlY(), node.getEndX(), node.getEndY());
        return p;
    }

    public static @NonNull Shape awtShapeFromFXRectangle(@NonNull Rectangle node) {
        if (node.getArcHeight() == 0.0 && node.getArcWidth() == 0.0) {
            return new Rectangle2D.Double(node.getX(), node.getY(), node.getWidth(), node.getHeight());
        }
        return new RoundRectangle2D.Double(node.getX(), node.getY(), node.getWidth(), node.getHeight(), node.getArcWidth(), node.getArcHeight());
    }

    private static Shape awtShapeFromFXSvgPath(@NonNull SVGPath node) throws ParseException {
        AwtPathBuilder b = new AwtPathBuilder();
        SvgPaths.svgStringToBuilder(node.getContent(), b);
        return b.build();
    }

    private static @NonNull Shape awtShapeFromFXText(@NonNull Text node) {
        Path path = (Path)javafx.scene.shape.Shape.subtract((javafx.scene.shape.Shape)node, (javafx.scene.shape.Shape)new Rectangle());
        return FXShapes.awtShapeFromFXPath(path);
    }

    public static @Nullable AffineTransform awtTransformFromFX(@Nullable Transform fxT) {
        if (fxT == null) {
            return null;
        }
        double[] m = fxT.toArray(MatrixType.MT_2D_2x3);
        return new AffineTransform(m[0], m[3], m[1], m[4], m[2], m[5]);
    }

    public static @NonNull List<PathElement> fxPathElementsFromAwt(@NonNull PathIterator iter) {
        ArrayList<PathElement> fxelem = new ArrayList<PathElement>();
        double[] coords = new double[6];
        while (!iter.isDone()) {
            switch (iter.currentSegment(coords)) {
                case 4: {
                    fxelem.add((PathElement)new ClosePath());
                    break;
                }
                case 3: {
                    fxelem.add((PathElement)new CubicCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]));
                    break;
                }
                case 1: {
                    fxelem.add((PathElement)new LineTo(coords[0], coords[1]));
                    break;
                }
                case 0: {
                    fxelem.add((PathElement)new MoveTo(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    fxelem.add((PathElement)new QuadCurveTo(coords[0], coords[1], coords[2], coords[3]));
                }
            }
            iter.next();
        }
        return fxelem;
    }

    public static @NonNull Path fxShapeFromAwt(@NonNull Shape shape, Transform fxT) {
        return FXShapes.fxShapeFromAwt(shape.getPathIterator(FXShapes.awtTransformFromFX(fxT)));
    }

    public static @NonNull Path fxShapeFromAwt(@NonNull Shape shape, AffineTransform at) {
        return FXShapes.fxShapeFromAwt(shape.getPathIterator(at));
    }

    public static @NonNull Path fxShapeFromAwt(@NonNull Shape shape) {
        return FXShapes.fxShapeFromAwt(shape.getPathIterator(null));
    }

    public static @NonNull Path fxShapeFromAwt(@NonNull PathIterator iter) {
        Path fxpath = new Path();
        switch (iter.getWindingRule()) {
            case 0: {
                fxpath.setFillRule(FillRule.EVEN_ODD);
                break;
            }
            case 1: {
                fxpath.setFillRule(FillRule.NON_ZERO);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal winding rule " + iter.getWindingRule());
            }
        }
        fxpath.getElements().addAll(FXShapes.fxPathElementsFromAwt(iter));
        return fxpath;
    }
}

