/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.VLineTo;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.converter.NumberConverter;
import org.jhotdraw8.base.io.StreamPosTokenizer;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.SvgPaths;

public class FXSvgPaths {
    private FXSvgPaths() {
    }

    public static @NonNull String doubleSvgStringFromPathElements(@NonNull List<PathElement> elements) {
        NumberConverter nb = new NumberConverter();
        return FXSvgPaths.svgStringFromPathElements(elements, nb);
    }

    public static @NonNull String floatSvgStringFromPathElements(@NonNull List<PathElement> elements) {
        NumberConverter nb = new NumberConverter(Float.class);
        return FXSvgPaths.svgStringFromPathElements(elements, nb);
    }

    public static @NonNull String svgStringFromPathElements(@NonNull List<PathElement> elements, NumberConverter nb) {
        StringBuilder buf = new StringBuilder();
        char next = 'Z';
        double x = 0.0;
        double y = 0.0;
        double ix = 0.0;
        double iy = 0.0;
        for (PathElement pe : elements) {
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            if (pe instanceof MoveTo) {
                MoveTo e = (MoveTo)pe;
                if (e.isAbsolute()) {
                    buf.append('M');
                    next = 'L';
                    ix = x = e.getX();
                    iy = y = e.getY();
                    buf.append(nb.toString((Object)x)).append(',').append(nb.toString((Object)y));
                    continue;
                }
                buf.append('m');
                next = 'l';
                buf.append(nb.toString((Object)e.getX())).append(',').append(nb.toString((Object)e.getY()));
                ix = x += e.getX();
                iy = y += e.getY();
                continue;
            }
            if (pe instanceof LineTo) {
                LineTo e = (LineTo)pe;
                if (e.isAbsolute()) {
                    if (next != 'L') {
                        next = 'L';
                        buf.append('L');
                    }
                    ix = x = e.getX();
                    iy = y = e.getY();
                    buf.append(nb.toString((Object)x)).append(',').append(nb.toString((Object)y));
                    continue;
                }
                if (next != 'l') {
                    next = 'l';
                    buf.append('l');
                }
                buf.append(nb.toString((Object)e.getX())).append(',').append(nb.toString((Object)e.getY()));
                ix = x += e.getX();
                iy = y += e.getY();
                continue;
            }
            if (pe instanceof CubicCurveTo) {
                CubicCurveTo e = (CubicCurveTo)pe;
                if (e.isAbsolute()) {
                    if (next != 'C') {
                        next = 'C';
                        buf.append('C');
                    }
                    x = e.getX();
                    y = e.getY();
                    buf.append(nb.toString((Object)e.getControlX1())).append(',').append(nb.toString((Object)e.getControlY1())).append(',').append(nb.toString((Object)e.getControlX2())).append(',').append(nb.toString((Object)e.getControlY2())).append(',').append(nb.toString((Object)x)).append(',').append(nb.toString((Object)y));
                    continue;
                }
                if (next != 'c') {
                    next = 'c';
                    buf.append('c');
                }
                buf.append(nb.toString((Object)e.getControlX1())).append(',').append(nb.toString((Object)e.getControlY1())).append(',').append(nb.toString((Object)e.getControlX2())).append(',').append(nb.toString((Object)e.getControlY2())).append(',').append(nb.toString((Object)e.getX())).append(',').append(nb.toString((Object)e.getY()));
                x += e.getX();
                y += e.getY();
                continue;
            }
            if (pe instanceof QuadCurveTo) {
                QuadCurveTo e = (QuadCurveTo)pe;
                if (e.isAbsolute()) {
                    if (next != 'Q') {
                        next = 'Q';
                        buf.append('Q');
                    }
                    x = e.getX();
                    y = e.getY();
                    buf.append(nb.toString((Object)e.getControlX())).append(',').append(nb.toString((Object)e.getControlY())).append(',').append(nb.toString((Object)x)).append(',').append(nb.toString((Object)y));
                    continue;
                }
                if (next != 'q') {
                    next = 'q';
                    buf.append('q');
                }
                buf.append(nb.toString((Object)e.getControlX())).append(',').append(nb.toString((Object)e.getControlY())).append(',').append(nb.toString((Object)e.getX())).append(',').append(nb.toString((Object)e.getY()));
                x += e.getX();
                y += e.getY();
                continue;
            }
            if (pe instanceof ArcTo) {
                ArcTo e = (ArcTo)pe;
                if (e.isAbsolute()) {
                    if (next != 'A') {
                        next = 'A';
                        buf.append('A');
                    }
                    x = e.getX();
                    y = e.getY();
                    buf.append(nb.toString((Object)e.getRadiusX())).append(',').append(nb.toString((Object)e.getRadiusY())).append(' ').append(nb.toString((Object)e.getXAxisRotation())).append(' ').append(e.isLargeArcFlag() ? (char)'1' : '0').append(',').append(e.isSweepFlag() ? (char)'1' : '0').append(' ').append(nb.toString((Object)x)).append(',').append(nb.toString((Object)y));
                    continue;
                }
                if (next != 'a') {
                    next = 'a';
                    buf.append('a');
                }
                buf.append(nb.toString((Object)e.getRadiusX())).append(',').append(nb.toString((Object)e.getRadiusY())).append(' ').append(nb.toString((Object)e.getXAxisRotation())).append(' ').append(e.isLargeArcFlag() ? (char)'1' : '0').append(',').append(e.isSweepFlag() ? (char)'1' : '0').append(' ').append(nb.toString((Object)e.getX())).append(',').append(nb.toString((Object)e.getY()));
                x += e.getX();
                y += e.getY();
                continue;
            }
            if (pe instanceof HLineTo) {
                HLineTo e = (HLineTo)pe;
                if (e.isAbsolute()) {
                    if (next != 'H') {
                        next = 'H';
                        buf.append('H');
                    }
                    x = e.getX();
                    buf.append(nb.toString((Object)x));
                    continue;
                }
                if (next != 'h') {
                    next = 'h';
                    buf.append('h');
                }
                buf.append(nb.toString((Object)e.getX()));
                x += e.getX();
                continue;
            }
            if (pe instanceof VLineTo) {
                VLineTo e = (VLineTo)pe;
                if (e.isAbsolute()) {
                    if (next != 'V') {
                        next = 'V';
                        buf.append('V');
                    }
                    y = e.getY();
                    buf.append(nb.toString((Object)y));
                    continue;
                }
                if (next != 'v') {
                    next = 'v';
                    buf.append('v');
                }
                buf.append(nb.toString((Object)e.getY()));
                y += e.getY();
                continue;
            }
            if (!(pe instanceof ClosePath)) continue;
            ClosePath e = (ClosePath)pe;
            if (e.isAbsolute()) {
                if (next != 'Z') {
                    next = 'Z';
                    buf.append('Z');
                }
            } else if (next != 'z') {
                next = 'z';
                buf.append('z');
            }
            x = ix;
            y = iy;
        }
        return buf.toString();
    }

    public static @NonNull List<PathElement> pathElementsFromSvgString(@NonNull String str) throws ParseException {
        ArrayList<PathElement> builder = new ArrayList<PathElement>();
        try {
            StreamPosTokenizer tt = new StreamPosTokenizer((Reader)new StringReader(str));
            tt.resetSyntax();
            tt.parseNumbers();
            tt.parseExponents();
            tt.parsePlusAsNumber();
            tt.whitespaceChars(0, 32);
            tt.whitespaceChars(44, 44);
            int next = 77;
            int command = 77;
            double x = 0.0;
            double y = 0.0;
            double cx1 = 0.0;
            double cy1 = 0.0;
            double cx2 = 0.0;
            double cy2 = 0.0;
            double ix = 0.0;
            double iy = 0.0;
            boolean first = true;
            while (tt.nextToken() != -1) {
                double px = x;
                double py = y;
                if (tt.ttype > 0) {
                    command = (char)tt.ttype;
                } else {
                    command = next;
                    tt.pushBack();
                }
                switch (command) {
                    case 77: {
                        tt.requireNextToken(-2, "x coordinate missing for 'M'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'M'");
                        y = tt.nval;
                        builder.add((PathElement)new MoveTo(x, y));
                        next = 76;
                        cx2 = cx1 = x;
                        ix = cx1;
                        cy2 = cy1 = y;
                        iy = cy1;
                        break;
                    }
                    case 109: {
                        tt.requireNextToken(-2, "dx coordinate missing for 'm'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "dy coordinate missing for 'm'");
                        y = tt.nval;
                        MoveTo moveTo = new MoveTo(x, y);
                        if (!first) {
                            moveTo.setAbsolute(false);
                        }
                        builder.add((PathElement)moveTo);
                        next = 108;
                        cx1 = x += px;
                        cx2 = x;
                        ix = x;
                        cy1 = y += px;
                        cy2 = y;
                        iy = y;
                        break;
                    }
                    case 90: {
                        builder.add((PathElement)new ClosePath());
                        next = 90;
                        cx1 = x = ix;
                        cx2 = x;
                        cy1 = y = iy;
                        cy2 = y;
                        break;
                    }
                    case 122: {
                        ClosePath closePath = new ClosePath();
                        closePath.setAbsolute(false);
                        builder.add((PathElement)closePath);
                        next = 122;
                        cx1 = x = ix;
                        cx2 = x;
                        cy1 = y = iy;
                        cy2 = y;
                        break;
                    }
                    case 76: {
                        tt.requireNextToken(-2, "x coordinate missing for 'L'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'L'");
                        y = tt.nval;
                        builder.add((PathElement)new LineTo(x, y));
                        next = 76;
                        cx2 = cx1 = x;
                        cy2 = cy1 = y;
                        break;
                    }
                    case 108: {
                        tt.requireNextToken(-2, "dx coordinate missing for 'l'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "dy coordinate missing for 'l'");
                        y = tt.nval;
                        LineTo lineTo = new LineTo(x, y);
                        lineTo.setAbsolute(false);
                        builder.add((PathElement)lineTo);
                        next = 108;
                        cx1 = x += px;
                        cx2 = x;
                        cy1 = y += px;
                        cy2 = y;
                        break;
                    }
                    case 72: {
                        tt.requireNextToken(-2, "x coordinate missing for 'H'");
                        x = tt.nval;
                        builder.add((PathElement)new HLineTo(x));
                        next = 72;
                        cx2 = cx1 = x;
                        cy2 = cy1 = y;
                        break;
                    }
                    case 104: {
                        tt.requireNextToken(-2, "dx coordinate missing for 'h'");
                        x = tt.nval;
                        HLineTo hLineTo = new HLineTo(x);
                        hLineTo.setAbsolute(false);
                        builder.add((PathElement)hLineTo);
                        next = 104;
                        cy1 = x += px;
                        cx2 = x;
                        cy2 = cy1 = y;
                        break;
                    }
                    case 86: {
                        tt.requireNextToken(-2, "y coordinate missing for 'V'");
                        y = tt.nval;
                        builder.add((PathElement)new VLineTo(y));
                        next = 86;
                        cx2 = cx1 = x;
                        cy2 = cy1 = y;
                        break;
                    }
                    case 118: {
                        tt.requireNextToken(-2, "dy coordinate missing for 'v'");
                        y = tt.nval;
                        VLineTo vLineTo = new VLineTo(y);
                        vLineTo.setAbsolute(false);
                        builder.add((PathElement)vLineTo);
                        next = 118;
                        cx2 = cy1 = x;
                        cy1 = y += py;
                        cy2 += y;
                        break;
                    }
                    case 67: {
                        tt.requireNextToken(-2, "x1 coordinate missing for 'C'");
                        cx1 = tt.nval;
                        tt.requireNextToken(-2, "y1 coordinate missing for 'C'");
                        cy1 = tt.nval;
                        tt.requireNextToken(-2, "x2 coordinate missing for 'C'");
                        cx2 = tt.nval;
                        tt.requireNextToken(-2, "y2 coordinate missing for 'C'");
                        cy2 = tt.nval;
                        tt.requireNextToken(-2, "x coordinate missing for 'C'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'C'");
                        y = tt.nval;
                        builder.add((PathElement)new CubicCurveTo(cx1, cy1, cx2, cy2, x, y));
                        next = 67;
                        break;
                    }
                    case 99: {
                        tt.requireNextToken(-2, "dx1 coordinate missing for 'c'");
                        cx1 = tt.nval;
                        tt.requireNextToken(-2, "dy1 coordinate missing for 'c'");
                        cy1 = tt.nval;
                        tt.requireNextToken(-2, "dx2 coordinate missing for 'c'");
                        cx2 = tt.nval;
                        tt.requireNextToken(-2, "dy2 coordinate missing for 'c'");
                        cy2 = tt.nval;
                        tt.requireNextToken(-2, "dx coordinate missing for 'c'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "dy coordinate missing for 'c'");
                        y = tt.nval;
                        CubicCurveTo cubi = new CubicCurveTo(cx1, cy1, cx2, cy2, x, y);
                        cubi.setAbsolute(false);
                        builder.add((PathElement)cubi);
                        next = 99;
                        cx1 += px;
                        cy1 += py;
                        cx2 += px;
                        cy2 += py;
                        x += py;
                        y += py;
                        break;
                    }
                    case 83: {
                        cx1 = x - cx2 + x;
                        cy1 = x - cy2 + y;
                        tt.requireNextToken(-2, "x2 coordinate missing for 'S'");
                        cx2 = tt.nval;
                        tt.requireNextToken(-2, "y2 coordinate missing for 'S'");
                        cy2 = tt.nval;
                        tt.requireNextToken(-2, "x coordinate missing for 'S'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'S'");
                        y = tt.nval;
                        builder.add((PathElement)new CubicCurveTo(cx1, cy1, cx2, cy2, x, y));
                        next = 83;
                        break;
                    }
                    case 115: {
                        cx1 = x - cx2;
                        cy1 = x - cy2;
                        tt.requireNextToken(-2, "dx2 coordinate missing for 's'");
                        cx2 = tt.nval;
                        tt.requireNextToken(-2, "dy2 coordinate missing for 's'");
                        cy2 = tt.nval;
                        tt.requireNextToken(-2, "dx coordinate missing for 's'");
                        tt.requireNextToken(-2, "dy coordinate missing for 's'");
                        CubicCurveTo smoothCurveTo = new CubicCurveTo(cx1, cy1, cx2, cy2, x += tt.nval, y += tt.nval);
                        smoothCurveTo.setAbsolute(false);
                        builder.add((PathElement)smoothCurveTo);
                        next = 115;
                        cx1 += px;
                        cy1 += px;
                        cx2 += px;
                        cy2 += px;
                        x += px;
                        y += py;
                        break;
                    }
                    case 81: {
                        tt.requireNextToken(-2, "x1 coordinate missing for 'Q'");
                        cx1 = tt.nval;
                        tt.requireNextToken(-2, "y1 coordinate missing for 'Q'");
                        cy1 = tt.nval;
                        tt.requireNextToken(-2, "x coordinate missing for 'Q'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'Q'");
                        y = tt.nval;
                        builder.add((PathElement)new QuadCurveTo(cx1, cy1, x, y));
                        next = 81;
                        cx2 = x;
                        cy2 = y;
                        break;
                    }
                    case 113: {
                        tt.requireNextToken(-2, "dx1 coordinate missing for 'q'");
                        cx1 = x + tt.nval;
                        tt.requireNextToken(-2, "dy1 coordinate missing for 'q'");
                        cy1 = y + tt.nval;
                        tt.requireNextToken(-2, "dx coordinate missing for 'q'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "dy coordinate missing for 'q'");
                        y = tt.nval;
                        QuadCurveTo quadCurveTo = new QuadCurveTo(cx1, cy1, x, y);
                        quadCurveTo.setAbsolute(false);
                        builder.add((PathElement)quadCurveTo);
                        next = 113;
                        cx2 = x;
                        cy2 = y;
                        break;
                    }
                    case 84: {
                        cx1 = x - cx1 + x;
                        cy1 = x - cy1 + y;
                        tt.requireNextToken(-2, "x coordinate missing for 'T'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'T'");
                        y = tt.nval;
                        builder.add((PathElement)new QuadCurveTo(cx1, cy1, x, y));
                        next = 84;
                        cx2 = x;
                        cy2 = y;
                        break;
                    }
                    case 116: {
                        cx1 = x - cx1;
                        cy1 = x - cy1;
                        tt.requireNextToken(-2, "dx coordinate missing for 't'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "dy coordinate missing for 't'");
                        y = tt.nval;
                        QuadCurveTo smoothQuadCurveTo = new QuadCurveTo(cx1, cy1, x, y);
                        smoothQuadCurveTo.setAbsolute(false);
                        builder.add((PathElement)smoothQuadCurveTo);
                        next = 115;
                        cx1 += px;
                        cy1 += px;
                        cx2 = x += px;
                        cy2 = y += px;
                        break;
                    }
                    case 65: {
                        tt.requireNextToken(-2, "rx coordinate missing for 'A'");
                        double rx = tt.nval;
                        tt.requireNextToken(-2, "ry coordinate missing for 'A'");
                        double ry = tt.nval;
                        tt.requireNextToken(-2, "x-axis-rotation missing for 'A'");
                        double xAxisRotation = tt.nval;
                        tt.requireNextToken(-2, "large-arc-flag missing for 'A'");
                        boolean largeArcFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "sweep-flag missing for 'A'");
                        boolean sweepFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "x coordinate missing for 'A'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'A'");
                        y = tt.nval;
                        builder.add((PathElement)new ArcTo(rx, ry, xAxisRotation, x, y, largeArcFlag, sweepFlag));
                        next = 65;
                        cx2 = cx1 = x;
                        cy2 = cy1 = y;
                        break;
                    }
                    case 97: {
                        tt.requireNextToken(-2, "rx coordinate missing for 'A'");
                        double rx = tt.nval;
                        tt.requireNextToken(-2, "ry coordinate missing for 'A'");
                        double ry = tt.nval;
                        tt.requireNextToken(-2, "x-axis-rotation missing for 'A'");
                        double xAxisRotation = tt.nval;
                        tt.requireNextToken(-2, "large-arc-flag missing for 'A'");
                        boolean largeArcFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "sweep-flag missing for 'A'");
                        boolean sweepFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "x coordinate missing for 'A'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'A'");
                        y = tt.nval;
                        ArcTo arcTo = new ArcTo(rx, ry, xAxisRotation, x, y, largeArcFlag, sweepFlag);
                        arcTo.setAbsolute(false);
                        builder.add((PathElement)arcTo);
                        cx1 = x += px;
                        cx2 = x;
                        cy1 = y += py;
                        cy2 = y;
                        next = 97;
                        break;
                    }
                    default: {
                        throw tt.createException("Illegal command: " + (char)command);
                    }
                }
                first = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder;
    }

    public static void reshapePathElements(String pathstr, @NonNull Bounds b, List<PathElement> elems) {
        FXPathElementsBuilder builder = new FXPathElementsBuilder(elems);
        SvgPaths.svgStringReshapeToBuilder(pathstr, b, builder);
        builder.pathDone();
    }

    public static <T extends PathBuilder<?>> @NonNull T buildFromPathElements(@NonNull T builder, @NonNull Iterable<PathElement> pathElements) {
        double x = 0.0;
        double y = 0.0;
        double ix = 0.0;
        double iy = 0.0;
        for (PathElement pe : pathElements) {
            if (pe instanceof MoveTo) {
                MoveTo e = (MoveTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                } else {
                    x += e.getX();
                    y += e.getY();
                }
                ix = x;
                iy = y;
                builder.moveTo(x, y);
                continue;
            }
            if (pe instanceof LineTo) {
                LineTo e = (LineTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                } else {
                    x += e.getX();
                    y += e.getY();
                }
                builder.lineTo(x, y);
                continue;
            }
            if (pe instanceof CubicCurveTo) {
                CubicCurveTo e = (CubicCurveTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                    builder.curveTo(e.getControlX1(), e.getControlY1(), e.getControlX2(), e.getControlY2(), x, y);
                    continue;
                }
                builder.curveTo(e.getControlX1() + x, e.getControlY1() + y, e.getControlX2() + x, e.getControlY2() + y, x += e.getX(), y += e.getY());
                continue;
            }
            if (pe instanceof QuadCurveTo) {
                QuadCurveTo e = (QuadCurveTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                    builder.quadTo(e.getControlX(), e.getControlY(), x, y);
                    continue;
                }
                builder.quadTo(e.getControlX() + x, e.getControlY() + y, x += e.getX(), y += e.getY());
                continue;
            }
            if (pe instanceof ArcTo) {
                ArcTo e = (ArcTo)pe;
                if (e.isAbsolute()) {
                    x = e.getX();
                    y = e.getY();
                    builder.arcTo(e.getRadiusX(), e.getRadiusY(), e.getXAxisRotation(), x, y, e.isLargeArcFlag(), e.isSweepFlag());
                    continue;
                }
                builder.arcTo(e.getRadiusX(), e.getRadiusY(), e.getXAxisRotation(), x += e.getX(), y += e.getY(), e.isLargeArcFlag(), e.isSweepFlag());
                continue;
            }
            if (pe instanceof HLineTo) {
                HLineTo e = (HLineTo)pe;
                x = e.isAbsolute() ? e.getX() : (x += e.getX());
                builder.lineTo(x, y);
                continue;
            }
            if (pe instanceof VLineTo) {
                VLineTo e = (VLineTo)pe;
                y = e.isAbsolute() ? e.getY() : (y += e.getY());
                builder.lineTo(x, y);
                continue;
            }
            if (!(pe instanceof ClosePath)) continue;
            builder.closePath();
            x = ix;
            y = iy;
        }
        builder.pathDone();
        return builder;
    }

    public static @NonNull List<PathElement> transformPathElements(@NonNull List<PathElement> elements, FillRule fillRule, Transform fxT) {
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        FXShapes.awtShapeFromFXPathElements(elements, fillRule);
        return result;
    }
}

