/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;

public class FXTransformPathBuilder<T>
extends AbstractPathBuilder<T> {
    private final @NonNull PathBuilder<T> target;
    private @NonNull Transform transform;

    public FXTransformPathBuilder(@NonNull PathBuilder<T> target) {
        this(target, FXTransforms.IDENTITY);
    }

    public FXTransformPathBuilder(@NonNull PathBuilder<T> target, @NonNull Transform transform) {
        this.target = target;
        this.transform = transform;
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        this.target.closePath();
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x3, double y3) {
        Point2D p1 = this.transform.transform(x1, y1);
        Point2D p2 = this.transform.transform(x2, y2);
        Point2D p3 = this.transform.transform(x3, y3);
        this.target.curveTo(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    @Override
    protected void doPathDone() {
        this.target.pathDone();
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        Point2D p = this.transform.transform(x, y);
        this.target.lineTo(p.getX(), p.getY());
    }

    @Override
    protected void doMoveTo(double x, double y) {
        Point2D p = this.transform.transform(x, y);
        this.target.moveTo(p.getX(), p.getY());
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x2, double y2) {
        Point2D p1 = this.transform.transform(x1, y1);
        Point2D p2 = this.transform.transform(x2, y2);
        this.target.quadTo(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public @NonNull Transform getTransform() {
        return this.transform;
    }

    public void setTransform(@NonNull Transform transform) {
        this.transform = transform;
    }

    @Override
    public @Nullable T build() {
        return this.target.build();
    }
}

