/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.FXPreciseRotate;

public class FXTransforms {
    public static final Transform IDENTITY = new Translate();

    private FXTransforms() {
    }

    public static @NonNull Transform concat(Transform ... transforms) {
        Transform a = null;
        for (Transform b : transforms) {
            a = a == null || a.isIdentity() ? b : (b == null || b.isIdentity() ? a : a.createConcatenation(b));
        }
        return a == null ? IDENTITY : a;
    }

    public static @NonNull Transform createReshapeTransform(@NonNull Bounds src, @NonNull Bounds dest) {
        return FXTransforms.createReshapeTransform(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight(), dest.getMinX(), dest.getMinY(), dest.getWidth(), dest.getHeight());
    }

    public static @NonNull Transform createReshapeTransform(@NonNull Bounds src, double destX, double destY, double destW, double destH) {
        return FXTransforms.createReshapeTransform(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight(), destX, destY, destW, destH);
    }

    public static @NonNull Transform createReshapeTransform(@NonNull Rectangle2D src, double destX, double destY, double destW, double destH) {
        return FXTransforms.createReshapeTransform(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight(), destX, destY, destW, destH);
    }

    static @NonNull Transform createReshapeTransform(double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        double scaleX = dw / sw;
        double scaleY = dh / sh;
        Translate t = new Translate(dx - sx, dy - sy);
        if (!(Double.isNaN(scaleX) || Double.isNaN(scaleY) || Double.isInfinite(scaleX) || Double.isInfinite(scaleY) || scaleX == 1.0 && scaleY == 1.0)) {
            t = FXTransforms.concat(new Transform[]{t, new Scale(scaleX, scaleY, sx, sy)});
        }
        return t;
    }

    public static @NonNull List<Transform> decompose(@NonNull Transform transform) {
        ArrayList<Transform> list = new ArrayList<Transform>();
        if (!transform.isIdentity()) {
            if (transform instanceof Translate) {
                list.add(transform);
            } else if (transform instanceof Scale) {
                list.add(transform);
            } else if (transform instanceof Rotate) {
                list.add(transform);
            } else {
                double a = transform.getMxx();
                double b = transform.getMxy();
                double c = transform.getMyx();
                double d = transform.getMyy();
                double tx = transform.getTx();
                double ty = transform.getTy();
                double sx = Math.sqrt(a * a + c * c);
                double sy = Math.sqrt(b * b + d * d);
                double rot1 = Math.atan(c / d);
                double rot2 = Math.atan(-b / a);
                if (Double.isNaN(rot1) || Double.isNaN(rot2) || Math.abs(rot1 - rot2) > 1.0E-6) {
                    list.add(transform);
                    return list;
                }
                if (tx != 0.0 || ty != 0.0) {
                    list.add((Transform)new Translate(tx, ty));
                }
                if (sx != 1.0 || sy != 1.0) {
                    list.add((Transform)new Scale(tx, ty));
                }
                if (rot1 != 0.0 && rot2 != 0.0) {
                    list.add((Transform)new FXPreciseRotate(Math.toDegrees(rot1)));
                }
            }
        }
        return list;
    }

    public static Point2D deltaTransform(@Nullable Transform t, double x, double y) {
        if (t == null) {
            return new Point2D(x, y);
        }
        Point3D tp = t.deltaTransform(x, y, 0.0);
        return new Point2D(tp.getX(), tp.getY());
    }

    public static Point2D deltaTransform(@Nullable Transform t, @NonNull Point2D p) {
        if (t == null) {
            return p;
        }
        Point3D tp = t.deltaTransform(p.getX(), p.getY(), 0.0);
        return new Point2D(tp.getX(), tp.getY());
    }

    public static Point2D inverseDeltaTransform(@Nullable Transform t, double x, double y) {
        if (t == null) {
            return new Point2D(x, y);
        }
        try {
            Point3D tp = t.inverseDeltaTransform(x, y, 0.0);
            return new Point2D(tp.getX(), tp.getY());
        }
        catch (NonInvertibleTransformException e) {
            return new Point2D(x, y);
        }
    }

    public static Point2D inverseDeltaTransform(@Nullable Transform t, @NonNull Point2D p) {
        if (t == null) {
            return p;
        }
        try {
            Point3D tp = t.inverseDeltaTransform(p.getX(), p.getY(), 0.0);
            return new Point2D(tp.getX(), tp.getY());
        }
        catch (NonInvertibleTransformException e) {
            return p;
        }
    }

    public static @Nullable AffineTransform toAwt(@Nullable Transform t) {
        if (t == null) {
            return null;
        }
        return new AffineTransform(t.getMxx(), t.getMyx(), t.getMxy(), t.getMyy(), t.getTx(), t.getTy());
    }

    public static @NonNull Bounds transform(@Nullable Transform tx, @NonNull Bounds b) {
        return tx == null ? b : tx.transform(b);
    }

    public static @NonNull Point2D transform(@Nullable Transform tx, @NonNull Point2D b) {
        if (tx == null || tx.isIdentity()) {
            return b;
        }
        if (tx.isType2D()) {
            return tx.transform(b);
        }
        Point3D p = tx.transform(b.getX(), b.getY(), 0.0);
        return new Point2D(p.getX(), p.getY());
    }

    public static @NonNull Point2D transform(@Nullable Transform tx, double x, double y) {
        if (tx == null || tx.isIdentity()) {
            return new Point2D(x, y);
        }
        if (tx.isType2D()) {
            return tx.transform(x, y);
        }
        Point3D p = tx.transform(x, y, 0.0);
        return new Point2D(p.getX(), p.getY());
    }

    public static @NonNull Transform rotate(@NonNull Point2D tangent, @NonNull Point2D pivot) {
        double theta = Angles.atan2(tangent.getY(), tangent.getX());
        return FXTransforms.rotateRadians(theta, pivot.getX(), pivot.getY());
    }

    private static Transform rotateRadians(double theta, double pivotX, double pivotY) {
        return new FXPreciseRotate(Math.toDegrees(theta), pivotX, pivotY);
    }

    public static @NonNull Transform rotate(double tangentX, double tangentY, double pivotX, double pivotY) {
        double theta = Angles.atan2(tangentY, tangentX);
        return FXTransforms.rotateRadians(theta, pivotX, pivotY);
    }

    public static @NonNull Transform createProjectPointOnLineTransform(double x1, double y1, double x2, double y2) {
        double vx = x2 - x1;
        double vy = y2 - y1;
        double vxx = vx * vx;
        double vyy = vy * vy;
        double vTv = vxx + vyy;
        double xx = vxx / vTv;
        double xy = vx * vy / vTv;
        double yy = vyy / vTv;
        double yx = xy;
        double tx = xx * x1 + xy * y1;
        double ty = yx * x1 + yy * y1;
        return new Affine(xx, xy, tx, yx, yy, ty);
    }

    public static @NonNull Point2D projectPointOnLine(double ax, double ay, double x1, double y1, double x2, double y2) {
        double vx = x2 - x1;
        double vy = y2 - y1;
        double vxx = vx * vx;
        double vyy = vy * vy;
        double vTv = vxx + vyy;
        double xx = vxx / vTv;
        double xy = vx * vy / vTv;
        double yy = vyy / vTv;
        double yx = xy;
        double tx = xx * x1 + xy * y1;
        double ty = yx * x1 + yy * y1;
        double bx = xx * ax + xy * ay + tx;
        double by = yx * ax + yy * ay + ty;
        return new Point2D(bx, by);
    }

    public static boolean isIdentityOrNull(@Nullable Transform t) {
        return t == null || t.isIdentity();
    }

    public static void transform2DPoints(Transform t, double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (t.isType2D()) {
            t.transform2DPoints(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            double[] points3d = new double[numPts * 3];
            int i = 0;
            int i3 = 0;
            while (i < numPts) {
                points3d[i3] = srcPts[i * 2 + srcOff];
                points3d[i3 + 1] = srcPts[i * 2 + 1 + srcOff];
                ++i;
                i3 += 3;
            }
            t.transform3DPoints(points3d, 0, points3d, 0, 4);
            i = 0;
            i3 = 0;
            while (i < numPts) {
                dstPts[i * 2 + dstOff] = points3d[i3];
                dstPts[i * 2 + 1 + dstOff] = points3d[i3 + 1];
                ++i;
                i3 += 3;
            }
        }
    }

    public static Bounds transformedBoundingBox(@Nullable Transform t, Bounds b) {
        if (t == null) {
            return b;
        }
        double[] points = new double[]{b.getMinX(), b.getMinY(), b.getMaxX(), b.getMinY(), b.getMaxX(), b.getMaxY(), b.getMinX(), b.getMaxY()};
        t.transform2DPoints(points, 0, points, 0, 4);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < points.length; i += 2) {
            minX = Math.min(minX, points[i]);
            maxX = Math.max(maxX, points[i]);
            minY = Math.min(minY, points[i + 1]);
            maxY = Math.max(maxY, points[i + 1]);
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }
}

