/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.PathIterator;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.AbstractPathBuilder;

public class PathIteratorPathBuilder
extends AbstractPathBuilder<PathIterator> {
    private int numCommands;
    private int numCoords;
    private byte @NonNull [] commands = new byte[10];
    private double @NonNull [] coords = new double[60];
    private final int windingRule;
    private boolean needsMoveTo = true;

    public PathIteratorPathBuilder() {
        this(0);
    }

    public PathIteratorPathBuilder(int windingRule) {
        this.windingRule = windingRule;
    }

    public boolean isEmpty() {
        return this.numCoords == 0;
    }

    private void needRoom() {
        Object[] temp;
        int newSize;
        if (this.numCommands >= this.commands.length) {
            newSize = this.commands.length + 10;
            if (newSize < this.commands.length) {
                throw new ArrayIndexOutOfBoundsException("Can't expand commands array.");
            }
            temp = this.commands;
            this.commands = new byte[newSize];
            System.arraycopy(temp, 0, this.commands, 0, temp.length);
        }
        if (this.numCoords + 6 >= this.coords.length) {
            newSize = this.coords.length + 60;
            if (newSize < this.commands.length) {
                throw new ArrayIndexOutOfBoundsException("Can't expand coords array.");
            }
            temp = this.coords;
            this.coords = new double[newSize];
            System.arraycopy(temp, 0, this.coords, 0, temp.length);
        }
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        if (this.needsMoveTo) {
            return;
        }
        this.needRoom();
        this.commands[this.numCommands++] = 4;
        this.needsMoveTo = true;
    }

    @Override
    protected void doPathDone() {
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        if (this.needsMoveTo) {
            this.doMoveTo(lastX, lastY);
        }
        this.needRoom();
        this.commands[this.numCommands++] = 3;
        this.coords[this.numCoords++] = x1;
        this.coords[this.numCoords++] = y1;
        this.coords[this.numCoords++] = x2;
        this.coords[this.numCoords++] = y2;
        this.coords[this.numCoords++] = x;
        this.coords[this.numCoords++] = y;
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        if (this.needsMoveTo) {
            this.doMoveTo(lastX, lastY);
        }
        this.needRoom();
        this.commands[this.numCommands++] = 1;
        this.coords[this.numCoords++] = x;
        this.coords[this.numCoords++] = y;
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.needRoom();
        this.commands[this.numCommands++] = 0;
        this.coords[this.numCoords++] = x;
        this.coords[this.numCoords++] = y;
        this.needsMoveTo = false;
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        if (this.needsMoveTo) {
            this.doMoveTo(lastX, lastY);
        }
        this.needRoom();
        this.commands[this.numCommands++] = 2;
        this.coords[this.numCoords++] = x1;
        this.coords[this.numCoords++] = y1;
        this.coords[this.numCoords++] = x;
        this.coords[this.numCoords++] = y;
    }

    @Override
    public @NonNull PathIterator build() {
        return new MyPathIterator(this.windingRule, this.numCommands, this.numCoords, this.commands, this.coords);
    }

    private static class MyPathIterator
    implements PathIterator {
        private int commandIndex = 0;
        private int coordsIndex = 0;
        private final int numCommands;
        private final int numCoords;
        private final byte[] commands;
        private final double[] coords;
        private static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};
        private final int windingRule;

        public MyPathIterator(int windingRule, int numCommands, int numCoords, byte[] commands, double[] coords) {
            this.windingRule = windingRule;
            this.numCommands = numCommands;
            this.numCoords = numCoords;
            this.commands = commands;
            this.coords = coords;
        }

        @Override
        public int getWindingRule() {
            return this.windingRule;
        }

        @Override
        public boolean isDone() {
            return this.commandIndex >= this.numCommands;
        }

        @Override
        public void next() {
            if (!this.isDone()) {
                byte type = this.commands[this.commandIndex++];
                this.coordsIndex += curvecoords[type];
            }
        }

        @Override
        public int currentSegment(float[] coords) {
            byte type = this.commands[this.commandIndex];
            int n = curvecoords[type];
            for (int i = 0; i < n; ++i) {
                coords[i] = (float)this.coords[i + this.coordsIndex];
            }
            return type;
        }

        @Override
        public int currentSegment(double[] coords) {
            byte type = this.commands[this.commandIndex];
            int n = curvecoords[type];
            for (int i = 0; i < n; ++i) {
                coords[i] = this.coords[i + this.coordsIndex];
            }
            return type;
        }
    }
}

