/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points2D;

public class Points {
    private Points() {
    }

    public static double squaredDistance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static float distanceF(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return (float)Math.sqrt((float)(dx * dx + dy * dy));
    }

    public static boolean almostEqual(Point2D v1, Point2D v2) {
        return Points.almostEqual(v1, v2, 1.0E-8);
    }

    public static boolean almostEqual(Point2D v1, Point2D v2, double epsilon) {
        return v1.distanceSq(v2) < epsilon * epsilon;
    }

    public static boolean almostEqual(double x0, double y0, double x1, double y1) {
        return Points.almostEqual(x0, y0, x1, y1, 1.0E-8);
    }

    public static boolean almostEqual(double x0, double y0, double x1, double y1, double epsilon) {
        return Points.squaredDistance(x0, y0, x1, y1) < epsilon * epsilon;
    }

    public static boolean almostZero(Point2D.Double v) {
        return Points.almostZero(v, 1.0E-8);
    }

    public static boolean almostZero(Point2D.Double v, double epsilon) {
        return Points2D.magnitudeSq(v) < epsilon * epsilon;
    }

    public static boolean almostEqual(double a, double b) {
        return Points.almostEqual(a, b, 1.0E-8);
    }

    public static boolean almostEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static boolean almostZero(double a) {
        return Points.almostZero(a, 1.0E-8);
    }

    public static boolean almostZero(double a, double epsilon) {
        return Math.abs(a) < epsilon;
    }

    public static double distanceFromShape(@NonNull Shape awtShape, double x, double y) {
        return Math.sqrt(Points.squaredDistanceFromShape(awtShape, x, y));
    }

    public static double squaredDistanceFromShape(@NonNull Shape awtShape, double x, double y) {
        if (awtShape.contains(x, y)) {
            return 0.0;
        }
        double[] coords = new double[6];
        double firstX = Double.NaN;
        double firstY = Double.NaN;
        double lastX = Double.NaN;
        double lastY = Double.NaN;
        double minSquaredDistance = Double.POSITIVE_INFINITY;
        PathIterator it = awtShape.getPathIterator(null, 1.0);
        while (!it.isDone()) {
            double squaredDistance;
            switch (it.currentSegment(coords)) {
                case 0: {
                    firstX = coords[0];
                    firstY = coords[1];
                    lastX = coords[0];
                    lastY = coords[1];
                    squaredDistance = Double.POSITIVE_INFINITY;
                    break;
                }
                case 1: {
                    squaredDistance = Lines.squaredDistanceFromLine(lastX, lastY, coords[0], coords[1], x, y);
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 4: {
                    squaredDistance = Lines.squaredDistanceFromLine(lastX, lastY, firstX, firstY, x, y);
                    firstX = lastX;
                    firstY = lastY;
                    break;
                }
                default: {
                    squaredDistance = Double.POSITIVE_INFINITY;
                }
            }
            if (squaredDistance < minSquaredDistance) {
                minSquaredDistance = squaredDistance;
            }
            it.next();
        }
        return minSquaredDistance;
    }
}

