/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.function.ToDoubleFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Integrals;

public class Polynomial
implements ToDoubleFunction<Double> {
    private static final double ACCURACY = 6.0;
    private static final double LN10 = Math.log(10.0);
    private static final double LN2 = Math.log(2.0);
    private static final double EPSILON = 1.1641532182693481E-10;
    private final double[] coefs;

    public Polynomial(double ... coefs) {
        this(true, coefs);
    }

    public Polynomial(boolean highestToLowestDegree, double ... coefs) {
        if (highestToLowestDegree) {
            this.coefs = new double[coefs.length];
            for (int i = 0; i < coefs.length; ++i) {
                this.coefs[i] = coefs[coefs.length - i - 1];
            }
        } else {
            this.coefs = coefs;
        }
    }

    public @NonNull Polynomial add(@NonNull Polynomial that) {
        int d1 = this.getDegree();
        int d2 = that.getDegree();
        int dmax = Math.max(d1, d2);
        double[] result = new double[dmax];
        for (int i = 0; i <= dmax; ++i) {
            double v1 = i <= d1 ? this.coefs[i] : 0.0;
            double v2 = i <= d2 ? that.coefs[i] : 0.0;
            result[i] = v1 + v2;
        }
        return new Polynomial(false, result);
    }

    public @NonNull Polynomial subtract(@NonNull Polynomial that) {
        int d1 = this.getDegree();
        int d2 = that.getDegree();
        int dmax = Math.max(d1, d2);
        double[] result = new double[dmax];
        for (int i = 0; i <= dmax; ++i) {
            double v1 = i <= d1 ? this.coefs[i] : 0.0;
            double v2 = i <= d2 ? that.coefs[i] : 0.0;
            result[i] = v1 - v2;
        }
        return new Polynomial(false, result);
    }

    @Override
    public double applyAsDouble(Double x) {
        return this.eval(x);
    }

    public static @Nullable Double bisection(@NonNull ToDoubleFunction<Double> func, double min, double max) {
        double minValue = func.applyAsDouble(min);
        double maxValue = func.applyAsDouble(max);
        Double result = null;
        if (Math.abs(minValue) <= 1.1641532182693481E-10) {
            result = min;
        } else if (Math.abs(maxValue) <= 1.1641532182693481E-10) {
            result = max;
        } else if (minValue * maxValue <= 0.0) {
            double value;
            double tmp1 = Math.log(max - min);
            double tmp2 = LN10 * 6.0;
            double iters = Math.ceil((tmp1 + tmp2) / LN2);
            for (double i = 0.0; i < iters && !(Math.abs(value = func.applyAsDouble(result = Double.valueOf(0.5 * (min + max)))) <= 1.1641532182693481E-10); i += 1.0) {
                if (value * minValue < 0.0) {
                    max = result;
                    continue;
                }
                min = result;
            }
        }
        return result;
    }

    public @NonNull Polynomial divideScalar(double scalar) {
        double[] result = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            int n = i;
            double d = this.coefs[n] / scalar;
            this.coefs[n] = d;
            result[i] = d;
        }
        return new Polynomial(false, result);
    }

    public double eval(double x) {
        double result = 0.0;
        for (int i = this.coefs.length - 1; i >= 0; --i) {
            result = Math.fma(result, x, this.coefs[i]);
        }
        return result;
    }

    private double @NonNull [] getCubicRoots() {
        double[] results = new double[4];
        int numResults = 0;
        double c3 = this.coefs[3];
        double c2 = this.coefs[2] / c3;
        double c1 = this.coefs[1] / c3;
        double c0 = this.coefs[0] / c3;
        if (c3 == 0.0) {
            throw new IllegalArgumentException("Not a cubic root! simplifiedDegree=" + this.simplifiedDegree());
        }
        double a = (3.0 * c1 - c2 * c2) / 3.0;
        double b = (2.0 * c2 * c2 * c2 - 9.0 * c1 * c2 + 27.0 * c0) / 27.0;
        double offset = c2 / 3.0;
        double halfB = b / 2.0;
        double discrim = b * b / 4.0 + a * a * a / 27.0;
        if (Math.abs(discrim) <= 1.1641532182693481E-10) {
            discrim = 0.0;
        }
        if (discrim > 0.0) {
            double e = Math.sqrt(discrim);
            double tmp = -halfB + e;
            double root = tmp >= 0.0 ? Math.cbrt(tmp) : -Math.cbrt(-tmp);
            tmp = -halfB - e;
            root = tmp >= 0.0 ? (root += Math.cbrt(tmp)) : (root -= Math.cbrt(-tmp));
            results[numResults++] = root - offset;
        } else if (discrim < 0.0) {
            double distance = Math.sqrt(-a / 3.0);
            double angle = Angles.atan2(Math.sqrt(-discrim), -halfB) / 3.0;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double sqrt3 = Math.sqrt(3.0);
            results[numResults++] = 2.0 * distance * cos - offset;
            results[numResults++] = -distance * (cos + sqrt3 * sin) - offset;
            results[numResults++] = -distance * (cos - sqrt3 * sin) - offset;
        } else {
            double tmp = halfB >= 0.0 ? -Math.cbrt(halfB) : Math.cbrt(-halfB);
            results[numResults++] = 2.0 * tmp - offset;
            results[numResults++] = -tmp - offset;
        }
        return Polynomial.trim(numResults, results);
    }

    public int getDegree() {
        return this.coefs.length - 1;
    }

    public @NonNull Polynomial getDerivative() {
        double[] derivative = new double[this.coefs.length - 1];
        for (int i = 1; i < this.coefs.length; ++i) {
            derivative[i - 1] = (double)i * this.coefs[i];
        }
        return new Polynomial(false, derivative);
    }

    private double @NonNull [] getLinearRoot() {
        double[] result = new double[]{};
        double a = this.coefs[1];
        if (a != 0.0) {
            result = new double[]{-this.coefs[0] / a};
        }
        return result;
    }

    private double @NonNull [] getQuadraticRoots() {
        double a = this.coefs[2];
        double b = this.coefs[1] / a;
        double c = this.coefs[0] / a;
        return Polynomial.getQuadraticRoots(a, b, c);
    }

    public static double @NonNull [] getQuadraticRoots(double a, double b, double c) {
        double d = b * b - 4.0 * c;
        if (d > 0.0) {
            double e = Math.sqrt(d);
            return new double[]{0.5 * (-b + e), 0.5 * (-b - e)};
        }
        if (d == 0.0) {
            return new double[]{0.5 * -b};
        }
        return new double[0];
    }

    private double @NonNull [] getQuarticRoots() {
        double t2;
        double[] results = new double[4];
        int numResults = 0;
        double c4 = this.coefs[4];
        double c3 = this.coefs[3] / c4;
        double c2 = this.coefs[2] / c4;
        double c1 = this.coefs[1] / c4;
        double c0 = this.coefs[0] / c4;
        double[] dArray = new double[]{1.0, -c2, c3 * c1 - 4.0 * c0, -c3 * c3 * c0 + 4.0 * c2 * c0 - c1 * c1};
        double[] resolveRoots = new Polynomial(dArray).getCubicRoots();
        double y = resolveRoots[0];
        double discrim = c3 * c3 / 4.0 - c2 + y;
        if (Math.abs(discrim) <= 1.1641532182693481E-10) {
            discrim = 0.0;
        }
        if (discrim > 0.0) {
            double f;
            double e = Math.sqrt(discrim);
            double t1 = 0.75 * c3 * c3 - e * e - 2.0 * c2;
            double t22 = (4.0 * c3 * c2 - 8.0 * c1 - c3 * c3 * c3) / (4.0 * e);
            double plus = t1 + t22;
            double minus = t1 - t22;
            if (Math.abs(plus) <= 1.1641532182693481E-10) {
                plus = 0.0;
            }
            if (Math.abs(minus) <= 1.1641532182693481E-10) {
                minus = 0.0;
            }
            if (plus >= 0.0) {
                f = Math.sqrt(plus);
                results[numResults++] = c3 / -4.0 + (e + f) / 2.0;
                results[numResults++] = c3 / -4.0 + (e - f) / 2.0;
            }
            if (minus >= 0.0) {
                f = Math.sqrt(minus);
                results[numResults++] = c3 / -4.0 + (f - e) / 2.0;
                results[numResults++] = c3 / -4.0 - (f + e) / 2.0;
            }
        } else if (!(discrim < 0.0) && (t2 = y * y - 4.0 * c0) >= -1.1641532182693481E-10) {
            double d;
            double t1;
            if (t2 < 0.0) {
                t2 = 0.0;
            }
            if ((t1 = 3.0 * c3 * c3 / 4.0 - 2.0 * c2) + (t2 = 2.0 * Math.sqrt(t2)) >= 1.1641532182693481E-10) {
                d = Math.sqrt(t1 + t2);
                results[numResults++] = -c3 / 4.0 + d / 2.0;
                results[numResults++] = -c3 / 4.0 - d / 2.0;
            }
            if (t1 - t2 >= 1.1641532182693481E-10) {
                d = Math.sqrt(t1 - t2);
                results[numResults++] = -c3 / 4.0 + d / 2.0;
                results[numResults++] = -c3 / 4.0 - d / 2.0;
            }
        }
        return Polynomial.trim(numResults, results);
    }

    public double[] getRoots() {
        int simplifiedDegree = this.simplifiedDegree();
        double[] result = switch (simplifiedDegree) {
            case 0 -> new double[]{};
            case 1 -> this.getLinearRoot();
            case 2 -> this.getQuadraticRoots();
            case 3 -> this.getCubicRoots();
            case 4 -> this.getQuarticRoots();
            default -> throw new UnsupportedOperationException("Degree is too high. simplifiedDegree=" + simplifiedDegree);
        };
        return result;
    }

    public @NonNull DoubleArrayList getRootsInInterval(double min, double max) {
        DoubleArrayList roots = new DoubleArrayList(this.getDegree());
        int numRoots = 0;
        switch (this.simplifiedDegree()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                double[] allroots;
                for (double root : allroots = this.getRoots()) {
                    if (!(min <= root) || !(root <= max)) continue;
                    roots.add(Double.valueOf(root));
                }
                break;
            }
            default: {
                Polynomial deriv = this.getDerivative();
                DoubleArrayList droots = deriv.getRootsInInterval(min, max);
                roots = Polynomial.getRootsInInterval(this, droots, min, max);
                numRoots = roots.size();
                break;
            }
        }
        roots.sort();
        return roots;
    }

    public static @NonNull DoubleArrayList getRootsInInterval(@NonNull ToDoubleFunction<Double> func, @NonNull DoubleArrayList droots, double min, double max) {
        DoubleArrayList roots = new DoubleArrayList(droots.size());
        boolean numRoots = false;
        if (!droots.isEmpty()) {
            Double root = Polynomial.bisection(func, min, droots.getFirst());
            if (root != null) {
                roots.add(root);
            }
            for (int i = 0; i <= droots.size() - 2; ++i) {
                root = Polynomial.bisection(func, droots.get(i), droots.get(i + 1));
                if (root == null) continue;
                roots.add(root);
            }
            root = Polynomial.bisection(func, droots.getLast(), max);
            if (root != null) {
                roots.add(root);
            }
        } else {
            Double root = Polynomial.bisection(func, min, max);
            if (root != null) {
                roots.add(root);
            }
        }
        return roots;
    }

    public @NonNull Polynomial multiply(@NonNull Polynomial that) {
        Polynomial result = new Polynomial(new double[this.getDegree() + that.getDegree()]);
        for (int i = 0; i <= this.getDegree(); ++i) {
            for (int j = 0; j <= that.getDegree(); ++j) {
                int n = i + j;
                result.coefs[n] = result.coefs[n] + this.coefs[i] * that.coefs[j];
            }
        }
        return result;
    }

    private int simplifiedDegree() {
        int i;
        for (i = this.getDegree(); i > 0 && Math.abs(this.coefs[i]) <= 1.1641532182693481E-10; --i) {
        }
        return i;
    }

    public @NonNull Polynomial simplify() {
        int popAt = this.simplifiedDegree();
        if (popAt == this.getDegree()) {
            return this;
        }
        double[] newCoefs = new double[popAt];
        System.arraycopy(this.coefs, 0, newCoefs, 0, popAt);
        return new Polynomial(false, newCoefs);
    }

    public @NonNull String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = this.coefs.length - 1; i >= 0; --i) {
            if (this.coefs[i] >= 0.0) {
                b.append('+');
            }
            b.append(this.coefs[i]);
            if (i > 0) {
                b.append("*x");
                if (i > 1) {
                    b.append('^').append(i);
                }
            }
            if (i <= 0) continue;
            b.append(' ');
        }
        return b.append(']').toString();
    }

    public static double @NonNull [] trim(int length, double @NonNull [] a) {
        if (length == a.length) {
            return a;
        }
        double[] finalResults = new double[length];
        System.arraycopy(a, 0, finalResults, 0, length);
        return finalResults;
    }

    public double arcLength(double min, double max) {
        Polynomial dfdx = this.getDerivative();
        return Integrals.simpson(x -> {
            double y = dfdx.eval((double)x);
            return Math.sqrt(1.0 + y * y);
        }, min, max, 1.1641532182693481E-10);
    }
}

