/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.QuadCurve2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.primitive.DoubleArrayList;

public class QuadCurveCharacteristics {
    private QuadCurveCharacteristics() {
    }

    public static @NonNull DoubleArrayList extremePoints(QuadCurve2D.Double c) {
        return QuadCurveCharacteristics.extremePoints(c.x1, c.y1, c.ctrlx, c.ctrly, c.x2, c.y2);
    }

    public static @NonNull DoubleArrayList extremePoints(double x0, double y0, double x1, double y1, double x2, double y2) {
        double qx = x1 - x0;
        double qy = y1 - y0;
        double mx = x0 - 2.0 * x1 + x2;
        double my = y0 - 2.0 * y1 + y2;
        double t0 = -qx / mx;
        double t1 = -qy / my;
        DoubleArrayList list = new DoubleArrayList();
        if (0.0 <= t0 && t0 <= 1.0) {
            list.add(Double.valueOf(t0));
        }
        if (0.0 <= t1 && t1 <= 1.0) {
            list.add(Double.valueOf(t1));
        }
        return list;
    }
}

