/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Point2D;
import java.util.function.ToDoubleFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.DoubleConsumer4;
import org.jhotdraw8.geom.Integrals;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Solvers;
import org.jhotdraw8.geom.intersect.IntersectRayRay;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;

public class QuadCurves {
    private QuadCurves() {
    }

    public static double arcLength(double @NonNull [] p, int offset, double epsilon) {
        return QuadCurves.arcLength(p, offset, 1.0, epsilon);
    }

    public static double arcLengthClosedForm(double[] q, int offset, double t) {
        double x0 = q[offset];
        double y0 = q[offset + 1];
        double x1 = q[offset + 2];
        double y1 = q[offset + 3];
        double x2 = q[offset + 4];
        double y2 = q[offset + 5];
        if (Lines.isCollinear(x0, y0, x1, y1, x2, y2, 0.125)) {
            return Lines.arcLength(x0, y0, x1, y1) + Lines.arcLength(x1, y1, x2, y2);
        }
        double ax = x0 - x1 - x1 + x2;
        double ay = y0 - y1 - y1 + y2;
        double bx = x1 + x1 - x0 - x0;
        double by = y1 + y1 - y0 - y0;
        double A = 4.0 * (ax * ax + ay * ay);
        double B = 4.0 * (ax * bx + ay * by);
        double C = bx * bx + by * by;
        double b = B / (2.0 * A);
        double c = C / A;
        double u = t + b;
        double k = c - b * b;
        double E = Math.sqrt(u * u + k);
        double F = Math.sqrt(b * b + k);
        double arcLength = 0.5 * Math.sqrt(A) * (u * E - b * F + k * Math.log(Math.abs((u + E) / (b + F))));
        if (arcLength < 0.0 || Double.isNaN(arcLength)) {
            return Lines.arcLength(x0, y0, x1, y1) + Lines.arcLength(x1, y1, x2, y2);
        }
        return arcLength;
    }

    public static double arcLength(double @NonNull [] p, int offset, double t, double epsilon) {
        ToDoubleFunction<Double> f = QuadCurves.getArcLengthIntegrand(p, offset);
        return Integrals.rombergQuadrature(f, 0.0, t, epsilon);
    }

    public static @NonNull PointAndDerivative eval(Point2D p0, Point2D p1, Point2D p2, double t) {
        return QuadCurves.eval(p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY(), t);
    }

    public static @NonNull PointAndDerivative eval(double x0, double y0, double x1, double y1, double x2, double y2, double t) {
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        return new PointAndDerivative(x012, y012, x12 - x01, y12 - y01);
    }

    public static @NonNull PointAndDerivative eval(double[] p, int offset, double t) {
        double x0 = p[offset];
        double y0 = p[offset + 1];
        double x1 = p[offset + 2];
        double y1 = p[offset + 3];
        double x2 = p[offset + 4];
        double y2 = p[offset + 5];
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        return new PointAndDerivative(x012, y012, x12 - x01, y12 - y01);
    }

    public static ToDoubleFunction<Double> getArcLengthIntegrand(double[] p, int offset) {
        double x0 = p[offset];
        double y0 = p[offset + 1];
        double x1 = p[offset + 2];
        double y1 = p[offset + 3];
        double x2 = p[offset + 4];
        double y2 = p[offset + 5];
        double ax = x0 - x1 - x1 + x2;
        double ay = y0 - y1 - y1 + y2;
        double bx = x1 + x1 - x0 - x0;
        double by = y1 + y1 - y0 - y0;
        double A = 4.0 * (ax * ax + ay * ay);
        double B = 4.0 * (ax * bx + ay * by);
        double C = bx * bx + by * by;
        return t -> Math.sqrt(Math.fma(A, t * t, Math.fma(B, t, C)));
    }

    public static double invArcLengthClosedForm(double[] p, int offset, double s, double epsilon) {
        ToDoubleFunction<Double> f = t -> QuadCurves.arcLengthClosedForm(p, offset, t);
        return Solvers.bisectionMethod(f, s, 0.0, 1.0, epsilon);
    }

    public static double invArcLength(double[] p, int offset, double s, double epsilon) {
        return QuadCurves.invArcLength(p, offset, s, QuadCurves.arcLength(p, offset, 1.0, epsilon), epsilon);
    }

    public static double invArcLength(double[] p, int offset, double s, double totalArcLength, double epsilon) {
        ToDoubleFunction<Double> f = t -> QuadCurves.arcLength(p, offset, t, epsilon);
        ToDoubleFunction<Double> fd = QuadCurves.getArcLengthIntegrand(p, offset);
        return Solvers.hybridNewtonBisectionMethod(f, fd, s, 0.0, 1.0, s / totalArcLength, epsilon);
    }

    public static double @Nullable [] merge(double x0, double y0, double x01, double y01, double x012, double y012, double x12, double y12, double x2, double y2, double tolerance) {
        double[] dArray;
        Point2D.Double start = new Point2D.Double(x0, y0);
        @NonNull Point2D.Double b0 = new Point2D.Double(x2, y2);
        IntersectionResultEx isect = IntersectRayRay.intersectRayRayEx(start, Points2D.subtract(new Point2D.Double(x01, y01), start), b0, Points2D.subtract(new Point2D.Double(x12, y12), b0));
        if (isect.intersections().isEmpty()) {
            return null;
        }
        Point2D.Double ctrl = (Point2D.Double)isect.intersections().getLast();
        double t = start.distance(x01, y01) / start.distance(ctrl);
        Point2D.Double joint01 = QuadCurves.eval(x0, y0, ctrl.getX(), ctrl.getY(), x2, y2, t).getPoint(Point2D.Double::new);
        if (joint01.distance(x012, y012) <= tolerance) {
            double[] dArray2 = new double[6];
            dArray2[0] = x0;
            dArray2[1] = y0;
            dArray2[2] = ctrl.getX();
            dArray2[3] = ctrl.getY();
            dArray2[4] = x2;
            dArray = dArray2;
            dArray2[5] = y2;
        } else {
            dArray = null;
        }
        return dArray;
    }

    public static void split(double x0, double y0, double x1, double y1, double x2, double y2, double t, double[] first, double[] second) {
        QuadCurves.split(x0, y0, x1, y1, x2, y2, t, (a, b, c, d) -> {
            first[0] = a;
            first[1] = b;
            first[2] = c;
            first[3] = d;
        }, (a, b, c, d) -> {
            second[0] = a;
            second[1] = b;
            second[2] = c;
            second[3] = d;
        });
    }

    public static void split(double x0, double y0, double x1, double y1, double x2, double y2, double t, @Nullable DoubleConsumer4 first, @Nullable DoubleConsumer4 second) {
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        if (first != null) {
            first.accept(x01, y01, x012, y012);
        }
        if (second != null) {
            second.accept(x12, y12, x2, y2);
        }
    }

    public static void split(double @NonNull [] p, int o, double t, double @Nullable [] first, int offsetFirst, double @Nullable [] second, int offsetSecond) {
        double x0 = p[o];
        double y0 = p[o + 1];
        double x1 = p[o + 2];
        double y1 = p[o + 3];
        double x2 = p[o + 4];
        double y2 = p[o + 5];
        double x01 = Lines.lerp(x0, x1, t);
        double y01 = Lines.lerp(y0, y1, t);
        double x12 = Lines.lerp(x1, x2, t);
        double y12 = Lines.lerp(y1, y2, t);
        double x012 = Lines.lerp(x01, x12, t);
        double y012 = Lines.lerp(y01, y12, t);
        if (first != null) {
            first[offsetFirst] = x0;
            first[offsetFirst + 1] = y0;
            first[offsetFirst + 2] = x01;
            first[offsetFirst + 3] = y01;
            first[offsetFirst + 4] = x012;
            first[offsetFirst + 5] = y012;
        }
        if (second != null) {
            second[offsetSecond] = x012;
            second[offsetSecond + 1] = y012;
            second[offsetSecond + 2] = x12;
            second[offsetSecond + 3] = y12;
            second[offsetSecond + 4] = x2;
            second[offsetSecond + 5] = y2;
        }
    }

    public static void subCurve(double @NonNull [] q, int offset, double ta, double tb, double @NonNull [] first, int offsetFirst) {
        double tab = ta / tb;
        QuadCurves.split(q, offset, tb, null, 0, first, offsetFirst);
        QuadCurves.split(first, offsetFirst, tab, null, 0, first, offsetFirst);
    }
}

