/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.logging.Logger;
import javafx.geometry.Bounds;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.DoubleConverter;
import org.jhotdraw8.base.converter.FloatConverter;
import org.jhotdraw8.base.io.StreamPosTokenizer;
import org.jhotdraw8.geom.AwtPathBuilder;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.Points;

public class SvgPaths {
    private static final Logger LOGGER = Logger.getLogger(SvgPaths.class.getName());
    private static final DoubleConverter nb = new DoubleConverter();
    private static final FloatConverter nbf = new FloatConverter();

    private SvgPaths() {
    }

    public static <T> @NonNull PathBuilder<T> svgStringToBuilder(@NonNull String str, @NonNull PathBuilder<T> builder) throws ParseException {
        StreamPosTokenizer tt = new StreamPosTokenizer((Reader)new StringReader(str));
        try {
            tt.resetSyntax();
            tt.parseNumbers();
            tt.parseExponents();
            tt.parsePlusAsNumber();
            tt.whitespaceChars(0, 32);
            tt.whitespaceChars(44, 44);
            int next = 77;
            int command = 77;
            double x = 0.0;
            double y = 0.0;
            double cx1 = 0.0;
            double cy1 = 0.0;
            double cx2 = 0.0;
            double cy2 = 0.0;
            double ix = 0.0;
            double iy = 0.0;
            block24: while (tt.nextToken() != -1) {
                if (tt.ttype > 0) {
                    command = (char)tt.ttype;
                } else {
                    command = next;
                    tt.pushBack();
                }
                switch (command) {
                    case 77: {
                        tt.requireNextToken(-2, "x coordinate missing for 'M'");
                        ix = x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'M'");
                        iy = y = tt.nval;
                        builder.moveTo(x, y);
                        next = 76;
                        continue block24;
                    }
                    case 109: {
                        tt.requireNextToken(-2, "dx coordinate missing for 'm'");
                        ix = x += tt.nval;
                        tt.requireNextToken(-2, "dy coordinate missing for 'm'");
                        iy = y += tt.nval;
                        builder.moveTo(x, y);
                        next = 108;
                        continue block24;
                    }
                    case 90: 
                    case 122: {
                        builder.closePath();
                        x = ix;
                        y = iy;
                        continue block24;
                    }
                    case 76: {
                        tt.requireNextToken(-2, "x coordinate missing for 'L'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'L'");
                        y = tt.nval;
                        builder.lineTo(x, y);
                        next = 76;
                        continue block24;
                    }
                    case 108: {
                        tt.requireNextToken(-2, "dx coordinate missing for 'l'");
                        tt.requireNextToken(-2, "dy coordinate missing for 'l'");
                        builder.lineTo(x += tt.nval, y += tt.nval);
                        next = 108;
                        continue block24;
                    }
                    case 72: {
                        tt.requireNextToken(-2, "x coordinate missing for 'H'");
                        x = tt.nval;
                        builder.lineTo(x, y);
                        next = 72;
                        continue block24;
                    }
                    case 104: {
                        tt.requireNextToken(-2, "dx coordinate missing for 'h'");
                        builder.lineTo(x += tt.nval, y);
                        next = 104;
                        continue block24;
                    }
                    case 86: {
                        tt.requireNextToken(-2, "y coordinate missing for 'V'");
                        y = tt.nval;
                        builder.lineTo(x, y);
                        next = 86;
                        continue block24;
                    }
                    case 118: {
                        tt.requireNextToken(-2, "dy coordinate missing for 'v'");
                        builder.lineTo(x, y += tt.nval);
                        next = 118;
                        continue block24;
                    }
                    case 67: {
                        tt.requireNextToken(-2, "x1 coordinate missing for 'C'");
                        cx1 = tt.nval;
                        tt.requireNextToken(-2, "y1 coordinate missing for 'C'");
                        cy1 = tt.nval;
                        tt.requireNextToken(-2, "x2 coordinate missing for 'C'");
                        cx2 = tt.nval;
                        tt.requireNextToken(-2, "y2 coordinate missing for 'C'");
                        cy2 = tt.nval;
                        tt.requireNextToken(-2, "x coordinate missing for 'C'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'C'");
                        y = tt.nval;
                        builder.curveTo(cx1, cy1, cx2, cy2, x, y);
                        next = 67;
                        continue block24;
                    }
                    case 99: {
                        tt.requireNextToken(-2, "dx1 coordinate missing for 'c'");
                        cx1 = x + tt.nval;
                        tt.requireNextToken(-2, "dy1 coordinate missing for 'c'");
                        cy1 = y + tt.nval;
                        tt.requireNextToken(-2, "dx2 coordinate missing for 'c'");
                        cx2 = x + tt.nval;
                        tt.requireNextToken(-2, "dy2 coordinate missing for 'c'");
                        cy2 = y + tt.nval;
                        tt.requireNextToken(-2, "dx coordinate missing for 'c'");
                        tt.requireNextToken(-2, "dy coordinate missing for 'c'");
                        builder.curveTo(cx1, cy1, cx2, cy2, x += tt.nval, y += tt.nval);
                        next = 99;
                        continue block24;
                    }
                    case 83: {
                        tt.requireNextToken(-2, "x2 coordinate missing for 'S'");
                        cx2 = tt.nval;
                        tt.requireNextToken(-2, "y2 coordinate missing for 'S'");
                        cy2 = tt.nval;
                        tt.requireNextToken(-2, "x coordinate missing for 'S'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'S'");
                        y = tt.nval;
                        builder.smoothCurveTo(cx2, cy2, x, y);
                        next = 83;
                        continue block24;
                    }
                    case 115: {
                        tt.requireNextToken(-2, "dx2 coordinate missing for 's'");
                        cx2 = x + tt.nval;
                        tt.requireNextToken(-2, "dy2 coordinate missing for 's'");
                        cy2 = y + tt.nval;
                        tt.requireNextToken(-2, "dx coordinate missing for 's'");
                        tt.requireNextToken(-2, "dy coordinate missing for 's'");
                        builder.smoothCurveTo(cx2, cy2, x += tt.nval, y += tt.nval);
                        next = 115;
                        continue block24;
                    }
                    case 81: {
                        tt.requireNextToken(-2, "x1 coordinate missing for 'Q'");
                        cx1 = tt.nval;
                        tt.requireNextToken(-2, "y1 coordinate missing for 'Q'");
                        cy1 = tt.nval;
                        tt.requireNextToken(-2, "x coordinate missing for 'Q'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'Q'");
                        y = tt.nval;
                        builder.quadTo(cx1, cy1, x, y);
                        next = 81;
                        continue block24;
                    }
                    case 113: {
                        tt.requireNextToken(-2, "dx1 coordinate missing for 'q'");
                        cx1 = x + tt.nval;
                        tt.requireNextToken(-2, "dy1 coordinate missing for 'q'");
                        cy1 = y + tt.nval;
                        tt.requireNextToken(-2, "dx coordinate missing for 'q'");
                        tt.requireNextToken(-2, "dy coordinate missing for 'q'");
                        builder.quadTo(cx1, cy1, x += tt.nval, y += tt.nval);
                        next = 113;
                        continue block24;
                    }
                    case 84: {
                        tt.requireNextToken(-2, "x coordinate missing for 'T'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'T'");
                        y = tt.nval;
                        builder.smoothQuadTo(x, y);
                        next = 84;
                        continue block24;
                    }
                    case 116: {
                        tt.requireNextToken(-2, "dx coordinate missing for 't'");
                        tt.requireNextToken(-2, "dy coordinate missing for 't'");
                        builder.smoothQuadTo(x += tt.nval, y += tt.nval);
                        next = 115;
                        continue block24;
                    }
                    case 65: {
                        tt.requireNextToken(-2, "rx coordinate missing for 'A'");
                        double rx = tt.nval;
                        tt.requireNextToken(-2, "ry coordinate missing for 'A'");
                        double ry = tt.nval;
                        tt.requireNextToken(-2, "x-axis-rotation missing for 'A'");
                        double xAxisRotation = tt.nval;
                        tt.requireNextToken(-2, "large-arc-flag missing for 'A'");
                        boolean largeArcFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "sweep-flag missing for 'A'");
                        boolean sweepFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "x coordinate missing for 'A'");
                        x = tt.nval;
                        tt.requireNextToken(-2, "y coordinate missing for 'A'");
                        y = tt.nval;
                        builder.arcTo(rx, ry, xAxisRotation, x, y, largeArcFlag, sweepFlag);
                        next = 65;
                        continue block24;
                    }
                    case 97: {
                        tt.requireNextToken(-2, "rx coordinate missing for 'A'");
                        double rx = tt.nval;
                        tt.requireNextToken(-2, "ry coordinate missing for 'A'");
                        double ry = tt.nval;
                        tt.requireNextToken(-2, "x-axis-rotation missing for 'A'");
                        double xAxisRotation = tt.nval;
                        tt.requireNextToken(-2, "large-arc-flag missing for 'A'");
                        boolean largeArcFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "sweep-flag missing for 'A'");
                        boolean sweepFlag = tt.nval != 0.0;
                        tt.requireNextToken(-2, "x coordinate missing for 'A'");
                        tt.requireNextToken(-2, "y coordinate missing for 'A'");
                        builder.arcTo(rx, ry, xAxisRotation, x += tt.nval, y += tt.nval, largeArcFlag, sweepFlag);
                        next = 97;
                        continue block24;
                    }
                }
                throw new ParseException("Illegal command: " + (char)command + ".", tt.getStartPosition());
            }
        }
        catch (ParseException next) {
        }
        catch (IllegalPathStateException | IOException e) {
            throw new ParseException(e.getMessage(), tt.getStartPosition());
        }
        builder.pathDone();
        return builder;
    }

    public static @NonNull String awtPathIteratorToDoubleSvgString(@NonNull Shape shape) {
        return SvgPaths.awtPathIteratorToDoubleSvgString(shape.getPathIterator(null));
    }

    public static @NonNull String awtPathIteratorToDoubleSvgString(@NonNull Shape shape, AffineTransform at) {
        return SvgPaths.awtPathIteratorToDoubleSvgString(shape.getPathIterator(at));
    }

    public static @NonNull String awtPathIteratorToDoubleSvgString(@NonNull PathIterator iter) {
        StringBuilder buf = new StringBuilder();
        double[] coords = new double[6];
        double reflectedX = Double.NaN;
        double reflectedY = Double.NaN;
        char next = 'Z';
        while (!iter.isDone()) {
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            switch (iter.currentSegment(coords)) {
                case 0: {
                    buf.append('M');
                    next = 'L';
                    buf.append(nb.toString((Object)coords[0])).append(',').append(nb.toString((Object)coords[1]));
                    reflectedY = Double.NaN;
                    reflectedX = Double.NaN;
                    break;
                }
                case 1: {
                    if (next != 'L') {
                        next = 'L';
                        buf.append('L');
                    }
                    buf.append(nb.toString((Object)coords[0])).append(',').append(nb.toString((Object)coords[1]));
                    reflectedY = Double.NaN;
                    reflectedX = Double.NaN;
                    break;
                }
                case 2: {
                    if ((next == 'Q' || next == 'T') && Points.almostEqual(coords[0], coords[1], reflectedX, reflectedY)) {
                        if (next != 'T') {
                            next = 'T';
                            buf.append('T');
                        }
                        buf.append(nb.toString((Object)coords[2])).append(',').append(nb.toString((Object)coords[3]));
                    } else {
                        if (next != 'Q') {
                            next = 'Q';
                            buf.append('Q');
                        }
                        buf.append(nb.toString((Object)coords[0])).append(',').append(nb.toString((Object)coords[1])).append(',').append(nb.toString((Object)coords[2])).append(',').append(nb.toString((Object)coords[3]));
                    }
                    reflectedX = 2.0 * coords[2] - coords[0];
                    reflectedY = 2.0 * coords[3] - coords[1];
                    break;
                }
                case 3: {
                    if ((next == 'C' || next == 'S') && Points.almostEqual(coords[0], coords[1], reflectedX, reflectedY)) {
                        if (next != 'S') {
                            next = 'S';
                            buf.append('S');
                        }
                        buf.append(nb.toString((Object)coords[2])).append(',').append(nb.toString((Object)coords[3])).append(',').append(nb.toString((Object)coords[4])).append(',').append(nb.toString((Object)coords[5]));
                    } else {
                        if (next != 'C') {
                            next = 'C';
                            buf.append('C');
                        }
                        buf.append(nb.toString((Object)coords[0])).append(',').append(nb.toString((Object)coords[1])).append(',').append(nb.toString((Object)coords[2])).append(',').append(nb.toString((Object)coords[3])).append(',').append(nb.toString((Object)coords[4])).append(',').append(nb.toString((Object)coords[5]));
                    }
                    reflectedX = 2.0 * coords[4] - coords[2];
                    reflectedY = 2.0 * coords[5] - coords[3];
                    break;
                }
                case 4: {
                    if (next != 'Z') {
                        next = 'Z';
                        buf.append('Z');
                    }
                    reflectedY = Double.NaN;
                    reflectedX = Double.NaN;
                }
            }
            iter.next();
        }
        return buf.toString();
    }

    public static @NonNull String awtShapeToDoubleRelativeSvgString(@NonNull PathIterator iter) {
        StringBuilder buf = new StringBuilder();
        double[] coords = new double[6];
        double x = 0.0;
        double y = 0.0;
        double ix = 0.0;
        double iy = 0.0;
        char next = 'z';
        while (!iter.isDone()) {
            double px = x;
            double py = y;
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            switch (iter.currentSegment(coords)) {
                case 0: {
                    buf.append('m');
                    next = 'l';
                    ix = x = coords[0];
                    iy = y = coords[1];
                    buf.append(nb.toString((Object)(x - px))).append(',').append(nb.toString((Object)(y - py)));
                    break;
                }
                case 1: {
                    if (next != 'l') {
                        next = 'l';
                        buf.append('l');
                    }
                    x = coords[0];
                    y = coords[1];
                    buf.append(nb.toString((Object)(x - px))).append(',').append(nb.toString((Object)(y - py)));
                    break;
                }
                case 2: {
                    if (next != 'q') {
                        next = 'q';
                        buf.append('q');
                    }
                    x = coords[2];
                    y = coords[3];
                    buf.append(nb.toString((Object)(coords[0] - px))).append(',').append(nb.toString((Object)(coords[1] - py))).append(',').append(nb.toString((Object)(x - px))).append(',').append(nb.toString((Object)(y - py)));
                    break;
                }
                case 3: {
                    if (next != 'c') {
                        next = 'c';
                        buf.append('c');
                    }
                    x = coords[4];
                    y = coords[5];
                    buf.append(nb.toString((Object)(coords[0] - px))).append(',').append(nb.toString((Object)(coords[1] - py))).append(',').append(nb.toString((Object)(coords[2] - px))).append(',').append(nb.toString((Object)(coords[3] - py))).append(',').append(nb.toString((Object)(x - px))).append(',').append(nb.toString((Object)(y - py)));
                    break;
                }
                case 4: {
                    if (next != 'z') {
                        next = 'z';
                        buf.append('z');
                    }
                    x = ix;
                    y = iy;
                }
            }
            iter.next();
        }
        return buf.toString();
    }

    public static @NonNull String awtPathIteratorToFloatRelativeSvgString(@NonNull PathIterator iter) {
        StringBuilder buf = new StringBuilder();
        float[] coords = new float[6];
        float x = 0.0f;
        float y = 0.0f;
        float ix = 0.0f;
        float iy = 0.0f;
        char next = 'z';
        while (!iter.isDone()) {
            float px = x;
            float py = y;
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            switch (iter.currentSegment(coords)) {
                case 0: {
                    buf.append('m');
                    next = 'l';
                    ix = x = coords[0];
                    iy = y = coords[1];
                    buf.append(nbf.toString((Object)Float.valueOf(x - px))).append(',').append(nbf.toString((Object)Float.valueOf(y - py)));
                    break;
                }
                case 1: {
                    if (next != 'l') {
                        next = 'l';
                        buf.append('l');
                    }
                    x = coords[0];
                    y = coords[1];
                    buf.append(nbf.toString((Object)Float.valueOf(x - px))).append(',').append(nbf.toString((Object)Float.valueOf(y - py)));
                    break;
                }
                case 2: {
                    if (next != 'q') {
                        next = 'q';
                        buf.append('q');
                    }
                    x = coords[2];
                    y = coords[3];
                    buf.append(nbf.toString((Object)Float.valueOf(coords[0] - px))).append(',').append(nbf.toString((Object)Float.valueOf(coords[1] - py))).append(',').append(nbf.toString((Object)Float.valueOf(x - px))).append(',').append(nbf.toString((Object)Float.valueOf(y - py)));
                    break;
                }
                case 3: {
                    if (next != 'c') {
                        next = 'c';
                        buf.append('c');
                    }
                    x = coords[4];
                    y = coords[5];
                    buf.append(nbf.toString((Object)Float.valueOf(coords[0] - px))).append(',').append(nbf.toString((Object)Float.valueOf(coords[1] - py))).append(',').append(nbf.toString((Object)Float.valueOf(coords[2] - px))).append(',').append(nbf.toString((Object)Float.valueOf(coords[3] - py))).append(',').append(nbf.toString((Object)Float.valueOf(x - px))).append(',').append(nbf.toString((Object)Float.valueOf(y - py)));
                    break;
                }
                case 4: {
                    if (next != 'z') {
                        next = 'z';
                        buf.append('z');
                    }
                    x = ix;
                    y = iy;
                }
            }
            iter.next();
        }
        return buf.toString();
    }

    public static @NonNull String awtPathIteratorToFloatSvgString(@NonNull PathIterator iter) {
        StringBuilder buf = new StringBuilder();
        float[] coords = new float[6];
        char next = 'Z';
        while (!iter.isDone()) {
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            switch (iter.currentSegment(coords)) {
                case 0: {
                    buf.append('M');
                    next = 'L';
                    buf.append(nbf.toString((Object)Float.valueOf(coords[0]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[1])));
                    break;
                }
                case 1: {
                    if (next != 'L') {
                        next = 'L';
                        buf.append('L');
                    }
                    buf.append(nbf.toString((Object)Float.valueOf(coords[0]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[1])));
                    break;
                }
                case 2: {
                    if (next != 'Q') {
                        next = 'Q';
                        buf.append('Q');
                    }
                    buf.append(nbf.toString((Object)Float.valueOf(coords[0]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[1]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[2]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[3])));
                    break;
                }
                case 3: {
                    if (next != 'C') {
                        next = 'C';
                        buf.append('C');
                    }
                    buf.append(nbf.toString((Object)Float.valueOf(coords[0]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[1]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[2]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[3]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[4]))).append(',').append(nbf.toString((Object)Float.valueOf(coords[5])));
                    break;
                }
                case 4: {
                    if (next == 90) break;
                    next = 'Z';
                    buf.append('Z');
                }
            }
            iter.next();
        }
        return buf.toString();
    }

    public static  @NonNull Path2D.Double svgStringToAwtShape(@NonNull String str) throws ParseException {
        AwtPathBuilder b = new AwtPathBuilder();
        SvgPaths.svgStringToBuilder(str, b);
        return b.build();
    }

    public static void svgStringReshapeToBuilder(@Nullable String pathstr, @NonNull Bounds b, @NonNull PathBuilder<?> builder) {
        if (pathstr != null) {
            Path2D.Double shape = null;
            try {
                shape = SvgPaths.svgStringToAwtShape(pathstr);
                Rectangle2D r2d = shape.getBounds2D();
                Transform tx = FXTransforms.createReshapeTransform(r2d.getX(), r2d.getY(), r2d.getWidth(), r2d.getHeight(), b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                AwtShapes.buildFromPathIterator(builder, shape.getPathIterator(FXTransforms.toAwt(tx)));
                return;
            }
            catch (ParseException e) {
                LOGGER.warning(e.getMessage() + " Path: \"" + pathstr + "\".");
            }
        }
        builder.moveTo(b.getMinX(), b.getMinY());
        builder.lineTo(b.getMaxX(), b.getMinY());
        builder.lineTo(b.getMaxX(), b.getMaxY());
        builder.lineTo(b.getMinX(), b.getMaxY());
        builder.closePath();
    }
}

