/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.biarc;

import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.function.DoubleConsumer2;
import org.jhotdraw8.base.function.DoubleConsumer6;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.geom.Angles;

public class ArcToCubicCurve {
    private static final double TAU = Math.PI * 2;

    private ArcToCubicCurve() {
    }

    private static double[] approximateUnitArc(double theta1, double delta_theta) {
        double alpha = 1.3333333333333333 * Math.tan(delta_theta * 0.25);
        double x1 = Math.cos(theta1);
        double y1 = Math.sin(theta1);
        double x2 = Math.cos(theta1 + delta_theta);
        double y2 = Math.sin(theta1 + delta_theta);
        return new double[]{x1, y1, x1 - y1 * alpha, y1 + x1 * alpha, x2 + y2 * alpha, y2 - x2 * alpha, x2, y2};
    }

    public static void arcTo(double lastX, double lastY, double radiusX, double radiusY, double xAxisRotation, double x, double y, boolean largeArcFlag, boolean sweepFlag, @NonNull DoubleConsumer2 lineTo, @NonNull DoubleConsumer6 curveTo) {
        double x1 = lastX;
        double y1 = lastY;
        double x2 = x;
        double y2 = y;
        double rx = radiusX;
        double ry = radiusY;
        double phi = xAxisRotation;
        double sin_phi = Angles.sinDegrees(phi);
        double cos_phi = Angles.cosDegrees(phi);
        double x1p = cos_phi * (x1 - x2) * 0.5 + sin_phi * (y1 - y2) * 0.5;
        double y1p = -sin_phi * (x1 - x2) * 0.5 + cos_phi * (y1 - y2) * 0.5;
        if (x1p == 0.0 && y1p == 0.0) {
            lineTo.accept(x, y);
            return;
        }
        if (rx == 0.0 || ry == 0.0) {
            lineTo.accept(x, y);
            return;
        }
        double lambda = x1p * x1p / ((rx = Math.abs(rx)) * rx) + y1p * y1p / ((ry = Math.abs(ry)) * ry);
        if (lambda > 1.0) {
            double sqrtLambda = Math.sqrt(lambda);
            rx *= sqrtLambda;
            ry *= sqrtLambda;
        }
        ArcCenter cc = ArcToCubicCurve.getArcCenter(x1, y1, x2, y2, largeArcFlag, sweepFlag, rx, ry, sin_phi, cos_phi);
        ArrayList<double[]> result = new ArrayList<double[]>();
        double theta1 = cc.theta1;
        double delta_theta = cc.delta_theta;
        double segments = Math.max(Math.ceil(Math.abs(delta_theta) / 1.5707963267948966), 1.0);
        delta_theta /= segments;
        int i = 0;
        while ((double)i < segments) {
            result.add(ArcToCubicCurve.approximateUnitArc(theta1, delta_theta));
            theta1 += delta_theta;
            ++i;
        }
        int n = result.size();
        for (int k = 0; k < n; ++k) {
            double[] curve = (double[])result.get(k);
            for (int i2 = 2; i2 < curve.length; i2 += 2) {
                double x_ = curve[i2];
                double y_ = curve[i2 + 1];
                double xp = cos_phi * (x_ *= rx) - sin_phi * (y_ *= ry);
                double yp = sin_phi * x_ + cos_phi * y_;
                curve[i2] = xp + cc.cx;
                curve[i2 + 1] = yp + cc.cy;
            }
            if (k == n - 1) {
                curveTo.accept(curve[2], curve[3], curve[4], curve[5], x, y);
                continue;
            }
            curveTo.accept(curve[2], curve[3], curve[4], curve[5], curve[6], curve[7]);
        }
    }

    private static ArcCenter getArcCenter(double x1, double y1, double x2, double y2, boolean fa, boolean fs, double rx, double ry, double sin_phi, double cos_phi) {
        double rx_sq = rx * rx;
        double ry_sq = ry * ry;
        double y1p = -sin_phi * (x1 - x2) * 0.5 + cos_phi * (y1 - y2) * 0.5;
        double y1p_sq = y1p * y1p;
        double x1p = cos_phi * (x1 - x2) * 0.5 + sin_phi * (y1 - y2) * 0.5;
        double x1p_sq = x1p * x1p;
        double radicand = rx_sq * ry_sq - rx_sq * y1p_sq - ry_sq * x1p_sq;
        if (radicand < 0.0) {
            radicand = 0.0;
        }
        radicand = Math.sqrt(radicand /= rx_sq * y1p_sq + ry_sq * x1p_sq) * (double)(fa == fs ? -1 : 1);
        double cxp = radicand * rx / ry * y1p;
        double cyp = radicand * -ry / rx * x1p;
        double cx = cos_phi * cxp - sin_phi * cyp + (x1 + x2) * 0.5;
        double cy = sin_phi * cxp + cos_phi * cyp + (y1 + y2) * 0.5;
        double v1x = (x1p - cxp) / rx;
        double v1y = (y1p - cyp) / ry;
        double v2x = (-x1p - cxp) / rx;
        double v2y = (-y1p - cyp) / ry;
        double theta1 = ArcToCubicCurve.unitVectorAngle(1.0, 0.0, v1x, v1y);
        double delta_theta = ArcToCubicCurve.unitVectorAngle(v1x, v1y, v2x, v2y);
        if (!fs && delta_theta > 0.0) {
            delta_theta -= Math.PI * 2;
        }
        if (fs && delta_theta < 0.0) {
            delta_theta += Math.PI * 2;
        }
        return new ArcCenter(cx, cy, theta1, delta_theta);
    }

    private static double unitVectorAngle(double ux, double uy, double vx, double vy) {
        int sign = ux * vy - uy * vx < 0.0 ? -1 : 1;
        double dot = MathUtil.clamp((double)(ux * vx + uy * vy), (double)-1.0, (double)1.0);
        return (double)sign * Math.acos(dot);
    }

    private record ArcCenter(double cx, double cy, double theta1, double delta_theta) {
    }
}

