/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.biarc;

import java.awt.geom.Point2D;

public class Line {
    public final double m;
    public final Point2D.Double p;

    public Line(Point2D.Double p1, Point2D.Double p2) {
        this(p1, Line.slope(p1, p2));
    }

    public Line(Point2D.Double p, double m) {
        this.p = p;
        this.m = m;
    }

    public Point2D.Double Intersection(Line l) {
        if (Double.isNaN(this.m)) {
            return Line.verticalIntersection(this, l);
        }
        if (Double.isNaN(l.m)) {
            return Line.verticalIntersection(l, this);
        }
        double x = (this.m * this.p.getX() - l.m * l.p.getX() - this.p.getY() + l.p.getY()) / (this.m - l.m);
        double y = this.m * x - this.m * this.p.getX() + this.p.getY();
        return new Point2D.Double(x, y);
    }

    private static Point2D.Double verticalIntersection(Line vl, Line l) {
        double x = vl.p.getX();
        double y = l.m * (x - l.p.getX()) + l.p.getY();
        return new Point2D.Double(x, y);
    }

    public static Line createPerpendicularAt(Point2D.Double P, Point2D.Double P1) {
        double m = Line.slope(P, P1);
        if (m == 0.0) {
            return new Line(P, Double.NaN);
        }
        if (Double.isNaN(m)) {
            return new Line(P, 0.0);
        }
        return new Line(P, -1.0 / m);
    }

    private static double slope(Point2D.Double P1, Point2D.Double P2) {
        if (P2.getX() == P1.getX()) {
            return Double.NaN;
        }
        return (P2.getY() - P1.getY()) / (P2.getX() - P1.getX());
    }
}

