/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.Point2D;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.contour.PlineVertex;

public class BulgeConversionFunctions {
    private BulgeConversionFunctions() {
    }

    public static ArcRadiusAndCenter computeCircle(double x1, double y1, double x2, double y2, double b) {
        double chord = Points.distance(x1, y1, x2, y2);
        double theta = 4.0 * Math.atan(b);
        double r = chord * (b * b + 1.0) / (4.0 * b);
        double a = Math.fma(Math.PI - theta, 0.5, Angles.atan2(y2 - y1, x2 - x1));
        double cx = Math.fma(Math.sin(a), r, x1);
        double cy = Math.fma(Math.cos(a), r, y1);
        return new ArcRadiusAndCenter(cx, cy, r);
    }

    public static double computeBulge(double x1, double y1, double x2, double y2, double x3, double y3) {
        double a = 0.5 * (Math.PI - Angles.atan2(y2 - y1, x2 - x1) + Angles.atan2(y2 - y3, x2 - x3));
        double cosa = Math.cos(a);
        return cosa == 0.0 ? 0.0 : Math.sin(a) / cosa;
    }

    public static double computeBulge(double x1, double y1, double x2, double y2, double r) {
        double chord = Points.distance(x1, y1, x2, y2);
        double d = chord * 0.5;
        return r <= chord ? 0.0 : Math.tan(Math.asin(d / r) * 0.5);
    }

    public static ArcRadiusAndCenter arcRadiusAndCenter(PlineVertex v1, PlineVertex v2) {
        assert (!v1.bulgeIsZero()) : "v1 to v2 must be an arc";
        assert (!Points.almostEqual(v1.pos(), v2.pos())) : "v1 must not be ontop of v2";
        double b = Math.abs(v1.bulge());
        Point2D.Double v = Points2D.subtract(v2.pos(), v1.pos());
        double d = Points2D.magnitude(v);
        double r = d * (b * b + 1.0) / (4.0 * b);
        double s = b * d / 2.0;
        double m = r - s;
        double offsX = -m * v.getY() / d;
        double offsY = m * v.getX() / d;
        if (v1.bulgeIsNeg()) {
            offsX = -offsX;
            offsY = -offsY;
        }
        Point2D.Double c = new Point2D.Double(v1.getX() + v.getX() * 0.5 + offsX, v1.getY() + v.getY() * 0.5 + offsY);
        return new ArcRadiusAndCenter(r, c);
    }

    public static class ArcRadiusAndCenter {
        final double radius;
        final Point2D.Double center;

        public ArcRadiusAndCenter(double radius, Point2D.Double c) {
            this(c.getX(), c.getY(), radius);
        }

        public ArcRadiusAndCenter(double cx, double cy, double radius) {
            this.center = new Point2D.Double(cx, cy);
            this.radius = radius;
        }

        public Point2D.Double getCenter() {
            return this.center;
        }

        public double getCx() {
            return this.center.getX();
        }

        public double getCy() {
            return this.center.getY();
        }

        public double getRadius() {
            return this.radius;
        }
    }
}

