/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiPredicate;
import org.jhotdraw8.geom.AABB;
import org.jhotdraw8.geom.PathIteratorPathBuilder;
import org.jhotdraw8.geom.contour.BulgeConversionFunctions;
import org.jhotdraw8.geom.contour.PlineVertex;
import org.jhotdraw8.geom.contour.StaticSpatialIndex;

public class PlinePath
extends ArrayList<PlineVertex>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean closed;
    private int windingRule = 0;

    @Override
    public PlinePath clone() {
        return (PlinePath)super.clone();
    }

    public PlinePath() {
    }

    public PlinePath(int initialCapacity) {
        super(initialCapacity);
    }

    public void addVertex(PlineVertex v) {
        this.add(v);
    }

    public void addVertex(double x, double y) {
        this.addVertex(x, y, 0.0);
    }

    public void addVertex(double x, double y, double bulge) {
        this.add(new PlineVertex(x, y, bulge));
    }

    public boolean isClosed() {
        return this.closed;
    }

    public PlineVertex lastVertex() {
        return (PlineVertex)this.get(this.size() - 1);
    }

    public void lastVertex(PlineVertex newValue) {
        this.set(this.size() - 1, newValue);
    }

    public void isClosed(boolean closed) {
        this.closed = closed;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public PlineVertex removeLast() {
        return (PlineVertex)this.remove(this.size() - 1);
    }

    public void visitSegIndices(BiPredicate<Integer, Integer> visitor) {
        int j;
        int i;
        if (this.size() < 2) {
            return;
        }
        if (this.isClosed()) {
            i = 0;
            j = this.size() - 1;
        } else {
            i = 1;
            j = 0;
        }
        while (i < this.size() && visitor.test(j, i)) {
            j = i++;
        }
    }

    public void setWindingRule(int windingRule) {
        this.windingRule = windingRule;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        PathIteratorPathBuilder b = new PathIteratorPathBuilder(this.getWindingRule());
        if (this.size() > 0) {
            PlineVertex prev = (PlineVertex)this.get(this.size() - 1);
            for (PlineVertex vertex : this) {
                if (prev.bulgeIsZero()) {
                    if (b.isEmpty()) {
                        b.moveTo(vertex.getX(), vertex.getY());
                    } else {
                        b.lineTo(vertex.getX(), vertex.getY());
                    }
                } else {
                    double bulge = prev.bulge();
                    BulgeConversionFunctions.ArcRadiusAndCenter circle = BulgeConversionFunctions.computeCircle(prev.getX(), prev.getY(), vertex.getX(), vertex.getY(), bulge);
                    if (b.isEmpty()) {
                        b.moveTo(prev.getX(), prev.getY());
                    }
                    b.arcTo(circle.getRadius(), circle.getRadius(), 0.0, vertex.getX(), vertex.getY(), false, bulge > 0.0);
                }
                prev = vertex;
            }
            if (this.isClosed()) {
                b.closePath();
            }
        }
        return b.build();
    }

    public static StaticSpatialIndex createApproxSpatialIndex(PlinePath pline) {
        assert (pline.size() > 1) : "need at least 2 vertexes to form segments for spatial index";
        int segmentCount = pline.isClosed() ? pline.size() : pline.size() - 1;
        StaticSpatialIndex result = new StaticSpatialIndex(segmentCount);
        for (int i = 0; i < pline.size() - 1; ++i) {
            AABB approxBB = PlineVertex.createFastApproxBoundingBox((PlineVertex)pline.get(i), (PlineVertex)pline.get(i + 1));
            result.add(approxBB.minX(), approxBB.minY(), approxBB.maxX(), approxBB.maxY());
        }
        if (pline.isClosed()) {
            AABB approxBB = PlineVertex.createFastApproxBoundingBox(pline.lastVertex(), (PlineVertex)pline.getFirst());
            result.add(approxBB.minX(), approxBB.minY(), approxBB.maxX(), approxBB.maxY());
        }
        result.finish();
        return result;
    }

    public static void invertDirection(PlinePath pline) {
        if (pline.size() < 2) {
            return;
        }
        Collections.reverse(pline);
        double firstBulge = ((PlineVertex)pline.getFirst()).bulge();
        for (int i = 1; i < pline.size(); ++i) {
            ((PlineVertex)pline.get(i - 1)).bulge(-((PlineVertex)pline.get(i)).bulge());
        }
        pline.lastVertex().bulge(-firstBulge);
    }

    public double getPathLength() {
        if (this.size() < 2) {
            return 0.0;
        }
        double[] result = new double[]{0.0};
        BiPredicate<Integer, Integer> visitor = (i, j) -> {
            result[0] = result[0] + PlineVertex.segLength((PlineVertex)this.get((int)i), (PlineVertex)this.get((int)j));
            return true;
        };
        this.visitSegIndices(visitor);
        return result[0];
    }
}

