/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.contour.PlinePath;

public class PlinePathBuilder
extends AbstractPathBuilder<List<PlinePath>> {
    private final List<PlinePath> paths = new ArrayList<PlinePath>();
    private PlinePath current;
    private double flatness = 0.125;

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
    }

    @Override
    public List<PlinePath> build() {
        return this.paths;
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        if (this.current != null) {
            this.current.isClosed(true);
        }
    }

    @Override
    protected void doPathDone() {
        if (this.current != null) {
            this.paths.add(this.current);
            this.current = null;
        }
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        if (this.current == null) {
            this.current = new PlinePath();
        }
        PathIterator it = new CubicCurve2D.Double(lastX, lastY, x1, y1, x2, y2, x, y).getPathIterator(null, this.flatness);
        it.next();
        double[] coords = new double[8];
        while (!it.isDone()) {
            it.currentSegment(coords);
            this.lineTo(coords[0], coords[1]);
            it.next();
        }
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        if (this.current == null) {
            this.current = new PlinePath();
        }
        this.current.addVertex(x, y);
    }

    @Override
    protected void doMoveTo(double x, double y) {
        if (this.current != null) {
            this.paths.add(this.current);
        }
        this.current = new PlinePath();
        this.current.addVertex(x, y);
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        if (this.current == null) {
            this.current = new PlinePath();
        }
        PathIterator it = new QuadCurve2D.Double(lastX, lastY, x1, y1, x, y).getPathIterator(null, this.flatness);
        it.next();
        double[] coords = new double[8];
        while (!it.isDone()) {
            it.currentSegment(coords);
            this.lineTo(coords[0], coords[1]);
            it.next();
        }
    }

    @Override
    protected void doArcTo(double lastX, double lastY, double radiusX, double radiusY, double xAxisRotation, double x, double y, boolean largeArcFlag, boolean sweepFlag) {
        if (radiusX != radiusY) {
            super.doArcTo(lastX, lastY, radiusX, radiusY, xAxisRotation, x, y, largeArcFlag, sweepFlag);
        }
    }
}

