/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.Point2D;
import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;

public class Utils {
    public static final double realPrecision = 1.0E-5;
    public static final double sliceJoinThreshold = 1.0E-4;
    public static final double tau = Math.PI * 2;
    public static final double offsetThreshold = 1.0E-4;

    private Utils() {
    }

    public static double perpDot(Point2D.Double v0, Point2D.Double v1) {
        return v0.getX() * v1.getY() - v0.getY() * v1.getX();
    }

    public static OrderedPair<Double, Double> minmax(double a, double b) {
        return a < b ? new SimpleOrderedPair((Object)a, (Object)b) : new SimpleOrderedPair((Object)b, (Object)a);
    }

    public static boolean fuzzyInRange(double minValue, double value, double maxValue) {
        return Utils.fuzzyInRange(minValue, value, maxValue, 1.0E-8);
    }

    public static boolean fuzzyInRange(double minValue, double value, double maxValue, double epsilon) {
        return value + epsilon > minValue && value < maxValue + epsilon;
    }

    static boolean pointWithinArcSweepAngle(Point2D.Double center, Point2D.Double arcStart, Point2D.Double arcEnd, double bulge, Point2D.Double point) {
        assert (Math.abs(bulge) > 1.0E-8) : "expected arc";
        assert (Math.abs(bulge) <= 1.0) : "bulge should always be between -1 and 1";
        if (bulge > 0.0) {
            return Utils.isLeftOrCoincident(center, arcStart, point) && Utils.isRightOrCoincident(center, arcEnd, point);
        }
        return Utils.isRightOrCoincident(center, arcStart, point) && Utils.isLeftOrCoincident(center, arcEnd, point);
    }

    static boolean isLeftOrCoincident(Point2D.Double p0, Point2D.Double p1, Point2D.Double point) {
        return Utils.isLeftOrCoincident(p0, p1, point, 1.0E-8);
    }

    static boolean isLeftOrCoincident(Point2D.Double p0, Point2D.Double p1, Point2D.Double point, double epsilon) {
        return (p1.getX() - p0.getX()) * (point.getY() - p0.getY()) - (p1.getY() - p0.getY()) * (point.getX() - p0.getX()) > -epsilon;
    }

    static boolean isRightOrCoincident(Point2D.Double p0, Point2D.Double p1, Point2D.Double point) {
        return Utils.isRightOrCoincident(p0, p1, point, 1.0E-8);
    }

    static boolean isRightOrCoincident(Point2D.Double p0, Point2D.Double p1, Point2D.Double point, double epsilon) {
        return (p1.getX() - p0.getX()) * (point.getY() - p0.getY()) - (p1.getY() - p0.getY()) * (point.getX() - p0.getX()) < epsilon;
    }

    static OrderedPair<Double, Double> quadraticSolutions(double a, double b, double c, double discr) {
        assert (Points.almostEqual(b * b - 4.0 * a * c, discr, 1.0E-8)) : "discriminate is not correct";
        double sqrtDiscr = Math.sqrt(discr);
        double denom = 2.0 * a;
        double sol1 = b < 0.0 ? (-b + sqrtDiscr) / denom : (-b - sqrtDiscr) / denom;
        double sol2 = c / a / sol1;
        return Utils.minmax(sol1, sol2);
    }

    public static Point2D.Double pointFromParametric(Point2D.Double p0, Point2D.Double p1, double t) {
        return Lines.lerp(p0, p1, t);
    }

    public static double angle(Point2D.Double p0, Point2D.Double p1) {
        return Angles.atan2(p1.getY() - p0.getY(), p1.getX() - p0.getX());
    }

    public static double deltaAngle(double angle1, double angle2) {
        double diff = Utils.normalizeRadians(angle2 - angle1);
        if (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        return diff;
    }

    public static double normalizeRadians(double angle) {
        if (angle >= 0.0 && angle < Math.PI * 2) {
            return angle;
        }
        return angle - Math.floor(angle / (Math.PI * 2)) * (Math.PI * 2);
    }

    public static Point2D.Double unitPerp(Point2D.Double v) {
        Point2D.Double result = new Point2D.Double(-v.getY(), v.getX());
        return Points2D.normalize(result);
    }

    static <T> int nextWrappingIndex(int index, @NonNull List<T> container) {
        return index == container.size() - 1 ? 0 : index + 1;
    }

    static <T> int prevWrappingIndex(int index, @NonNull List<T> container) {
        return index == 0 ? container.size() - 1 : index - 1;
    }

    static boolean angleIsWithinSweep(double startAngle, double sweepAngle, double testAngle) {
        return Utils.angleIsWithinSweep(startAngle, sweepAngle, testAngle, 1.0E-8);
    }

    static boolean angleIsWithinSweep(double startAngle, double sweepAngle, double testAngle, double epsilon) {
        double endAngle = startAngle + sweepAngle;
        if (sweepAngle < 0.0) {
            return Utils.angleIsBetween(endAngle, startAngle, testAngle, epsilon);
        }
        return Utils.angleIsBetween(startAngle, endAngle, testAngle, epsilon);
    }

    static boolean angleIsBetween(double startAngle, double endAngle, double testAngle) {
        return Utils.angleIsBetween(startAngle, endAngle, testAngle, 1.0E-8);
    }

    static boolean angleIsBetween(double startAngle, double endAngle, double testAngle, double epsilon) {
        double endSweep = Utils.normalizeRadians(endAngle - startAngle);
        double midSweep = Utils.normalizeRadians(testAngle - startAngle);
        return midSweep < endSweep + epsilon;
    }

    static Point2D.Double closestPointOnLineSeg(Point2D.Double p0, Point2D.Double p1, Point2D.Double point) {
        Point2D.Double v = Points2D.subtract(p1, p0);
        Point2D.Double w = Points2D.subtract(point, p0);
        double c1 = Points2D.dotProduct(w, v);
        if (c1 < 1.0E-8) {
            return p0;
        }
        double c2 = Points2D.dotProduct(v, v);
        if (c2 < c1 + 1.0E-8) {
            return p1;
        }
        double b = c1 / c2;
        return Points2D.add(p0, Points2D.multiply(v, b));
    }
}

