/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectCircleLine {
    private IntersectCircleLine() {
    }

    public static @NonNull IntersectionResultEx intersectCircleLineEx(double cx, double cy, double r, double a0x, double a0y, double a1x, double a1y) {
        return IntersectCircleLine.intersectCircleLineEx(new Point2D.Double(cx, cy), r, new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y));
    }

    public static @NonNull IntersectionResultEx intersectCircleLineEx(@NonNull Point2D c, double r, @NonNull Point2D a0, @NonNull Point2D a1) {
        IntersectionResultEx inter = IntersectCircleLine.intersectLineCircleEx(a0, a1, c, r);
        return inter;
    }

    public static @NonNull IntersectionResultEx intersectLineCircleEx(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull Point2D c, double r) {
        return IntersectCircleLine.intersectLineCircleEx(a0.getX(), a0.getY(), a1.getX(), a1.getY(), c.getX(), c.getY(), r);
    }

    public static IntersectionResultEx intersectLineCircleEx(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull Point2D c, double r, double epsilon) {
        return IntersectCircleLine.intersectLineCircleEx(a0.getX(), a0.getY(), a1.getX(), a1.getY(), c.getX(), c.getY(), r, epsilon);
    }

    public static IntersectionResult intersectLineCircle(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull Point2D c, double r, double epsilon) {
        return IntersectCircleLine.intersectLineCircle(a0.getX(), a0.getY(), a1.getX(), a1.getY(), c.getX(), c.getY(), r, epsilon);
    }

    public static @NonNull IntersectionResultEx intersectLineCircleEx(double x0, double y0, double x1, double y1, double cx, double cy, double r) {
        return IntersectCircleLine.intersectLineCircleEx(x0, y0, x1, y1, cx, cy, r, 1.1641532182693481E-10);
    }

    public static @NonNull IntersectionResultEx intersectLineCircleEx(double x0, double y0, double x1, double y1, double cx, double cy, double r, double epsilon) {
        IntersectionStatus status;
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>(2);
        double \u0394x = x1 - x0;
        double \u0394y = y1 - y0;
        if (Math.abs(\u0394x) < 1.0E-6 && Math.abs(\u0394y) < 1.0E-6) {
            double distanceSquared = (x0 - cx) * (x0 - cx) + (y0 - cy) * (y0 - cy);
            return new IntersectionResultEx(distanceSquared <= r * r ? IntersectionStatus.NO_INTERSECTION_INSIDE : IntersectionStatus.NO_INTERSECTION_OUTSIDE, result);
        }
        double a = \u0394x * \u0394x + \u0394y * \u0394y;
        double b = 2.0 * (\u0394x * (x0 - cx) + \u0394y * (y0 - cy));
        double c = cx * cx + cy * cy + x0 * x0 + y0 * y0 - 2.0 * (cx * x0 + cy * y0) - r * r;
        double deter = b * b - 4.0 * a * c;
        double minT = -epsilon;
        double maxT = 1.0 + epsilon;
        if (deter < minT) {
            status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (deter > epsilon) {
            double e = Math.sqrt(deter);
            double t1 = (-b + e) / (2.0 * a);
            double t2 = (-b - e) / (2.0 * a);
            if ((t1 < minT || t1 > maxT) && (t2 < minT || t2 > maxT)) {
                status = t1 <= minT && t2 <= minT || t1 > maxT && t2 > maxT ? IntersectionStatus.NO_INTERSECTION_OUTSIDE : IntersectionStatus.NO_INTERSECTION_INSIDE;
            } else {
                status = IntersectionStatus.INTERSECTION;
                if (t2 < t1) {
                    double swap = t2;
                    t2 = t1;
                    t1 = swap;
                }
                if (minT <= t1 && t1 <= maxT) {
                    Point2D.Double p = Lines.lerp(x0, y0, x1, y1, t1);
                    result.add(new IntersectionPointEx(p, t1, new Point2D.Double(x1 - x0, y1 - y0), Angles.atan2(p.getY() - cy, p.getX() - cx), new Point2D.Double(p.getY() - cy, -p.getX() - cx)));
                }
                if (minT <= t2 && t2 <= maxT) {
                    Point2D.Double p = Lines.lerp(x0, y0, x1, y1, t2);
                    result.add(new IntersectionPointEx(p, t2, new Point2D.Double(x1 - x0, y1 - y0), Angles.atan2(p.getY() - cy, p.getX() - cx), new Point2D.Double(p.getY() - cy, -p.getX() - cx)));
                }
            }
        } else {
            double t = -b / (2.0 * a);
            if (minT <= t && t <= maxT) {
                status = IntersectionStatus.INTERSECTION;
                Point2D.Double p = Lines.lerp(x0, y0, x1, y1, t);
                result.add(new IntersectionPointEx(p, t, new Point2D.Double(x1 - x0, y1 - y0), Angles.atan2(p.getY() - cy, p.getX() - cx), new Point2D.Double(p.getY() - cy, -p.getX() - cx)));
            } else {
                status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
            }
        }
        return new IntersectionResultEx(status, result);
    }

    public static @NonNull IntersectionResult intersectLineCircle(double x0, double y0, double x1, double y1, double cx, double cy, double r) {
        return IntersectCircleLine.intersectLineCircle(x0, y0, x1, y1, cx, cy, r, 1.0E-8);
    }

    public static @NonNull IntersectionResult intersectLineCircle(double x0, double y0, double x1, double y1, double cx, double cy, double r, double epsilon) {
        IntersectionStatus status;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>(2);
        double \u0394x = x1 - x0;
        double \u0394y = y1 - y0;
        double a = \u0394x * \u0394x + \u0394y * \u0394y;
        double b = 2.0 * (\u0394x * (x0 - cx) + \u0394y * (y0 - cy));
        double c = cx * cx + cy * cy + x0 * x0 + y0 * y0 - 2.0 * (cx * x0 + cy * y0) - r * r;
        double deter = b * b - 4.0 * a * c;
        double minT = -epsilon;
        double maxT = 1.0 + epsilon;
        if (deter < minT) {
            status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (deter > epsilon) {
            double e = Math.sqrt(deter);
            double t1 = (-b + e) / (2.0 * a);
            double t2 = (-b - e) / (2.0 * a);
            if ((t1 < minT || t1 > maxT) && (t2 < minT || t2 > maxT)) {
                status = t1 <= minT && t2 <= minT || t1 > maxT && t2 > maxT ? IntersectionStatus.NO_INTERSECTION_OUTSIDE : IntersectionStatus.NO_INTERSECTION_INSIDE;
            } else {
                status = IntersectionStatus.INTERSECTION;
                if (t2 < t1) {
                    double swap = t2;
                    t2 = t1;
                    t1 = swap;
                }
                if (minT <= t1 && t1 <= maxT) {
                    result.add(new IntersectionPoint(Lines.lerp(x0, y0, x1, y1, t1).getX(), Lines.lerp(x0, y0, x1, y1, t1).getY(), t1));
                }
                if (minT <= t2 && t2 <= maxT) {
                    result.add(new IntersectionPoint(Lines.lerp(x0, y0, x1, y1, t2).getX(), Lines.lerp(x0, y0, x1, y1, t2).getY(), t2));
                }
            }
        } else {
            double t = -b / (2.0 * a);
            if (minT <= t && t <= maxT) {
                status = IntersectionStatus.INTERSECTION;
                Point2D.Double p = Lines.lerp(x0, y0, x1, y1, t);
                result.add(new IntersectionPoint(p.getX(), p.getY(), t));
            } else {
                status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
            }
        }
        return new IntersectionResult(status, result);
    }
}

