/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.intersect.IntersectCircleCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectCircleLine;
import org.jhotdraw8.geom.intersect.IntersectCircleQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectCirclePathIterator {
    private IntersectCirclePathIterator() {
    }

    public static @NonNull IntersectionResultEx intersectPathIteratorCircleEx(@NonNull PathIterator pit, double cx, double cy, double r) {
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        double[] seg = new double[6];
        double firstx = 0.0;
        double firsty = 0.0;
        double lastx = 0.0;
        double lasty = 0.0;
        while (!pit.isDone()) {
            switch (pit.currentSegment(seg)) {
                case 4: {
                    IntersectionResultEx inter = IntersectCircleLine.intersectLineCircleEx(lastx, lasty, firstx, firsty, cx, cy, r);
                    result.addAll(inter.intersections().asList());
                    break;
                }
                case 3: {
                    double x = seg[4];
                    double y = seg[5];
                    IntersectionResultEx inter = IntersectCircleCubicCurve.intersectCubicCurveCircleEx(lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y, cx, cy, r);
                    result.addAll(inter.intersections().asList());
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 1: {
                    double x = seg[0];
                    double y = seg[1];
                    IntersectionResultEx inter = IntersectCircleLine.intersectLineCircleEx(lastx, lasty, x, y, cx, cy, r);
                    result.addAll(inter.intersections().asList());
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 0: {
                    lastx = firstx = seg[0];
                    lasty = firsty = seg[1];
                    break;
                }
                case 2: {
                    double x = seg[2];
                    double y = seg[3];
                    IntersectionResultEx inter = IntersectCircleQuadCurve.intersectQuadCurveCircleEx(lastx, lasty, seg[0], seg[1], x, y, cx, cy, r);
                    result.addAll(inter.intersections().asList());
                    lastx = x;
                    lasty = y;
                }
            }
            pit.next();
        }
        return new IntersectionResultEx(result);
    }
}

