/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectCirclePoint {
    private IntersectCirclePoint() {
    }

    public static @NonNull IntersectionResult intersectCirclePoint(double cx, double cy, double cr, double px, double py, double pr) {
        return IntersectCirclePoint.intersectCirclePoint(cx, cy, cr, px, py, pr, 1.0E-8);
    }

    public static @NonNull IntersectionResultEx intersectCirclePointEx(double cx, double cy, double cr, double px, double py, double pr) {
        return IntersectCirclePoint.intersectCirclePointEx(cx, cy, cr, px, py, pr, 1.0E-8);
    }

    public static IntersectionResult intersectCirclePoint(double cx, double cy, double cr, double px, double py, double pr, double epsilon) {
        return IntersectCirclePoint.intersectCirclePoint(new Point2D.Double(cx, cy), cr, new Point2D.Double(px, py), pr, epsilon);
    }

    public static @NonNull IntersectionResult intersectCirclePoint(@NonNull Point2D cc, double cr, @NonNull Point2D pc, double pr, double epsilon) {
        IntersectionStatus status;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        double c_dist = cc.distance(pc);
        if (Points.almostZero(c_dist, epsilon)) {
            status = IntersectionStatus.NO_INTERSECTION_INSIDE;
        } else {
            Point2D.Double p = Lines.lerp(cc, pc, cr / c_dist);
            double dd = p.distanceSq(pc);
            if (dd <= pr * pr) {
                status = IntersectionStatus.INTERSECTION;
                result.add(new IntersectionPoint(p, Angles.atan2(p.getY() - cc.getY(), p.getX() - cc.getX())));
            } else {
                status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
            }
        }
        return new IntersectionResult(status, result);
    }

    public static @NonNull IntersectionResult intersectPointCircle(@NonNull Point2D point, @NonNull Point2D center, double radius) {
        IntersectionStatus status;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        double distance = point.distance(center);
        if (distance - radius < 1.1641532182693481E-10) {
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(new Point2D.Double(point.getX(), point.getY()), Double.NaN));
        } else {
            status = distance < radius ? IntersectionStatus.NO_INTERSECTION_INSIDE : IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectCirclePointEx(double cx, double cy, double cr, double px, double py, double pr, double epsilon) {
        IntersectionResult result = IntersectCirclePoint.intersectCirclePoint(new Point2D.Double(cx, cy), cr, new Point2D.Double(px, py), pr, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            list.add(new IntersectionPointEx(x, y, ip.getArgumentA(), y - cy, cx - x, 0.0, 1.0, 0.0));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

