/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.intersect.IntersectEllipsePoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectCubicCurveEllipse {
    private IntersectCubicCurveEllipse() {
    }

    public static @NonNull IntersectionResult intersectCubicCurveEllipse(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double rx, double ry) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipse(new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3), new Point2D.Double(cx, cy), rx, ry);
    }

    public static @NonNull IntersectionResult intersectCubicCurveEllipse(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double rx, double ry, double epsilon) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipse(new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3), new Point2D.Double(cx, cy), rx, ry, epsilon);
    }

    public static @NonNull IntersectionResultEx intersectCubicCurveEllipseEx(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double rx, double ry) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipseEx(x0, y0, x1, y1, x2, y2, x3, y3, cx, cy, rx, ry, 1.0E-8);
    }

    public static @NonNull IntersectionResultEx intersectCubicCurveEllipseEx(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double rx, double ry, double epsilon) {
        IntersectionResult result = IntersectCubicCurveEllipse.intersectCubicCurveEllipse(new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3), new Point2D.Double(cx, cy), rx, ry, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pat = CubicCurves.eval(x0, y0, x1, y1, x2, y2, x3, y3, ip.getArgumentA());
            list.add(new IntersectionPointEx(x, y, ip.getArgumentA(), pat.dx(), pat.dy(), Angles.atan2Ellipse(cx, cy, rx, ry, x, y), y - cy, cx - x));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static @NonNull IntersectionResult intersectCubicCurveEllipse(@NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2, @NonNull Point2D p3, @NonNull Point2D ec, double rx, double ry) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipse(p0, p1, p2, p3, ec, rx, ry, 1.0E-8);
    }

    public static @NonNull IntersectionResult intersectCubicCurveEllipse(@NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2, @NonNull Point2D p3, @NonNull Point2D ec, double rx, double ry, double epsilon) {
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double c3 = Points2D.sum(Points2D.multiply(p0, -1.0), Points2D.multiply(p1, 3.0), Points2D.multiply(p2, -3.0), p3);
        Point2D.Double c2 = Points2D.sum(Points2D.multiply(p0, 3.0), Points2D.multiply(p1, -6.0), Points2D.multiply(p2, 3.0));
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -3.0), Points2D.multiply(p1, 3.0));
        Point2D c0 = p0;
        double rxrx = rx * rx;
        double ryry = ry * ry;
        double c3x = ((Point2D)c3).getX();
        double c3y = ((Point2D)c3).getY();
        double c2x = ((Point2D)c2).getX();
        double c1x = ((Point2D)c1).getX();
        double c2y = ((Point2D)c2).getY();
        double c1y = ((Point2D)c1).getY();
        double ecx = ec.getX();
        double c0x = c0.getX();
        double c0y = c0.getY();
        double ecy = ec.getY();
        Polynomial poly = new Polynomial(c3x * c3x * ryry + c3y * c3y * rxrx, 2.0 * (c3x * c2x * ryry + c3y * c2y * rxrx), 2.0 * (c3x * c1x * ryry + c3y * c1y * rxrx) + c2x * c2x * ryry + c2y * c2y * rxrx, 2.0 * c3x * ryry * (c0x - ecx) + 2.0 * c3y * rxrx * (c0y - ecy) + 2.0 * (c2x * c1x * ryry + c2y * c1y * rxrx), 2.0 * c2x * ryry * (c0x - ecx) + 2.0 * c2y * rxrx * (c0y - ecy) + c1x * c1x * ryry + c1y * c1y * rxrx, 2.0 * c1x * ryry * (c0x - ecx) + 2.0 * c1y * rxrx * (c0y - ecy), c0x * c0x * ryry - 2.0 * c0y * ecy * rxrx - 2.0 * c0x * ecx * ryry + c0y * c0y * rxrx + ecx * ecx * ryry + ecy * ecy * rxrx - rxrx * ryry);
        DoubleArrayList roots = poly.getRootsInInterval(-epsilon, 1.0 + epsilon);
        for (Double root : roots) {
            double t = MathUtil.clamp((double)root, (double)0.0, (double)1.0);
            result.add(new IntersectionPoint(Points2D.sum(Points2D.multiply(c3, t * t * t), Points2D.multiply(c2, t * t), Points2D.multiply(c1, t), c0), t));
        }
        if (!result.isEmpty()) {
            return new IntersectionResult(IntersectionStatus.INTERSECTION, result);
        }
        return IntersectEllipsePoint.intersectPointEllipse(p0, ec, rx, ry);
    }
}

