/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectPointRay;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectCubicCurveRay {
    private IntersectCubicCurveRay() {
    }

    public static @NonNull IntersectionResult intersectCubicCurveRay(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double box, double boy, double bdx, double bdy, double maxT, double epsilon) {
        return IntersectCubicCurveRay.intersectCubicCurveRay(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(a3x, a3y), new Point2D.Double(box, boy), new Point2D.Double(bdx, bdy), maxT, epsilon);
    }

    public static @NonNull IntersectionResult intersectCubicCurveRay(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull Point2D a2, @NonNull Point2D a3, @NonNull Point2D bo, @NonNull Point2D bd) {
        return IntersectCubicCurveRay.intersectCubicCurveRay(a0, a1, a2, a3, bo, bd, Double.MAX_VALUE, 1.0E-8);
    }

    public static IntersectionResult intersectCubicCurveRay(@NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2, @NonNull Point2D p3, @NonNull Point2D ao, @NonNull Point2D ad, double maxT, double epsilon) {
        Point2D.Double topLeft = Intersections.topLeft(ao, Points2D.add(ao, ad));
        Point2D.Double bottomRight = Intersections.bottomRight(ao, Points2D.add(ao, ad));
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double c3 = Points2D.sum(Points2D.multiply(p0, -1.0), Points2D.multiply(p1, 3.0), Points2D.multiply(p2, -3.0), p3);
        Point2D.Double c2 = Points2D.sum(Points2D.multiply(p0, 3.0), Points2D.multiply(p1, -6.0), Points2D.multiply(p2, 3.0));
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -3.0), Points2D.multiply(p1, 3.0));
        Point2D c0 = p0;
        double aoy = ao.getY();
        double a1y = aoy + ad.getY();
        double aox = ao.getX();
        double a1x = aox + ad.getX();
        Point2D.Double n = new Point2D.Double(ad.getY(), -ad.getX());
        double cl = aox * a1y - a1x * aoy;
        double[] roots = new Polynomial(Points2D.dotProduct(n, c3), Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl).getRoots();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            if (!(-epsilon <= t) || !(t <= 1.0 + epsilon)) continue;
            Point2D.Double p5 = Lines.lerp(p0, p1, t);
            Point2D.Double p6 = Lines.lerp(p1, p2, t);
            Point2D.Double p7 = Lines.lerp(p2, p3, t);
            Point2D.Double p8 = Lines.lerp(p5, p6, t);
            Point2D.Double p9 = Lines.lerp(p6, p7, t);
            Point2D.Double p10 = Lines.lerp(p8, p9, t);
            double rayT = IntersectPointRay.projectedPointOnRay(aox, aoy, ad.getX(), ad.getY(), p10.getX(), p10.getY());
            if (!(-epsilon <= rayT) || !(rayT <= maxT)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p10, t));
        }
        return new IntersectionResult(status, result);
    }

    public static @NonNull IntersectionResult intersectRayCubicCurve(double a0x, double a0y, double a1x, double a1y, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, double epsilon) {
        Point2D.Double a0 = new Point2D.Double(a0x, a0y);
        Point2D.Double a1 = new Point2D.Double(a1x, a1y);
        Point2D.Double p0 = new Point2D.Double(p0x, p0y);
        Point2D.Double p1 = new Point2D.Double(p1x, p1y);
        Point2D.Double p2 = new Point2D.Double(p2x, p2y);
        Point2D.Double p3 = new Point2D.Double(p3x, p3y);
        return IntersectCubicCurveRay.intersectRayCubicCurve(a0, a1, maxT, p0, p1, p2, p3, 1.0E-8);
    }

    public static @NonNull IntersectionResult intersectRayCubicCurve(@NonNull Point2D ao, @NonNull Point2D ad, double maxT, @NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2, @NonNull Point2D p3, double epsilon) {
        double a0x = ao.getX();
        double a0y = ao.getY();
        double a1x = a0x + ad.getX();
        double a1y = a0y + ad.getY();
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double c3 = Points2D.sum(Points2D.multiply(p0, -1.0), Points2D.multiply(p1, 3.0), Points2D.multiply(p2, -3.0), p3);
        Point2D.Double c2 = Points2D.sum(Points2D.multiply(p0, 3.0), Points2D.multiply(p1, -6.0), Points2D.multiply(p2, 3.0));
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -3.0), Points2D.multiply(p1, 3.0));
        Point2D c0 = p0;
        Point2D.Double n = new Point2D.Double(a0y - a1y, a1x - a0x);
        double cl = a0x * a1y - a1x * a0y;
        Polynomial polynomial = new Polynomial(Points2D.dotProduct(n, c3), Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl);
        double[] roots = polynomial.getRoots();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            Point2D.Double p9;
            if (!(-epsilon <= t) || !(t <= 1.0 + epsilon)) continue;
            Point2D.Double p5 = Lines.lerp(p0, p1, t);
            Point2D.Double p6 = Lines.lerp(p1, p2, t);
            Point2D.Double p7 = Lines.lerp(p2, p3, t);
            Point2D.Double p8 = Lines.lerp(p5, p6, t);
            Point2D.Double p10 = Lines.lerp(p8, p9 = Lines.lerp(p6, p7, t), t);
            double t1 = IntersectLinePoint.argumentOnLine(a0x, a0y, a1x, a1y, p10.getX(), p10.getY());
            if (!(-epsilon <= t1) || !(t1 <= maxT)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p10, t1));
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectRayCubicCurveEx(double aox, double aoy, double adx, double ady, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, double epsilon) {
        IntersectionResult result = IntersectCubicCurveRay.intersectCubicCurveRay(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y, aox, aoy, adx, ady, maxT, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = CubicCurves.eval(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y, ip.getArgumentA());
            list.add(new IntersectionPointEx(x, y, IntersectLinePoint.argumentOnLine(aox, aoy, adx, ady, x, y), adx, ady, ip.getArgumentA(), pdA.dx(), pdA.dy()));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResultEx intersectRayCubicCurveEx(double aox, double aoy, double adx, double ady, double maxT, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double b3x, double b3y) {
        return IntersectCubicCurveRay.intersectRayCubicCurveEx(aox, aoy, adx, ady, maxT, b0x, b0y, b1x, b1y, b2x, b2y, b3x, b3y, 1.0E-8);
    }

    public static IntersectionResultEx intersectCubicCurveRayEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double b0x, double b0y, double b1x, double b1y, double maxT, double epsilon) {
        IntersectionResult result = IntersectCubicCurveRay.intersectCubicCurveRay(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, b0x, b0y, b1x, b1y, maxT, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = CubicCurves.eval(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, ip.getArgumentA());
            list.add(new IntersectionPointEx(x, y, ip.getArgumentA(), pdA.dx(), pdA.dy(), IntersectLinePoint.argumentOnLine(b0x, b0y, b1x, b1y, x, y), b1x - b0x, b1y - b0y));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResultEx intersectCubicCurveRayEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double b0x, double b0y, double b1x, double b1y, double maxT) {
        return IntersectCubicCurveRay.intersectCubicCurveRayEx(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, b0x, b0y, b1x, b1y, maxT, 1.0E-8);
    }
}

