/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectEllipseEllipse {
    private IntersectEllipseEllipse() {
    }

    public static @NonNull IntersectionResult intersectEllipseEllipse(@NonNull Point2D c1, double rx1, double ry1, @NonNull Point2D c2, double rx2, double ry2) {
        return IntersectEllipseEllipse.intersectEllipseEllipse(c1.getX(), c1.getY(), rx1, ry1, c2.getX(), c2.getY(), rx2, ry2);
    }

    public static @NonNull IntersectionResult intersectEllipseEllipse(double cx1, double cy1, double rx1, double ry1, double cx2, double cy2, double rx2, double ry2) {
        return IntersectEllipseEllipse.intersectEllipseEllipse(cx1, cy1, rx1, ry1, cx2, cy2, rx2, ry2, 1.0E-8);
    }

    public static @NonNull IntersectionResult intersectEllipseEllipse(double cx1, double cy1, double rx1, double ry1, double cx2, double cy2, double rx2, double ry2, double epsilon) {
        double[] a = new double[]{ry1 * ry1, 0.0, rx1 * rx1, -2.0 * ry1 * ry1 * cx1, -2.0 * rx1 * rx1 * cy1, ry1 * ry1 * cx1 * cx1 + rx1 * rx1 * cy1 * cy1 - rx1 * rx1 * ry1 * ry1};
        double[] b = new double[]{ry2 * ry2, 0.0, rx2 * rx2, -2.0 * ry2 * ry2 * cx2, -2.0 * rx2 * rx2 * cy2, ry2 * ry2 * cx2 * cx2 + rx2 * rx2 * cy2 * cy2 - rx2 * rx2 * ry2 * ry2};
        Polynomial yPoly = Intersections.bezout(a, b);
        double[] yRoots = yPoly.getRoots();
        double norm0 = (a[0] * a[0] + 2.0 * a[1] * a[1] + a[2] * a[2]) * 1.1641532182693481E-10;
        double norm1 = (b[0] * b[0] + 2.0 * b[1] * b[1] + b[2] * b[2]) * 1.1641532182693481E-10;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        for (double yRoot : yRoots) {
            double[] xRoots;
            Polynomial xPoly = new Polynomial(a[0], a[3] + yRoot * a[1], a[5] + yRoot * (a[4] + yRoot * a[2]));
            for (double xRoot : xRoots = xPoly.getRoots()) {
                double test = (a[0] * xRoot + a[1] * yRoot + a[3]) * xRoot + (a[2] * yRoot + a[4]) * yRoot + a[5];
                if (!(Math.abs(test) < norm0) || !(Math.abs(test = (b[0] * xRoot + b[1] * yRoot + b[3]) * xRoot + (b[2] * yRoot + b[4]) * yRoot + b[5]) < norm1)) continue;
                result.add(new IntersectionPoint(new Point2D.Double(xRoot, yRoot), Double.NaN));
            }
        }
        return new IntersectionResult(result.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, result);
    }

    public static IntersectionResultEx intersectEllipseEllipseEx(double cx1, double cy1, double rx1, double ry1, double cx2, double cy2, double rx2, double ry2) {
        return IntersectEllipseEllipse.intersectEllipseEllipseEx(cx1, cy1, rx1, ry1, cx2, cy2, rx2, ry2, 1.0E-8);
    }

    public static IntersectionResultEx intersectEllipseEllipseEx(double cx1, double cy1, double rx1, double ry1, double cx2, double cy2, double rx2, double ry2, double epsilon) {
        IntersectionResult result = IntersectEllipseEllipse.intersectEllipseEllipse(cx1, cy1, rx1, ry1, cx2, cy2, rx2, ry2, epsilon);
        @NonNull ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double px = ip.getX();
            double py = ip.getY();
            list.add(new IntersectionPointEx(px, py, ip.getArgumentA(), py - cy1, cx1 - px, Double.NaN, py - cy2, cx2 - px));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

