/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectEllipsePoint {
    private IntersectEllipsePoint() {
    }

    public static @NonNull IntersectionResult intersectPointEllipse(@NonNull Point2D point, @NonNull Point2D center, double rx, double ry) {
        IntersectionStatus status;
        double cy;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        double px = point.getX();
        double py = point.getY();
        double cx = center.getX();
        double det = (px - cx) * (px - cx) / (rx * rx) + (py - (cy = center.getY())) * (py - cy) / (ry * ry);
        if (Math.abs(det) - 1.0 >= 1.0E-8) {
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(new Point2D.Double(px, py), 0.0));
        } else {
            status = det < 1.0 ? IntersectionStatus.NO_INTERSECTION_INSIDE : IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        }
        return new IntersectionResult(status, result);
    }
}

