/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectEllipsePoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectEllipseQuadCurve {
    private IntersectEllipseQuadCurve() {
    }

    public static @NonNull IntersectionResult intersectQuadCurveEllipse(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double bcx, double bcy, double brx, double bry) {
        return IntersectEllipseQuadCurve.intersectQuadCurveEllipse(a0x, a0y, a1x, a1y, a2x, a2y, bcx, bcy, brx, bry, 1.0E-8);
    }

    public static @NonNull IntersectionResult intersectQuadCurveEllipse(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double bcx, double bcy, double brx, double bry, double epsilon) {
        return IntersectEllipseQuadCurve.intersectQuadCurveEllipse(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(bcx, bcy), brx, bry, epsilon);
    }

    public static @NonNull IntersectionResultEx intersectQuadCurveEllipseEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double bcx, double bcy, double brx, double bry) {
        return IntersectEllipseQuadCurve.intersectQuadCurveEllipseEx(a0x, a0y, a1x, a1y, a2x, a2y, bcx, bcy, brx, bry, 1.0E-8);
    }

    public static @NonNull IntersectionResultEx intersectQuadCurveEllipseEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double bcx, double bcy, double brx, double bry, double epsilon) {
        IntersectionResult result = IntersectEllipseQuadCurve.intersectQuadCurveEllipse(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(bcx, bcy), brx, bry, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = QuadCurves.eval(a0x, a0y, a1x, a1y, a2x, a2y, ip.getArgumentA());
            double argumentB = Angles.atan2Ellipse(bcx, bcy, brx, bry, x, y);
            list.add(new IntersectionPointEx(x, y, ip.getArgumentA(), pdA.dx(), pdA.dy(), argumentB, x - bcx, bcy - y));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static @NonNull IntersectionResult intersectQuadCurveEllipse(@NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2, @NonNull Point2D c, double rx, double ry) {
        return IntersectEllipseQuadCurve.intersectQuadCurveEllipse(p0, p1, p2, c, rx, ry, 1.0E-8);
    }

    public static @NonNull IntersectionResult intersectQuadCurveEllipse(@NonNull Point2D p0, @NonNull Point2D p1, @NonNull Point2D p2, @NonNull Point2D c, double rx, double ry, double epsilon) {
        Point2D.Double c2 = Points2D.sum(p0, Points2D.multiply(p1, -2.0), p2);
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -2.0), Points2D.multiply(p1, 2.0));
        Point2D.Double c0 = new Point2D.Double(p0.getX(), p0.getY());
        double rxrx = rx * rx;
        double ryry = ry * ry;
        double cx2 = c2.getX();
        double cy2 = c2.getY();
        double cx1 = c1.getX();
        double cy1 = c1.getY();
        double cx0 = c0.getX();
        double cy0 = c0.getY();
        double ecx = c.getX();
        double ecy = c.getY();
        double[] roots = new Polynomial(ryry * cx2 * cx2 + rxrx * cy2 * cy2, 2.0 * (ryry * cx2 * cx1 + rxrx * cy2 * cy1), ryry * (2.0 * cx2 * cx0 + cx1 * cx1) + rxrx * (2.0 * cy2 * cy0 + cy1 * cy1) - 2.0 * (ryry * ecx * cx2 + rxrx * ecy * cy2), 2.0 * (ryry * cx1 * (cx0 - ecx) + rxrx * cy1 * (cy0 - ecy)), ryry * (cx0 * cx0 + ecx * ecx) + rxrx * (cy0 * cy0 + ecy * ecy) - 2.0 * (ryry * ecx * cx0 + rxrx * ecy * cy0) - rxrx * ryry).getRoots();
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        for (double t : roots) {
            if (!(-epsilon <= t) || !(t <= 1.0 + epsilon)) continue;
            result.add(new IntersectionPoint(Points2D.sum(Points2D.multiply(c2, t * t), Points2D.multiply(c1, t), c0), t));
        }
        if (result.isEmpty()) {
            return IntersectEllipsePoint.intersectPointEllipse(p0, c, rx, ry);
        }
        IntersectionStatus status = IntersectionStatus.INTERSECTION;
        return new IntersectionResult(status, result);
    }

    public static @NonNull IntersectionResult intersectEllipseQuadCurve(double acx, double acy, double arx, double ary, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y) {
        IntersectionResult resultB = IntersectEllipseQuadCurve.intersectQuadCurveEllipse(new Point2D.Double(b0x, b0y), new Point2D.Double(b1x, b1y), new Point2D.Double(b2x, b2y), new Point2D.Double(acx, acy), arx, ary);
        ArrayList<IntersectionPoint> list = new ArrayList<IntersectionPoint>();
        for (IntersectionPoint ip : resultB.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            list.add(new IntersectionPoint(x, y, Angles.atan2Ellipse(acx, acy, arx, ary, x, y)));
        }
        return new IntersectionResult(resultB.getStatus(), list);
    }

    public static @NonNull IntersectionResultEx intersectEllipseQuadCurveEx(double acx, double acy, double arx, double ary, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y) {
        return IntersectEllipseQuadCurve.intersectEllipseQuadCurveEx(acx, acy, arx, ary, b0x, b0y, b1x, b1y, b2x, b2y, 1.0E-8);
    }

    public static @NonNull IntersectionResultEx intersectEllipseQuadCurveEx(double acx, double acy, double arx, double ary, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double epsilon) {
        IntersectionResultEx resultB = IntersectEllipseQuadCurve.intersectQuadCurveEllipseEx(b0x, b0y, b1x, b1y, b2x, b2y, acx, acy, arx, ary, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : resultB.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdB = QuadCurves.eval(b0x, b0y, b1x, b1y, b2x, b2y, ip.getArgumentA());
            list.add(new IntersectionPointEx(x, y, Angles.atan2Ellipse(acx, acy, arx, ary, x, y), x - acx, acy - y, ip.getArgumentA(), pdB.dx(), pdB.dy()));
        }
        return new IntersectionResultEx(resultB.getStatus(), list);
    }
}

