/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectCubicCurveLine;
import org.jhotdraw8.geom.intersect.IntersectCubicCurveRay;
import org.jhotdraw8.geom.intersect.IntersectLineLine;
import org.jhotdraw8.geom.intersect.IntersectLineQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectLineRay;
import org.jhotdraw8.geom.intersect.IntersectQuadCurveRay;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectLinePathIterator {
    private IntersectLinePathIterator() {
    }

    public static @NonNull IntersectionResultEx intersectLinePathIteratorEx(double a0x, double a0y, double a1x, double a1y, @NonNull PathIterator pit) {
        return IntersectLinePathIterator.intersectLinePathIteratorEx(a0x, a0y, a1x, a1y, pit, 1.0);
    }

    public static @NonNull IntersectionResultEx intersectLinePathIteratorEx(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull PathIterator pit, double maxT) {
        return IntersectLinePathIterator.intersectLinePathIteratorEx(a0.getX(), a0.getY(), a1.getX(), a1.getY(), pit, maxT);
    }

    public static @NonNull IntersectionResultEx intersectLinePathIteratorEx(double a0x, double a0y, double a1x, double a1y, @NonNull PathIterator pit, double maxT) {
        ArrayList<IntersectionPointEx> lineIntersections = new ArrayList<IntersectionPointEx>();
        ArrayList<IntersectionPointEx> insideIntersections = new ArrayList<IntersectionPointEx>();
        double[] seg = new double[6];
        double firstx = 0.0;
        double firsty = 0.0;
        double lastx = 0.0;
        double lasty = 0.0;
        boolean intersectionCount = false;
        int clockwiseCrossingsSum = 0;
        int counterClockwiseCrossingsSum = 0;
        int clockwiseCrossings = 0;
        int counterClockwiseCrossings = 0;
        int segment = 0;
        int windingRule = pit.getWindingRule();
        boolean hasTangent = false;
        while (!pit.isDone()) {
            IntersectionResultEx rayCheck;
            IntersectionResultEx boundaryCheck;
            int type = pit.currentSegment(seg);
            switch (type) {
                case 4: {
                    boundaryCheck = IntersectLineLine.intersectLineLineEx(a0x, a0y, a1x, a1y, lastx, lasty, firstx, firsty);
                    rayCheck = IntersectLineRay.intersectRayLineEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, firstx, firsty, 1.0E-8);
                    break;
                }
                case 3: {
                    double x = seg[4];
                    double y = seg[5];
                    boundaryCheck = IntersectCubicCurveLine.intersectLineCubicCurveEx(a0x, a0y, a1x, a1y, lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y);
                    rayCheck = IntersectCubicCurveRay.intersectRayCubicCurveEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 1: {
                    double x = seg[0];
                    double y = seg[1];
                    boundaryCheck = IntersectLineLine.intersectLineLineEx(a0x, a0y, a1x, a1y, lastx, lasty, x, y);
                    rayCheck = IntersectLineRay.intersectRayLineEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 0: {
                    lastx = firstx = seg[0];
                    lasty = firsty = seg[1];
                    boundaryCheck = null;
                    rayCheck = null;
                    break;
                }
                case 2: {
                    double x = seg[2];
                    double y = seg[3];
                    boundaryCheck = IntersectLineQuadCurve.intersectLineQuadCurveEx(a0x, a0y, a1x, a1y, lastx, lasty, seg[0], seg[1], x, y);
                    rayCheck = IntersectQuadCurveRay.intersectRayQuadCurveEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, seg[0], seg[1], x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                default: {
                    boundaryCheck = null;
                    rayCheck = null;
                }
            }
            if (boundaryCheck != null && boundaryCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx isect : boundaryCheck.intersections()) {
                    lineIntersections.add(isect.withSegment2(segment));
                }
            }
            if (rayCheck != null && rayCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx ip : rayCheck.intersections()) {
                    double ty = ip.getDerivativeB().getY();
                    if (Points.almostZero(ty)) continue;
                    if (ty > 0.0) {
                        ++clockwiseCrossings;
                        continue;
                    }
                    ++counterClockwiseCrossings;
                }
            }
            switch (type) {
                case 4: {
                    clockwiseCrossingsSum += clockwiseCrossings;
                    counterClockwiseCrossingsSum += counterClockwiseCrossings;
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                    if (windingRule == 0) {
                        if ((clockwiseCrossingsSum + counterClockwiseCrossingsSum) % 2 != 1) break;
                        insideIntersections.add(new IntersectionPointEx(a0x, a0y, 0.0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, segment));
                        break;
                    }
                    if (windingRule != 1 || clockwiseCrossingsSum == counterClockwiseCrossingsSum) break;
                    insideIntersections.add(new IntersectionPointEx(a0x, a0y, 0.0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, segment));
                    break;
                }
                case 0: {
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                }
            }
            pit.next();
        }
        if (!lineIntersections.isEmpty()) {
            return new IntersectionResultEx(lineIntersections);
        }
        if (!insideIntersections.isEmpty()) {
            return new IntersectionResultEx(IntersectionStatus.NO_INTERSECTION_INSIDE, insideIntersections);
        }
        return new IntersectionResultEx(List.of());
    }

    public static @NonNull IntersectionResultEx intersectLinePathIteratorEx(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull PathIterator pit) {
        IntersectionResultEx i = IntersectLinePathIterator.intersectLinePathIteratorEx(a0, a1, pit, 1.0);
        if (i.getStatus() == IntersectionStatus.INTERSECTION && ((IntersectionPointEx)i.intersections().getFirst()).getArgumentA() > 1.0) {
            return new IntersectionResultEx(IntersectionStatus.NO_INTERSECTION, new ArrayList<IntersectionPointEx>());
        }
        return i;
    }
}

