/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.Rectangles;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectLinePoint {
    private IntersectLinePoint() {
    }

    public static @NonNull IntersectionResult intersectLinePoint(double x0, double y0, double x1, double y1, double cx, double cy, double r) {
        double y;
        double t;
        double x;
        double dd;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        double \u0394x = x1 - x0;
        double \u0394y = y1 - y0;
        double a = \u0394x * \u0394x + \u0394y * \u0394y;
        double b = 2.0 * (\u0394x * (x0 - cx) + \u0394y * (y0 - cy));
        double[] roots = new Polynomial(2.0 * a, b).getRoots();
        if (roots.length > 0 && (dd = ((x = x0 + (t = Math.max(0.0, Math.min(roots[0], 1.0))) * \u0394x) - cx) * (x - cx) + ((y = y0 + t * \u0394y) - cy) * (y - cy)) <= r * r) {
            result.add(new IntersectionPoint(new Point2D.Double(x, y), t));
        }
        return new IntersectionResult(result.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, result);
    }

    public static @NonNull IntersectionResultEx intersectLinePointEx(double x0, double y0, double x1, double y1, double cx, double cy, double r) {
        IntersectionResult result = IntersectLinePoint.intersectLinePoint(x0, y0, x1, y1, cx, cy, r);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            list.add(new IntersectionPointEx(x, y, ip.getArgumentA(), x1 - x0, y1 - y0, 0.0, 1.0, 0.0));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static boolean lineContainsPoint(double x1, double y1, double x2, double y2, double px, double py) {
        return IntersectLinePoint.lineContainsPoint(x1, y1, x2, y2, px, py, 1.0E-8);
    }

    public static boolean lineContainsPoint(double x1, double y1, double x2, double y2, double px, double py, double tolerance) {
        if (!Rectangles.contains(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1), px, py, tolerance)) {
            return false;
        }
        if (Points.almostEqual(x1, x2, tolerance)) {
            return Math.abs(px - x1) <= tolerance;
        }
        if (Points.almostEqual(y1, y2, tolerance)) {
            return Math.abs(py - y1) <= tolerance;
        }
        double a = (y1 - y2) / (x1 - x2);
        double b = y1 - a * x1;
        double x = (py - b) / a;
        double y = a * px + b;
        return Math.min(Math.abs(x - px), Math.abs(y - py)) <= tolerance;
    }

    public static double argumentOnLine(double x1, double y1, double x2, double y2, double px, double py) {
        double w = x2 - x1;
        double h = y2 - y1;
        if (Math.abs(w) > Math.abs(h)) {
            return (px - x1) / w;
        }
        return (py - y1) / h;
    }
}

