/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectPointQuadCurve {
    private IntersectPointQuadCurve() {
    }

    public static @NonNull IntersectionResult intersectQuadCurvePoint(double x0, double y0, double x1, double y1, double x2, double y2, double cx, double cy, double r) {
        double c2x = x0 - 2.0 * x1 + x2;
        double c2y = y0 - 2.0 * y1 + y2;
        double c1x = -2.0 * (x0 - x1);
        double c1y = -2.0 * (y0 - y1);
        double c0x = x0;
        double c0y = y0;
        double a = c2x * c2x + c2y * c2y;
        double b = 2.0 * (c1x * c2x + c1y * c2y);
        double c = c1x * c1x + c1y * c1y + 2.0 * c0x * c2x + 2.0 * c0y * c2y - 2.0 * c2x * cx - 2.0 * c2y * cy;
        double d = 2.0 * (c0x * c1x + c0y * c1y - c1x * cx - c1y * cy);
        double[] roots = new Polynomial(4.0 * a, 3.0 * b, 2.0 * c, d).getRoots();
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double p1 = new Point2D.Double(x0, y0);
        Point2D.Double p2 = new Point2D.Double(x1, y1);
        Point2D.Double p3 = new Point2D.Double(x2, y2);
        double rr = r * r;
        double bestDistance = Double.POSITIVE_INFINITY;
        for (double tt : roots) {
            Point2D.Double p;
            if (tt < 0.0) {
                p = p1;
            } else if (tt > 1.0) {
                p = p3;
            } else {
                double t = tt;
                p = Points2D.sum(Points2D.multiply(p1, (1.0 - t) * (1.0 - t)), Points2D.multiply(p2, 2.0 * (1.0 - t) * t), Points2D.multiply(p3, t * t));
            }
            double dd = (p.getX() - cx) * (p.getX() - cx) + (p.getY() - cy) * (p.getY() - cy);
            if (!(dd < rr)) continue;
            if (Math.abs(dd - bestDistance) < 1.0E-8) {
                result.add(new IntersectionPoint(p, tt));
                continue;
            }
            if (!(dd < bestDistance)) continue;
            bestDistance = dd;
            result.clear();
            result.add(new IntersectionPoint(p, tt));
        }
        return new IntersectionResult(result.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, result);
    }

    public static @NonNull IntersectionResultEx intersectQuadCurvePointEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double cx, double cy, double epsilon) {
        IntersectionResult result = IntersectPointQuadCurve.intersectQuadCurvePoint(a0x, a0y, a1x, a1y, a2x, a2y, cx, cy, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = QuadCurves.eval(a0x, a0y, a1x, a1y, a2x, a2y, ip.getArgumentA());
            list.add(new IntersectionPointEx(x, y, ip.getArgumentA(), pdA.dx(), pdA.dy(), 0.0, 1.0, 0.0));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

