/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.intersect.IntersectLinePolygon;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectPolygonRectangle {
    private IntersectPolygonRectangle() {
    }

    public static @NonNull IntersectionResultEx intersectPolygonRectangleEx(@NonNull List<Point2D.Double> points, @NonNull Point2D r0, @NonNull Point2D r1) {
        Point2D.Double topLeft = Intersections.topLeft(r0, r1);
        Point2D.Double bottomRight = Intersections.bottomRight(r0, r1);
        Point2D.Double topRight = new Point2D.Double(bottomRight.getX(), topLeft.getY());
        Point2D.Double bottomLeft = new Point2D.Double(topLeft.getX(), bottomRight.getY());
        IntersectionResultEx inter1 = IntersectLinePolygon.intersectLinePolygonEx(topLeft, topRight, points);
        IntersectionResultEx inter2 = IntersectLinePolygon.intersectLinePolygonEx(topRight, bottomRight, points);
        IntersectionResultEx inter3 = IntersectLinePolygon.intersectLinePolygonEx(bottomRight, bottomLeft, points);
        IntersectionResultEx inter4 = IntersectLinePolygon.intersectLinePolygonEx(bottomLeft, topLeft, points);
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        result.addAll(inter1.intersections().asList());
        result.addAll(inter2.intersections().asList());
        result.addAll(inter3.intersections().asList());
        result.addAll(inter4.intersections().asList());
        return new IntersectionResultEx(result);
    }
}

