/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectQuadCurveQuadCurve {
    private static final double CURVE_A_B_TOLERANCE = 0.001;
    private static final double ROOT_X_Y_TOLERANCE = 1.0E-4;

    private IntersectQuadCurveQuadCurve() {
    }

    public static @NonNull IntersectionResult intersectQuadCurveQuadCurve(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y) {
        return IntersectQuadCurveQuadCurve.intersectQuadCurveQuadCurve(a0x, a0y, a1x, a1y, a2x, a2y, b0x, b0y, b1x, b1y, b2x, b2y, 1.0E-8);
    }

    public static @NonNull IntersectionResultEx intersectQuadCurveQuadCurveEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y) {
        return IntersectQuadCurveQuadCurve.intersectQuadCurveQuadCurveEx(a0x, a0y, a1x, a1y, a2x, a2y, b0x, b0y, b1x, b1y, b2x, b2y, 1.0E-8);
    }

    public static @NonNull IntersectionResultEx intersectQuadCurveQuadCurveEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double epsilon) {
        IntersectionResult resultA = IntersectQuadCurveQuadCurve.intersectQuadCurveQuadCurve(a0x, a0y, a1x, a1y, a2x, a2y, b0x, b0y, b1x, b1y, b2x, b2y, epsilon);
        IntersectionResult resultB = IntersectQuadCurveQuadCurve.intersectQuadCurveQuadCurve(b0x, b0y, b1x, b1y, b2x, b2y, a0x, a0y, a1x, a1y, a2x, a2y, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ipA : resultA.intersections()) {
            double x = ipA.getX();
            double y = ipA.getY();
            double argumentB = Double.NaN;
            for (IntersectionPoint ipB : resultB.intersections()) {
                if (!Points.almostEqual(ipA, ipB, 0.001)) continue;
                argumentB = ipB.argumentA;
                break;
            }
            if (Double.isNaN(argumentB)) continue;
            PointAndDerivative pdA = QuadCurves.eval(a0x, a0y, a1x, a1y, a2x, a2y, ipA.getArgumentA());
            PointAndDerivative pdB = QuadCurves.eval(b0x, b0y, b1x, b1y, b2x, b2y, argumentB);
            list.add(new IntersectionPointEx(x, y, ipA.getArgumentA(), pdA.dx(), pdA.dy(), argumentB, pdB.dx(), pdB.dy()));
        }
        return new IntersectionResultEx(resultA.getStatus(), list);
    }

    public static @NonNull IntersectionResult intersectQuadCurveQuadCurve(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double epsilon) {
        return IntersectQuadCurveQuadCurve.intersectQuadCurveQuadCurve(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(b0x, b0y), new Point2D.Double(b1x, b1y), new Point2D.Double(b2x, b2y), epsilon);
    }

    public static @NonNull IntersectionResult intersectQuadCurveQuadCurve(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull Point2D a2, @NonNull Point2D b0, @NonNull Point2D b1, @NonNull Point2D b2, double epsilon) {
        Polynomial poly;
        Point2D.Double c12 = Points2D.add(a0, Points2D.add(Points2D.multiply(a1, -2.0), a2));
        Point2D.Double c11 = Points2D.add(Points2D.multiply(a0, -2.0), Points2D.multiply(a1, 2.0));
        Point2D c10 = a0;
        Point2D.Double c22 = Points2D.add(b0, Points2D.add(Points2D.multiply(b1, -2.0), b2));
        Point2D.Double c21 = Points2D.add(Points2D.multiply(b0, -2.0), Points2D.multiply(b1, 2.0));
        Point2D c20 = b0;
        double c12x = ((Point2D)c12).getX();
        double c10y = c10.getY();
        double c20y = c20.getY();
        double c11x = ((Point2D)c11).getX();
        double c11y = ((Point2D)c11).getY();
        double c22y = ((Point2D)c22).getY();
        double c21y = ((Point2D)c21).getY();
        double c21x = ((Point2D)c21).getX();
        double c22x = ((Point2D)c22).getX();
        double c10x = c10.getX();
        double c20x = c20.getX();
        double c12y = ((Point2D)c12).getY();
        if (c12y == 0.0) {
            v0 = c12x * (c10y - c20y);
            v1 = v0 - c11x * c11y;
            double v3 = c11y * c11y;
            poly = new Polynomial(c12x * c22y * c22y, 2.0 * c12x * c21y * c22y, c12x * c21y * c21y - c22x * v3 - c22y * v0 - c22y * v1, -c21x * v3 - c21y * v0 - c21y * v1, (c10x - c20x) * v3 + (c10y - c20y) * v1);
        } else {
            v0 = c12x * c22y - c12y * c22x;
            v1 = c12x * c21y - c21x * c12y;
            double v2 = c11x * c12y - c11y * c12x;
            double v3 = c10y - c20y;
            double v4 = c12y * (c10x - c20x) - c12x * v3;
            double v5 = -c11y * v2 + c12y * v4;
            double v6 = v2 * v2;
            poly = new Polynomial(v0 * v0, 2.0 * v0 * v1, (-c22y * v6 + c12y * v1 * v1 + c12y * v0 * v4 + v0 * v5) / c12y, (-c21y * v6 + c12y * v1 * v4 + v1 * v5) / c12y, (v3 * v6 + v4 * v5) / c12y);
        }
        double[] roots = poly.getRoots();
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        block0: for (double s : roots) {
            if (!(-epsilon <= s) || !(s <= 1.0 + epsilon)) continue;
            double[] xRoots = new Polynomial(c12x, c11x, c10x - c20x - s * c21x - s * s * c22x).getRoots();
            double[] yRoots = new Polynomial(c12y, c11y, c10y - c20y - s * c21y - s * s * c22y).getRoots();
            if (xRoots.length <= 0 || yRoots.length <= 0) continue;
            for (double xRoot : xRoots) {
                if (!(0.0 <= xRoot) || !(xRoot <= 1.0)) continue;
                for (double yRoot : yRoots) {
                    if (!(Math.abs(xRoot - yRoot) < 1.0E-4)) continue;
                    result.add(new IntersectionPoint(Points2D.add(Points2D.multiply(c22, s * s), Points2D.add(Points2D.multiply(c21, s), c20)), xRoot));
                    continue block0;
                }
            }
        }
        return new IntersectionResult(result.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, result);
    }
}

